 ###########################################################################
 ##                                                                       ##
 ##                Centre for Speech Technology Research                  ##
 ##                     University of Edinburgh, UK                       ##
 ##                         Copyright (c) 1996                            ##
 ##                        All Rights Reserved.                           ##
 ##                                                                       ##
 ##  Permission to use, copy, modify, distribute this software and its    ##
 ##  documentation for research, educational and individual use only, is  ##
 ##  hereby granted without fee, subject to the following conditions:     ##
 ##   1. The code must retain the above copyright notice, this list of    ##
 ##      conditions and the following disclaimer.                         ##
 ##   2. Any modifications must be clearly marked as such.                ##
 ##   3. Original authors' names are not deleted.                         ##
 ##  This software may not be used for commercial purposes without        ##
 ##  specific prior written permission from the authors.                  ##
 ##                                                                       ##
 ##  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ##
 ##  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ##
 ##  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ##
 ##  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ##
 ##  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ##
 ##  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ##
 ##  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ##
 ##  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ##
 ##  THIS SOFTWARE.                                                       ##
 ##                                                                       ##
 ###########################################################################
 ##                                                                       ##
 ##                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             ##
 ##                   Date: Thu May 28 1998                               ##
 ## --------------------------------------------------------------------  ##
 ## Definitions for including WFST system.                                ##
 ##                                                                       ##
 ###########################################################################

INCLUDE_WFST=1

MOD_DESC_WFST=Weighted finite state transducers

# add sub directory to grammar directory

ifeq ($(DIRNAME),grammar)
    EXTRA_LIB_BUILD_DIRS := $(EXTRA_LIB_BUILD_DIRS) wfst
endif

# add extra programs to main

ifeq ($(DIRNAME),main)
    MAINSRCS := $(MAINSRCS) \
	wfst_build_main.cc wfst_run_main.cc
endif

# check scheme is available.

ifndef INCLUDE_SIOD
.config_error:: FORCE
	@echo "+--------------------------------------------------"
	@echo "| Must include SIOD to use wfst"
	@echo "+--------------------------------------------------"
	@exit 1
endif

