/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                     Copyright (c) 1994,1995,1996                      */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor and Alan W Black             */
/*                    Date   :  July 1996                                */
/*-----------------------------------------------------------------------*/
/*                   Safe(-er) allocation functions.                     */
/*                                                                       */
/*=======================================================================*/

#if !defined(__EST_WALLOC_H__)

#if defined(__cplusplus)
extern "C" {
#endif

void *safe_walloc(int size);
void *safe_wcalloc(int size);
void *safe_wrealloc(void *ptr, int size);
#define walloc(TYPE,SIZE) ((TYPE *)safe_walloc(sizeof(TYPE)*(SIZE)))
#define wcalloc(TYPE,SIZE) ((TYPE *)safe_wcalloc(sizeof(TYPE)*(SIZE)))
#define wrealloc(PTR,TYPE,SIZE) ((TYPE *)safe_wrealloc((void *)(PTR), sizeof(TYPE)*(SIZE)))
char *wstrdup(const char *s);
void wfree(void *p);

#if defined(__cplusplus)
}
#endif

#endif
