
 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/


#ifndef __EST_KVL_I_H__
#define __EST_KVL_I_H__

/** Instantiate rules for list template.
  * 
  * @author Richard Caley <rjc@cstr.ed.ac.uk>
  * @version $Id: EST_KVLI.h,v 1.1 1998/08/12 09:29:25 awb Exp $
  */

#include "instantiate/EST_TListI.h"

// Instantiation Macros

// the typedef is purely to get the type name through the following macro.

#define Instantiate_KVL_T(KEY, VAL, TAG) \
        template class KVL<KEY, VAL>; \
        template class KVI<KEY, VAL>; \
	typedef KVI<KEY, VAL> KVI_ ## TAG ## _t; \
	ostream &operator<<(ostream &s, KVI< KEY , VAL > const &i){  return s << i.k << "\t" << i.v << "\n"; } \
	ostream& operator << (ostream& s,  KVL< KEY , VAL > const &l) {EST_Litem *p; for (p = l.list.head(); p ; p = next(p)) s << l.list(p).k << "\t" << l.list(p).v << endl; return s;} \
        Instantiate_TList(KVI_ ## TAG ## _t)

// template ostream & operator<<(ostream &s, KVI<KEY, VAL> const &i); 

#define Instantiate_KVL(KEY, VAL) Instantiate_KVL_T(KEY, VAL, KEY ## VAL) 

#define Declare_KVL_T(KEY, VAL, TAG)

#define Declare_KVL_Base_T(KEY, VAL, DEFAULT,ERROR,TAG)

#define Declare_KVL_Class_T(KEY, VAL, DEFAULT,ERROR,TAG)

#define Declare_KVL(KEY, VAL) Declare_KVL_T(KEY, VAL, TYPE)

#define Declare_KVL_Base(KEY, VAL, DEFAULT,ERROR)  Declare_KVL_Base_T(KEY, VAL, DEFAULT,ERROR, KEY ## VAL)
#define Declare_KVL_Class(KEY, VAL, DEFAULT,ERROR) Declare_KVL_Class_T(KEY, VAL, DEFAULT,ERROR, KEY ## VAL)

#endif

