 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/


#ifndef __EST_TVECTOR_I_H__
#define __EST_TVECTOR_I_H__

/** Instantiate rules for vector template.
  * 
  * @author Richard Caley <rjc@cstr.ed.ac.uk>
  * @version $Id: EST_TVectorI.h,v 1.1 1998/08/12 09:29:25 awb Exp $
  */




// Instantiation Macros

#define Instantiate_TVector_T(TYPE,TAG) \
	template class EST_TVector<TYPE>; \
	\
	ostream& operator << (ostream &st, const EST_TVector< TYPE > &a) \
	{int i; for (i = 0; i < a.n(); ++i) st << a(i) << " "; st << endl; return st;}
	

#define Instantiate_TVector(TYPE) Instantiate_TVector_T(TYPE,TYPE)

#define Declare_TVector_T(TYPE,TAG)  \
	static TYPE const TAG##_vec_def_val_s; \
	static TYPE TAG##_vec_error_return_s; \
	\
	TYPE const *EST_TVector<TYPE>::def_val=&TAG##_vec_def_val_s; \
	TYPE *EST_TVector<TYPE>::error_return=&TAG##_vec_error_return_s;

#define Declare_TVector_Base_T(TYPE,DEFAULT,ERROR,TAG)  \
	static TYPE const TAG##_vec_def_val_s=DEFAULT; \
	static TYPE TAG##_vec_error_return_s=ERROR; \
	\
	TYPE const *EST_TVector<TYPE>::def_val=&TAG##_vec_def_val_s; \
	TYPE *EST_TVector<TYPE>::error_return=&TAG##_vec_error_return_s;

#define Declare_TVector_Class_T(TYPE,DEFAULT,ERROR,TAG)  \
	static TYPE const TAG##_vec_def_val_s(DEFAULT); \
	static TYPE TAG##_vec_error_return_s(ERROR); \
	\
	TYPE const *EST_TVector<TYPE>::def_val=&TAG##_vec_def_val_s; \
	TYPE *EST_TVector<TYPE>::error_return=&TAG##_vec_error_return_s;

#define Declare_TVector(TYPE) Declare_TVector_T(TYPE,TYPE)
#define Declare_TVector_Base(TYPE,DEFAULT,ERROR)  Declare_TVector_Base_T(TYPE,DEFAULT,ERROR,TYPE)
#define Declare_TVector_Class(TYPE,DEFAULT,ERROR) Declare_TVector_Class_T(TYPE,DEFAULT,ERROR,TYPE)

#endif

