 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/

#ifndef __EST_PP_MOD_H__
#define __EST_PP_MOD_H__

#include "EST_String.h"

/**@name Function types used for parameters to functions. */
//@{
/// Function which returns a shortened or lengthened version of a piece of signal.
typedef void	    EST_PpModFunc(const short *orig, int orig_length, 
				  short *mod, int mod_length);
//@}

/**
  * Pitch Period Modification Functions.
  * <p>
  * Various methods of modifying a section of residual to change the
  * length are available by name using these functions.
  * @author Richard Caley (rjc@cstr.ed.ac.uk) 
  * @version $Id: EST_PpMod.h,v 1.1 1998/08/12 09:29:25 awb Exp $
  */

class EST_PpMod {
public:
  /// A Function which modifies a pitch period.
  typedef EST_PpModFunc Func;

  /// Returns the modification function named.
  static Func *mod_function(const char *name);

  /// Returns a description of the function.
  static EST_String description(const char *name);

  /// Return a paragraph describing the available windows.
  static EST_String options_supported(void);

  /// Return a comma separated list of the available window types.
  static EST_String options_short(void);
};


#endif
