
package cstr.awt;

import java.util.*;
import java.lang.*;
import java.awt.*;
import java.awt.event.*;

import cstr.est.*;
import cstr.est.cpp.*;

public class ScrollWindow extends Frame
			  implements ActionListener, WindowListener
{
  ScrollPane scroller;
  Canvas canvas;
  
  private void init(String title, Component contents, int width, int height)
    {
      setTitle(title);
      setSize(width, height);

      scroller = new ScrollPane(ScrollPane.SCROLLBARS_ALWAYS);
      scroller.add(contents);
      scroller.doLayout();

      MenuBar mb = new MenuBar();
      setMenuBar(mb);

      Menu cMenu = new Menu("Control", true);
      mb.add(cMenu);

      MenuItem mItem = new MenuItem("Quit");
      mItem.addActionListener(this);
      cMenu.add(mItem);

      addWindowListener(this);

      setLayout(new BorderLayout());
      add("Center", scroller);
      pack();
    }

  public ScrollWindow(String name, Component contents)
    {
      super();
      init(name, contents, 500, 500);
    }

  public ScrollWindow(String name, Component contents, int width, int height)
    {
      super();
      init(name, contents, width, height);
    }

  public void quit()
    {
      dispose();
    }

  public void quit(String s)
    {
      dispose();
    }

  public void actionPerformed(ActionEvent event)
    {
      quit("action");
    }

  public void windowClosing(WindowEvent event)
    {
      quit("close");
    }

  public void windowOpened(WindowEvent event)
    {
    }

  public void windowClosed(WindowEvent event)
    {
    }

  public void windowIconified(WindowEvent event)
    {
    }

  public void windowDeiconified(WindowEvent event)
    {
    }

  public void windowActivated(WindowEvent event)
    {
    }

  public void windowDeactivated(WindowEvent event)
    {
    }

}
