
#include <stdio.h>
#include "jni_Track.h"
#include "EST_Track.h"
#include "EST_track_aux.h"
#include "EST_play_audio.h"

static jobject track_class;
static jfieldID handle_field;

static inline short abs(short s) { return s>0?s:-s; }

JNIEXPORT jboolean JNICALL
Java_cstr_est_cpp_Track_initialise_1cpp (JNIEnv *env, jclass myclass)
{
  track_class = env->NewGlobalRef(myclass);
  handle_field = env->GetFieldID(myclass, "cpp_handle", "J");

  if (!handle_field)
    {
    printf("can't find cpp_handle!\n");
    return 0;
    }

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Track_finalise_1cpp (JNIEnv *env, jclass myclass)
{
  (void)env;
  (void)myclass;
  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Track_create_1cpp_1track(JNIEnv *env, jobject self)
{
  EST_Track *track = new EST_Track;

  // printf("create track %x\n", track);

  env->SetLongField(self, handle_field, (jlong)track);

  return 1;
}

JNIEXPORT jboolean JNICALL 
Java_cstr_est_cpp_Track_destroy_1cpp_1track (JNIEnv *env, jobject self)
{
  EST_Track *track = (EST_Track *) env->GetLongField(self, handle_field);

  // printf("destroy track  %x\n", track);

  delete track;
  return 1;
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Track_cpp_1name (JNIEnv *env, jobject self)
{
  EST_Track *track = (EST_Track *) env->GetLongField(self, handle_field);

  return  env->NewStringUTF(track->name());
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Track_cpp_1load (JNIEnv *env, jobject self, jstring jfilename)
{
  EST_Track *track = (EST_Track *) env->GetLongField(self, handle_field);

  const char *filename = env->GetStringUTFChars(jfilename, 0);
  const char *res = "";

  EST_read_status stat = track->load(filename);

  env->ReleaseStringUTFChars(jfilename, filename);

  if (stat == read_format_error)
    res = "track format error";
  else if (stat == read_error) 
    res = "track load error";
  
  return  env->NewStringUTF(res);
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Track_cpp_1save (JNIEnv *env, jobject self, jstring jfilename, jstring jformat)
{
  EST_Track *track = (EST_Track *) env->GetLongField(self, handle_field);

  const char *filename = env->GetStringUTFChars(jfilename, 0);
  const char *format = env->GetStringUTFChars(jformat, 0);
  const char *res = "";

  EST_write_status stat = track->save(filename, format);

  env->ReleaseStringUTFChars(jfilename, filename);
  env->ReleaseStringUTFChars(jformat, format);

  if (stat == write_error) 
    res = "track save error";
  
  return  env->NewStringUTF(res);
}

JNIEXPORT jint JNICALL 
Java_cstr_est_cpp_Track_cpp_1num_1frames(JNIEnv *env, jobject self)
{
  EST_Track *track = (EST_Track *) env->GetLongField(self, handle_field);

  return track->num_frames();
}

JNIEXPORT jint JNICALL 
Java_cstr_est_cpp_Track_cpp_1num_1channels(JNIEnv *env, jobject self)
{
  EST_Track *track = (EST_Track *) env->GetLongField(self, handle_field);

  return track->num_channels();
}

JNIEXPORT jfloat JNICALL 
Java_cstr_est_cpp_Track_cpp_1getEndTime(JNIEnv *env, jobject self)
{
  EST_Track *track = (EST_Track *) env->GetLongField(self, handle_field);
  int f = track->num_frames()-1;

  return f>=0?track->t(f):0.0;
}

JNIEXPORT jstring JNICALL 
Java_cstr_est_cpp_Track_cpp_1channelName(JNIEnv *env, jobject self,
					 jint i)
{
  EST_Track *track = (EST_Track *) env->GetLongField(self, handle_field);
  EST_String cname(i>=0 && i < track->num_channels()
		   ?track->channel_name(i)
		   :EST_String::Empty);

  return  env->NewStringUTF(cname);
}


JNIEXPORT jint JNICALL 
Java_cstr_est_cpp_Track_cpp_1channelPosition(JNIEnv *env, jobject self,
					     jstring jname)
{
  EST_Track *track = (EST_Track *) env->GetLongField(self, handle_field);
  const char *name = env->GetStringUTFChars(jname, 0);

  int p = track->channel_position(name);
  
  env->ReleaseStringUTFChars(jname, name);

  return  p;
}


JNIEXPORT jfloat JNICALL 
Java_cstr_est_cpp_Track_cpp_1a(JNIEnv *env, jobject self,
			       jint f, jint c)
{
  EST_Track *track = (EST_Track *) env->GetLongField(self, handle_field);

  return track->a((int)f,(int)c);
}

JNIEXPORT jfloat JNICALL 
Java_cstr_est_cpp_Track_cpp_1t(JNIEnv *env, jobject self,
			       jint f)
{
  EST_Track *track = (EST_Track *) env->GetLongField(self, handle_field);

  return track->t((int)f);
}


