/*
 * menu.c : Menu creation and manipulation routines
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/StringDefs.h>
#include <X11/bitmaps/xlogo11>
extern Widget toplevel;

/*
 * Functions defined here:
 */
void initMenuCreator();
Widget createMenu();
void clearAllItemMarks();
void setIthItemMark();

/*
 * Data defined here:
 */
static Pixmap checkmarkBitmap;

/*	-	-	-	-	-	-	-	-	*/

void
initMenuCreator()
{
    checkmarkBitmap = XCreateBitmapFromData(XtDisplay(toplevel),
				XDefaultRootWindow(XtDisplay(toplevel)),
				xlogo11_bits,
				xlogo11_width,xlogo11_height);
}

/*
 * createMenu : Creates menu named "name" with "numItems", each of which
 *	calls back to "callback". If "items" is non-NULL, then saves the
 *	items in it.
 */
Widget
createMenu(name,item_basename,numItems,items,callback)
char *name,*item_basename;
int numItems;
SmeBSBObject *items;
XtCallbackProc callback;
{
    Widget menu;
    SmeBSBObject item;
    char itemName[64];
    int i;

    menu = XtCreatePopupShell(name,simpleMenuWidgetClass,toplevel,NULL,0);
    for (i=0; i < numItems; i++) {
	sprintf(itemName,"%s%d",item_basename,i);
	item = (SmeBSBObject)XtCreateManagedWidget(itemName,smeBSBObjectClass,
						   menu,NULL,0);
	if (items != NULL)
	    *(items+i) = item;
	XtAddCallback((Widget)item,XtNcallback,callback,(XtPointer)i);
    }
    return(menu);
}

/*	-	-	-	-	-	-	-	-	*/

void
clearAllItemMarks(items,numItems)
SmeBSBObject *items;
int numItems;
{
    Arg args[1];
    int i;

    for (i=0; i < numItems; i++) {
	XtSetArg(args[0],XtNleftBitmap,None);
	XtSetValues((Widget)(*(items+i)),args,1);
    }
}

void
setIthItemMark(items,i,numItems)
SmeBSBObject *items;
int i,numItems;
{
    Arg args[1];

    clearAllItemMarks(items,numItems);
    XtSetArg(args[0],XtNleftBitmap,checkmarkBitmap);
    XtSetValues((Widget)(*(items+i)),args,1);
}
