/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import org.aspectj.ajdt.internal.compiler.ast.AjMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AtAspectJAnnotationFactory;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDesignator;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.core.builder.EclipseSourceContext;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.patterns.Pointcut;

public class PointcutDeclaration
extends AjMethodDeclaration {
    public static final char[] mangledPrefix = "ajc$pointcut$".toCharArray();
    public PointcutDesignator pointcutDesignator;
    private int declaredModifiers;
    private String declaredName;
    private boolean generateSyntheticPointcutMethod = false;
    private ResolvedPointcutDefinition resolvedPointcutDeclaration = null;

    public PointcutDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
        this.returnType = TypeReference.baseTypeReference(6, 0);
    }

    private Pointcut getPointcut() {
        if (this.pointcutDesignator == null) {
            return Pointcut.makeMatchesNothing(Pointcut.RESOLVED);
        }
        return this.pointcutDesignator.getPointcut();
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
    }

    public void postParse(TypeDeclaration typeDec) {
        if (this.arguments == null) {
            this.arguments = new Argument[0];
        }
        this.declaredModifiers = this.modifiers;
        this.declaredName = new String(this.selector);
        this.selector = CharOperation.concat(mangledPrefix, '$', this.selector, '$', Integer.toHexString(this.sourceStart).toCharArray());
        if (Modifier.isAbstract(this.declaredModifiers)) {
            if (!(typeDec instanceof AspectDeclaration)) {
                typeDec.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "The abstract pointcut " + new String(this.declaredName) + " can only be defined in an aspect");
                this.ignoreFurtherInvestigation = true;
                return;
            }
            if (!Modifier.isAbstract(typeDec.modifiers)) {
                typeDec.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "The abstract pointcut " + new String(this.declaredName) + " can only be defined in an abstract aspect");
                this.ignoreFurtherInvestigation = true;
                return;
            }
        }
        if (this.pointcutDesignator != null) {
            this.pointcutDesignator.postParse(typeDec, this);
        }
    }

    public void addAtAspectJAnnotations() {
        Annotation pcutAnnotation = AtAspectJAnnotationFactory.createPointcutAnnotation(this.getPointcut().toString(), this.declarationSourceStart);
        if (this.annotations == null) {
            this.annotations = new Annotation[]{pcutAnnotation};
        } else {
            Annotation[] old = this.annotations;
            this.annotations = new Annotation[old.length + 1];
            System.arraycopy(old, 0, this.annotations, 0, old.length);
            this.annotations[old.length] = pcutAnnotation;
        }
        this.generateSyntheticPointcutMethod = true;
    }

    public void setGenerateSyntheticPointcutMethod() {
        this.generateSyntheticPointcutMethod = true;
    }

    public void resolve(ClassScope upperScope) {
        if (this.binding != null) {
            this.binding.tagBits -= 0x200000000L;
            ASTNode.resolveAnnotations(this.scope, this.annotations, this.binding);
        }
    }

    public void resolvePointcut(ClassScope upperScope) {
        super.resolve(upperScope);
    }

    public void resolveStatements() {
        if (this.isAbstract()) {
            this.modifiers |= 0x1000000;
        }
        if (this.binding == null || this.ignoreFurtherInvestigation) {
            return;
        }
        if (Modifier.isAbstract(this.declaredModifiers) && this.pointcutDesignator != null) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "abstract pointcut can't have body");
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.pointcutDesignator != null) {
            this.pointcutDesignator.finishResolveTypes(this, this.binding, this.arguments.length, this.scope.enclosingSourceType());
        }
        this.makeResolvedPointcutDefinition();
        this.resolvedPointcutDeclaration.setPointcut(this.getPointcut());
        super.resolveStatements();
    }

    public ResolvedPointcutDefinition makeResolvedPointcutDefinition() {
        if (this.resolvedPointcutDeclaration != null) {
            return this.resolvedPointcutDeclaration;
        }
        this.resolvedPointcutDeclaration = new ResolvedPointcutDefinition(EclipseFactory.fromBinding(this.binding.declaringClass), this.declaredModifiers, this.declaredName, EclipseFactory.fromBindings(this.binding.parameters), this.getPointcut());
        this.resolvedPointcutDeclaration.setPosition(this.sourceStart, this.sourceEnd);
        this.resolvedPointcutDeclaration.setSourceContext(new EclipseSourceContext(this.compilationResult));
        return this.resolvedPointcutDeclaration;
    }

    public AjAttribute makeAttribute() {
        return new AjAttribute.PointcutDeclarationAttribute(this.makeResolvedPointcutDefinition());
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        classFile.extraAttributes.add(new EclipseAttributeAdapter(this.makeAttribute()));
        if (this.generateSyntheticPointcutMethod) {
            super.generateCode(classScope, classFile);
        }
    }

    protected int generateInfoAttributes(ClassFile classFile) {
        return super.generateInfoAttributes(classFile, true);
    }

    public StringBuffer printReturnType(int indent, StringBuffer output) {
        return output.append("pointcut");
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        output.append(": ");
        output.append(this.getPointcut());
        output.append(";");
        return output;
    }
}

