/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.FieldArray;
import org.eclipse.core.internal.indexing.Insertable;

class Pointer {
    protected Buffer buffer;
    protected int offset;

    protected Pointer() {
    }

    public Pointer(Buffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
    }

    public void clear(int length) {
        this.buffer.clear(this.offset, length);
    }

    public Pointer dec(int n) {
        this.offset -= n;
        return this;
    }

    public byte[] get(int length) {
        return this.buffer.get(this.offset, length);
    }

    public FieldArray getArray(int length, int stride, int count) {
        return new FieldArray(this.buffer, this.offset, length, stride, count);
    }

    public Field getField(int length) {
        return new Field(this.buffer, this.offset, length);
    }

    public Field getField(int offset, int length) {
        return new Field(this.buffer, this.offset + offset, length);
    }

    public int getInt(int length) {
        return this.buffer.getInt(this.offset, length);
    }

    public int getUInt(int length) {
        return this.buffer.getUInt(this.offset, length);
    }

    public Pointer inc(int n) {
        this.offset += n;
        return this;
    }

    public int offset() {
        return this.offset;
    }

    public Pointer put(byte[] bytes) {
        this.buffer.put(this.offset, bytes);
        return this;
    }

    public Pointer put(int length, int n) {
        this.buffer.put(this.offset, length, n);
        return this;
    }

    public Pointer put(int length, long n) {
        this.buffer.put(this.offset, length, n);
        return this;
    }

    public Pointer put(Insertable anObject) {
        return this.put(anObject.toByteArray());
    }
}

