/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl;

import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPActionArgument;
import com.aelitis.net.upnp.UPnPActionInvocation;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPFactory;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPLogListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.UPnPStateVariable;
import com.aelitis.net.upnp.impl.SSDP;
import com.aelitis.net.upnp.impl.SSDPFactory;
import com.aelitis.net.upnp.impl.SSDPListener;
import com.aelitis.net.upnp.impl.device.UPnPRootDeviceImpl;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import com.aelitis.net.upnp.services.UPnPWANIPConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;

public class UPnPImpl
extends ResourceDownloaderAdapter
implements UPnP,
SSDPListener {
    public static final boolean USE_HTTP_CONNECTION = true;
    public static final String NL = "\r\n";
    protected static UPnPImpl singleton;
    protected static AEMonitor class_mon;
    protected PluginInterface plugin_interface;
    protected LoggerChannel log;
    protected SSDP ssdp;
    protected Map root_locations = new HashMap();
    protected List log_listeners = new ArrayList();
    protected List log_history = new ArrayList();
    protected List rd_listeners = new ArrayList();
    protected AEMonitor rd_listeners_mon = new AEMonitor("UPnP:L");
    protected int trace_index = 0;
    protected AEMonitor this_mon = new AEMonitor("UPnP");

    static {
        class_mon = new AEMonitor("UPnP:class");
    }

    public static UPnP getSingleton(PluginInterface plugin_interface) throws UPnPException {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new UPnPImpl(plugin_interface);
            }
            UPnPImpl uPnPImpl = singleton;
            class_mon.exit();
            return uPnPImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected UPnPImpl(PluginInterface _plugin_interface) throws UPnPException {
        this.plugin_interface = _plugin_interface;
        this.log = this.plugin_interface.getLogger().getChannel("UPnP Core");
        this.ssdp = SSDPFactory.create(this);
        this.ssdp.addListener(this);
        this.ssdp.start();
    }

    public void rootDiscovered(InetAddress local_address, URL location) {
        UPnPRootDeviceImpl root_device = (UPnPRootDeviceImpl)this.root_locations.get(location.getHost());
        if (root_device != null) {
            if (root_device.getLocation().equals(location) && root_device.getLocalAddress().equals(local_address)) {
                return;
            }
            this.root_locations.remove(location.getHost());
            root_device.destroy(true);
        }
        this.log("UPnP: root discovered = " + location + ", local = " + local_address.toString());
        try {
            ArrayList listeners;
            root_device = new UPnPRootDeviceImpl(this, local_address, location);
            try {
                this.rd_listeners_mon.enter();
                this.root_locations.put(location.getHost(), root_device);
                listeners = new ArrayList(this.rd_listeners);
            }
            finally {
                this.rd_listeners_mon.exit();
            }
            int i = 0;
            while (i < listeners.size()) {
                ((UPnPListener)listeners.get(i)).rootDeviceFound(root_device);
                ++i;
            }
        }
        catch (UPnPException e) {
            this.log(e.toString());
        }
    }

    public void rootAlive(URL location) {
        UPnPRootDeviceImpl root_device = (UPnPRootDeviceImpl)this.root_locations.get(location.getHost());
        if (root_device == null) {
            this.ssdp.searchNow();
        }
    }

    public void rootLost(InetAddress local_address, URL location) {
        UPnPRootDeviceImpl root_device;
        try {
            this.rd_listeners_mon.enter();
            root_device = (UPnPRootDeviceImpl)this.root_locations.remove(location.getHost());
        }
        finally {
            this.rd_listeners_mon.exit();
        }
        if (root_device == null) {
            return;
        }
        this.log("UPnP: root lost = " + location + ", local = " + local_address.toString());
        root_device.destroy(false);
    }

    public void reset() {
        ArrayList roots;
        this.log("UPnP: reset");
        try {
            this.rd_listeners_mon.enter();
            roots = new ArrayList(this.root_locations.values());
            this.root_locations.clear();
        }
        finally {
            this.rd_listeners_mon.exit();
        }
        int i = 0;
        while (i < roots.size()) {
            ((UPnPRootDeviceImpl)roots.get(i)).destroy(true);
            ++i;
        }
        this.ssdp.searchNow();
    }

    public SimpleXMLParserDocument parseXML(InputStream _is) throws SimpleXMLParserDocumentException, IOException {
        ByteArrayOutputStream baos = null;
        try {
            int len;
            baos = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[8192];
            while ((len = _is.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
        }
        finally {
            baos.close();
        }
        byte[] bytes_in = baos.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes_in);
        try {
            String line;
            StringBuffer data = new StringBuffer(1024);
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)is, "UTF-8"));
            while ((line = lnr.readLine()) != null) {
                data.append(String.valueOf(line.trim()) + "\n");
            }
            String data_str = data.toString();
            this.log.log("UPnP:Response:" + data_str);
            return this.plugin_interface.getUtilities().getSimpleXMLParserDocumentFactory().create(data_str);
        }
        catch (Throwable e) {
            try {
                FileOutputStream trace = new FileOutputStream(this.getTraceFile());
                trace.write(bytes_in);
                trace.close();
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            if (e instanceof SimpleXMLParserDocumentException) {
                throw (SimpleXMLParserDocumentException)e;
            }
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    public SimpleXMLParserDocument downloadXML(URL url) throws UPnPException {
        ResourceDownloaderFactory rdf = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
        ResourceDownloader rd = rdf.getRetryDownloader(rdf.create(url), 3);
        rd.addListener(this);
        try {
            InputStream data = rd.download();
            return this.parseXML(data);
        }
        catch (Throwable e) {
            this.log(e);
            if (e instanceof UPnPException) {
                throw (UPnPException)e;
            }
            throw new UPnPException("Root device location '" + url + "' - data read failed", e);
        }
    }

    public SimpleXMLParserDocument performSOAPRequest(UPnPService service, String soap_action, String request2) throws SimpleXMLParserDocumentException, UPnPException, IOException {
        this.log.log("UPnP:Request:" + request2);
        URL control = service.getControlURL();
        HttpURLConnection con = (HttpURLConnection)control.openConnection();
        con.setRequestProperty("SOAPAction", "\"" + soap_action + "\"");
        con.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
        con.setRequestProperty("User-Agent", "Azureus (UPnP/1.0)");
        con.setRequestMethod("POST");
        con.setDoInput(true);
        con.setDoOutput(true);
        OutputStream os = con.getOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
        pw.println(request2);
        pw.flush();
        con.connect();
        if (con.getResponseCode() == 405) {
            con = (HttpURLConnection)control.openConnection();
            con.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
            con.setRequestMethod("M-POST");
            con.setRequestProperty("MAN", "\"http://schemas.xmlsoap.org/soap/envelope/\"; ns=01");
            con.setRequestProperty("01-SOAPACTION", "\"" + soap_action + "\"");
            con.setDoInput(true);
            con.setDoOutput(true);
            os = con.getOutputStream();
            pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
            pw.println(request2);
            pw.flush();
            con.connect();
            return this.parseXML(con.getInputStream());
        }
        return this.parseXML(con.getInputStream());
    }

    protected File getTraceFile() {
        try {
            this.this_mon.enter();
            ++this.trace_index;
            if (this.trace_index == 6) {
                this.trace_index = 1;
            }
            File file = new File(this.plugin_interface.getUtilities().getAzureusUserDir(), "upnp_trace" + this.trace_index + ".log");
            this.this_mon.exit();
            return file;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    public void reportActivity(ResourceDownloader downloader, String activity) {
        this.log(activity);
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.log(e);
    }

    public void log(Throwable e) {
        this.log(e.toString());
    }

    public void log(String str) {
        ArrayList old_listeners;
        try {
            this.this_mon.enter();
            old_listeners = new ArrayList(this.log_listeners);
            this.log_history.add(str);
            if (this.log_history.size() > 32) {
                this.log_history.remove(0);
            }
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < old_listeners.size()) {
            ((UPnPLogListener)old_listeners.get(i)).log(str);
            ++i;
        }
    }

    public void addLogListener(UPnPLogListener l) {
        ArrayList old_logs;
        try {
            this.this_mon.enter();
            old_logs = new ArrayList(this.log_history);
            this.log_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < old_logs.size()) {
            l.log((String)old_logs.get(i));
            ++i;
        }
    }

    public void removeLogListener(UPnPLogListener l) {
        this.log_listeners.remove(l);
    }

    public void addRootDeviceListener(UPnPListener l) {
        ArrayList old_locations;
        try {
            this.this_mon.enter();
            old_locations = new ArrayList(this.root_locations.values());
            this.rd_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < old_locations.size()) {
            l.rootDeviceFound((UPnPRootDevice)old_locations.get(i));
            ++i;
        }
    }

    public void removeRootDeviceListener(UPnPListener l) {
        this.rd_listeners.remove(l);
    }

    public static void main(String[] args) {
        try {
            UPnP upnp = UPnPFactory.getSingleton(null);
            upnp.addRootDeviceListener(new UPnPListener(){

                public void rootDeviceFound(UPnPRootDevice device) {
                    try {
                        UPnPImpl.processDevice(device.getDevice());
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            });
            upnp.addLogListener(new UPnPLogListener(){

                public void log(String str) {
                    System.out.println(str);
                }
            });
            Thread.sleep(20000L);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected static void processDevice(UPnPDevice device) throws UPnPException {
        if (device.getDeviceType().equalsIgnoreCase("urn:schemas-upnp-org:device:WANConnectionDevice:1")) {
            System.out.println("got device");
            UPnPService[] services = device.getServices();
            int i = 0;
            while (i < services.length) {
                UPnPService s = services[i];
                if (s.getServiceType().equalsIgnoreCase("urn:schemas-upnp-org:service:WANIPConnection:1")) {
                    System.out.println("got service");
                    UPnPAction[] actions = s.getActions();
                    int j = 0;
                    while (j < actions.length) {
                        System.out.println(actions[j].getName());
                        ++j;
                    }
                    UPnPStateVariable[] vars = s.getStateVariables();
                    int j2 = 0;
                    while (j2 < vars.length) {
                        System.out.println(vars[j2].getName());
                        ++j2;
                    }
                    UPnPStateVariable noe = s.getStateVariable("PortMappingNumberOfEntries");
                    System.out.println("noe = " + noe.getValue());
                    UPnPWANIPConnection wan_ip = (UPnPWANIPConnection)s.getSpecificService();
                    UPnPWANConnectionPortMapping[] ports = wan_ip.getPortMappings();
                    wan_ip.addPortMapping(true, 7007, "Moo!");
                    UPnPAction act = s.getAction("GetGenericPortMappingEntry");
                    UPnPActionInvocation inv = act.getInvocation();
                    inv.addArgument("NewPortMappingIndex", "0");
                    UPnPActionArgument[] outs = inv.invoke();
                    int j3 = 0;
                    while (j3 < outs.length) {
                        System.out.println(String.valueOf(outs[j3].getName()) + " = " + outs[j3].getValue());
                        ++j3;
                    }
                }
                ++i;
            }
        } else {
            UPnPDevice[] kids = device.getSubDevices();
            int i = 0;
            while (i < kids.length) {
                UPnPImpl.processDevice(kids[i]);
                ++i;
            }
        }
    }
}

