/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk;

import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.torrent.TOTorrent;

public class DiskManagerFactory {
    public static DiskManager create(TOTorrent torrent, DownloadManager manager) {
        DiskManagerImpl dm = new DiskManagerImpl(torrent, manager);
        if (dm.getState() != 10) {
            dm.start();
        }
        return dm;
    }

    public static DiskManager createNoStart(TOTorrent torrent, DownloadManager manager) {
        return new DiskManagerImpl(torrent, manager);
    }

    public static void setResumeDataCompletelyValid(DownloadManagerState download_manager_state, String data_location) {
        RDResumeHandler.setTorrentResumeDataComplete(download_manager_state, data_location);
    }

    public static void setTorrentResumeDataNearlyComplete(DownloadManagerState dms, String torrent_save_dir, String torrent_save_file) {
        RDResumeHandler.setTorrentResumeDataNearlyComplete(dms, torrent_save_dir, torrent_save_file);
    }

    public static boolean isTorrentResumeDataComplete(DownloadManagerState download_manager_state, String torrent_save_dir, String torrent_save_file) {
        return RDResumeHandler.isTorrentResumeDataComplete(download_manager_state, torrent_save_dir, torrent_save_file);
    }

    public static void deleteDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) {
        DiskManagerImpl.deleteDataFiles(torrent, torrent_save_dir, torrent_save_file);
    }
}

