/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrentdownloader.impl;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TorrentDownloaderImpl
extends AEThread
implements TorrentDownloader {
    private String url_str;
    private String referrer;
    private String file_str;
    private URL url;
    private HttpURLConnection con;
    private String error = "Ok";
    private TorrentDownloaderCallBackInterface iface;
    private int state = -1;
    private int percentDone = 0;
    private int readTotal = 0;
    private boolean cancel = false;
    private String filename;
    private String directoryname;
    private File file = null;
    private AEMonitor this_mon = new AEMonitor("TorrentDownloader");

    public TorrentDownloaderImpl() {
        super("Torrent Downloader");
        this.setDaemon(true);
    }

    public void init(TorrentDownloaderCallBackInterface _iface, String _url, String _referrer, String _file) {
        this.iface = _iface;
        _url = _url.replace('\\', '/');
        _url = _url.replaceAll(" ", "%20");
        this.setName("TorrentDownloader: " + _url);
        this.url_str = _url;
        this.referrer = _referrer;
        this.file_str = _file;
    }

    public void notifyListener() {
        if (this.iface != null) {
            this.iface.TorrentDownloaderEvent(this.state, this);
        } else if (this.state == 4) {
            System.err.println(this.error);
        }
    }

    private void cleanUpFile() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    private void error(String err) {
        try {
            this.this_mon.enter();
            this.state = 4;
            this.setError(err);
            this.cleanUpFile();
            this.notifyListener();
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void runSupport() {
        try {
            this.url = AEProxyFactory.getAddressMapper().internalise(new URL(this.url_str));
            if (this.url.getProtocol().equalsIgnoreCase("https")) {
                HttpsURLConnection ssl_con = (HttpsURLConnection)this.url.openConnection();
                ssl_con.setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String host, SSLSession session) {
                        return true;
                    }
                });
                this.con = ssl_con;
            } else {
                this.con = (HttpURLConnection)this.url.openConnection();
            }
            this.con.setRequestProperty("User-Agent", "Azureus 2.2.0.2");
            if (this.referrer != null && this.referrer.length() > 0) {
                this.con.setRequestProperty("Referer", this.referrer);
            }
            this.con.connect();
            int response = this.con.getResponseCode();
            if (response != 202 && response != 200) {
                this.error("Error on connect for '" + this.url.toString() + "': " + Integer.toString(response) + " " + this.con.getResponseMessage());
                return;
            }
            this.filename = this.con.getHeaderField("Content-Disposition");
            if (this.filename != null && this.filename.toLowerCase().matches(".*attachment.*")) {
                while (this.filename.toLowerCase().charAt(0) != 'a') {
                    this.filename = this.filename.substring(1);
                }
            }
            if (this.filename == null || !this.filename.toLowerCase().startsWith("attachment") || this.filename.indexOf(61) == -1) {
                int param_pos;
                String tmp = this.url.getFile();
                if (tmp.lastIndexOf(47) != -1) {
                    tmp = tmp.substring(tmp.lastIndexOf(47) + 1);
                }
                if ((param_pos = tmp.indexOf(63)) != -1) {
                    tmp = tmp.substring(0, param_pos);
                }
                this.filename = URLDecoder.decode(tmp, "UTF8");
            } else {
                this.filename = this.filename.substring(this.filename.indexOf(61) + 1);
                if (this.filename.startsWith("\"") && this.filename.endsWith("\"")) {
                    this.filename = this.filename.substring(1, this.filename.lastIndexOf(34));
                }
                File temp = new File(this.filename);
                this.filename = temp.getName();
            }
            this.directoryname = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
            boolean useTorrentSave = COConfigurationManager.getBooleanParameter("Save Torrent Files", true);
            if (this.file_str != null) {
                File temp = new File(this.file_str);
                if (!useTorrentSave || this.directoryname.length() == 0) {
                    this.directoryname = temp.isDirectory() ? temp.getCanonicalPath() : temp.getCanonicalFile().getParent();
                }
                if (!temp.isDirectory()) {
                    this.filename = temp.getName();
                }
            }
            this.state = 0;
            this.notifyListener();
        }
        catch (MalformedURLException e) {
            this.error("Exception while parsing URL '" + this.url + "':" + e.getMessage());
        }
        catch (UnknownHostException e) {
            this.error("Exception while initializing download of '" + this.url + "': Unknown Host '" + e.getMessage() + "'");
        }
        catch (IOException ioe) {
            this.error("I/O Exception while initializing download of '" + this.url + "':" + ioe.toString());
        }
        catch (Throwable e) {
            this.error("Exception while initializing download of '" + this.url + "':" + e.toString());
        }
        if (this.state != 4) {
            this.state = 1;
            this.notifyListener();
            this.state = 2;
            try {
                this.file = new File(this.directoryname, this.filename);
                this.file.createNewFile();
                FileOutputStream fileout = new FileOutputStream(this.file, false);
                InputStream in = this.con.getInputStream();
                byte[] buf = new byte[1020];
                int read = 0;
                int size = this.con.getContentLength();
                this.percentDone = -1;
                while (!this.cancel) {
                    try {
                        read = in.read(buf);
                        this.readTotal += read;
                        if (size != 0) {
                            this.percentDone = 100 * this.readTotal / size;
                        }
                        this.notifyListener();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (read > 0) {
                        fileout.write(buf, 0, read);
                    }
                    if (read > 0) continue;
                }
                in.close();
                fileout.flush();
                fileout.close();
                if (this.cancel) {
                    this.state = 6;
                    this.cleanUpFile();
                } else {
                    if (this.readTotal == 0) {
                        this.error("No data contained in '" + this.url.toString() + "'");
                        return;
                    }
                    try {
                        TOTorrent torrent;
                        String name;
                        File new_file;
                        if (!this.filename.toLowerCase().endsWith(".torrent") && this.file.renameTo(new_file = new File(this.directoryname, name = String.valueOf(TorrentUtils.getLocalisedName(torrent = TorrentUtils.readFromFile(this.file, false))) + ".torrent"))) {
                            this.filename = name;
                            this.file = new_file;
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    this.state = 3;
                }
                this.notifyListener();
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                this.error("Exception while downloading '" + this.url.toString() + "':" + e.getMessage());
            }
        }
    }

    public boolean equals(Object obj) {
        TorrentDownloaderImpl other;
        if (this == obj) {
            return true;
        }
        return obj != null && obj instanceof TorrentDownloaderImpl && (other = (TorrentDownloaderImpl)obj).getURL().equals(this.url.toString()) && other.getFile().getAbsolutePath().equals(this.file.getAbsolutePath());
    }

    public String getError() {
        return this.error;
    }

    public void setError(String err) {
        this.error = err;
    }

    public File getFile() {
        if (!this.isAlive() || this.file == null) {
            this.file = new File(this.directoryname, this.filename);
        }
        return this.file;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public int getDownloadState() {
        return this.state;
    }

    public void setDownloadState(int state) {
        this.state = state;
    }

    public String getURL() {
        return this.url.toString();
    }

    public void cancel() {
        this.cancel = true;
    }

    public void setDownloadPath(String path, String file) {
        if (!this.isAlive()) {
            if (path != null) {
                this.directoryname = path;
            }
            if (file != null) {
                this.filename = file;
            }
        }
    }

    public int getTotalRead() {
        return this.readTotal;
    }
}

