/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class AEJarSigner2 {
    protected static Class JarSigner_class;
    protected String keystore_name;
    protected String keystore_password;
    protected String alias;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AEJarSigner2(String _alias, String _keystore_name, String _keystore_password) {
        this.alias = _alias;
        this.keystore_name = _keystore_name;
        this.keystore_password = _keystore_password;
    }

    protected void loadJarSigner() throws IOException {
        File tools_dir;
        String manual_tools_dir = COConfigurationManager.getStringParameter("Security.JAR.tools.dir");
        if (manual_tools_dir.length() == 0) {
            String java_home = System.getProperty("java.home");
            File jh = new File(java_home);
            if (jh.getName().equalsIgnoreCase("jre")) {
                jh = jh.getParentFile();
            } else {
                String dir_name = jh.getName();
                if (dir_name.startsWith("jre")) {
                    dir_name = "jdk" + dir_name.substring(3);
                    jh = new File(jh.getParentFile(), dir_name);
                }
            }
            tools_dir = new File(jh, "lib");
        } else {
            tools_dir = new File(manual_tools_dir);
        }
        File tools_jar = new File(tools_dir, "tools.jar");
        if (tools_jar.exists()) {
            try {
                URL[] uRLArray = new URL[]{tools_jar.toURL()};
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.gudy.azureus2.core3.util.jar.AEJarSigner2");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                URLClassLoader cl = new URLClassLoader(uRLArray, clazz.getClassLoader());
                JarSigner_class = cl.loadClass("sun.security.tools.JarSigner");
            }
            catch (Throwable e) {
                LGLogger.logUnrepeatableAlertUsingResource(3, "Security.jar.signfail", new String[]{e.getMessage()});
                Debug.printStackTrace(e);
                throw new IOException("JAR signing fails: " + e.getMessage());
            }
        }
        LGLogger.logUnrepeatableAlertUsingResource(3, "Security.jar.tools_not_found", new String[]{tools_dir.toString()});
        throw new IOException("JAR signing fails: tools.jar not found");
    }

    protected void signJarFile(File input_file) throws IOException {
        String failure_msg;
        block15: {
            if (JarSigner_class == null) {
                this.loadJarSigner();
            }
            PrintStream old_err = null;
            PrintStream old_out = null;
            failure_msg = null;
            try {
                try {
                    Object jar_signer = JarSigner_class.newInstance();
                    String[] args = new String[]{"-keystore", this.keystore_name, "-storepass", this.keystore_password, input_file.toString(), this.alias};
                    old_err = System.err;
                    old_out = System.out;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(baos);
                    System.setErr(ps);
                    System.setOut(ps);
                    try {
                        Class[] classArray = new Class[1];
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("[Ljava.lang.String;");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz;
                        JarSigner_class.getMethod("run", classArray).invoke(jar_signer, new Object[]{args});
                    }
                    catch (Throwable e) {
                        ps.close();
                        String err_msg = baos.toString();
                        if (err_msg.length() > 0) {
                            failure_msg = err_msg;
                            break block15;
                        }
                        Debug.printStackTrace(e);
                        failure_msg = e.getMessage();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    failure_msg = e.getMessage();
                }
            }
            finally {
                if (old_err != null) {
                    System.setErr(old_err);
                    System.setOut(old_out);
                }
            }
        }
        if (failure_msg != null) {
            Debug.out("JAR signing fails '" + failure_msg + "'");
            LGLogger.logUnrepeatableAlertUsingResource(3, "Security.jar.signfail", new String[]{failure_msg});
            throw new IOException("JAR signing fails: " + failure_msg);
        }
    }

    public void signJarFile(File file, OutputStream os) throws IOException {
        this.signJarFile(file);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            FileUtil.copyFile(file, os, false);
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void signJarStream(InputStream is, OutputStream os) throws IOException {
        File temp_file = AETemporaryFileHandler.createTempFile("AZU", null);
        FileOutputStream fos = null;
        try {
            int len;
            byte[] buffer = new byte[8192];
            fos = new FileOutputStream(temp_file);
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            fos = null;
            this.signJarFile(temp_file, os);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            temp_file.delete();
        }
    }
}

