/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.win32;

import java.io.File;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerException;
import org.gudy.azureus2.platform.win32.access.AEWin32Access;
import org.gudy.azureus2.platform.win32.access.AEWin32Manager;

public class PlatformManagerImpl
implements PlatformManager {
    public static final String DLL_NAME = "aereg";
    protected static boolean init_tried;
    protected static PlatformManagerImpl singleton;
    protected static AEMonitor class_mon;
    protected AEWin32Access access;
    protected File az_exe;
    protected boolean az_exe_checked;

    static {
        class_mon = new AEMonitor("PlatformManager");
    }

    public static PlatformManagerImpl getSingleton() throws PlatformManagerException {
        try {
            class_mon.enter();
            if (singleton == null && !init_tried) {
                init_tried = true;
                try {
                    singleton = new PlatformManagerImpl(AEWin32Manager.getAccessor());
                }
                catch (Throwable e) {
                    LGLogger.log("Win32Platform: failed to initialise", e);
                    if (e instanceof PlatformManagerException) {
                        throw (PlatformManagerException)e;
                    }
                    throw new PlatformManagerException("Win32Platform: failed to initialise", e);
                }
            }
            PlatformManagerImpl platformManagerImpl = singleton;
            class_mon.exit();
            return platformManagerImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected PlatformManagerImpl(AEWin32Access _access) throws PlatformManagerException {
        this.access = _access;
        this.applyPatches();
    }

    protected void applyPatches() {
        try {
            File exe_loc = this.getAureusEXELocation();
            String az_exe_string = exe_loc.toString();
            int icon_index = this.getIconIndex();
            String current = this.access.readStringValue(1, "BitTorrent\\DefaultIcon", "");
            String target = String.valueOf(az_exe_string) + "," + this.getIconIndex();
            if (current.indexOf("Azureus.exe") != -1 && !current.equals(target)) {
                this.access.writeStringValue(1, "BitTorrent\\DefaultIcon", "", target);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected int getIconIndex() throws PlatformManagerException {
        return 0;
    }

    protected String getVersion() {
        return this.access.getVersion();
    }

    protected File getAureusEXELocation() throws PlatformManagerException {
        if (this.az_exe == null) {
            try {
                String az_home;
                try {
                    az_home = this.access.getAzureusInstallDir();
                    this.az_exe = new File(String.valueOf(az_home) + File.separator + "Azureus.exe").getAbsoluteFile();
                    if (!this.az_exe.exists()) {
                        throw new PlatformManagerException("Azureus.exe not found in " + az_home + ", please re-install");
                    }
                }
                catch (Throwable e) {
                    az_home = SystemProperties.getApplicationPath();
                    this.az_exe = new File(String.valueOf(az_home) + File.separator + "Azureus.exe").getAbsoluteFile();
                }
                if (!this.az_exe.exists()) {
                    String msg = "Azureus.exe not found in " + az_home + " - can't check file associations. Please re-install Azureus";
                    this.az_exe = null;
                    if (!this.az_exe_checked) {
                        LGLogger.logUnrepeatableAlert(1, msg);
                    }
                    throw new PlatformManagerException(msg);
                }
            }
            finally {
                this.az_exe_checked = true;
            }
        }
        return this.az_exe;
    }

    public int getPlatformType() {
        return 1;
    }

    public String getUserDataDirectory() throws PlatformManagerException {
        try {
            return this.access.getUserAppData();
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to read registry details", e);
        }
    }

    public boolean isApplicationRegistered() throws PlatformManagerException {
        String az_exe_str = this.getAureusEXELocation().toString();
        try {
            String test1 = this.access.readStringValue(1, "BitTorrent\\shell\\open\\command", "");
            if (!test1.equals("\"" + az_exe_str + "\" \"%1\"")) {
                return false;
            }
            try {
                String always_open_with = this.access.readStringValue(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\.torrent", "Application");
                if (always_open_with.length() > 0) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        catch (Throwable e) {
            if (e.getMessage() == null || e.getMessage().indexOf("RegOpenKey failed") == -1) {
                Debug.printStackTrace(e);
            }
            return false;
        }
    }

    public void registerApplication() throws PlatformManagerException {
        try {
            String az_exe_string = this.getAureusEXELocation().toString();
            try {
                this.access.deleteValue(4, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\.torrent", "Application");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.access.deleteKey(1, ".torrent");
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            try {
                this.access.deleteKey(1, "BitTorrent", true);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            this.access.writeStringValue(1, ".torrent", "", "BitTorrent");
            this.access.writeStringValue(1, "BitTorrent", "", "Bittorrent File");
            this.access.writeStringValue(1, "BitTorrent\\shell", "", "open");
            this.access.writeStringValue(1, "BitTorrent\\DefaultIcon", "", String.valueOf(az_exe_string) + "," + this.getIconIndex());
            this.access.writeStringValue(1, "BitTorrent\\shell\\open\\command", "", "\"" + az_exe_string + "\" \"%1\"");
            this.access.writeStringValue(1, "BitTorrent\\Content Type", "", "application/x-bittorrent");
        }
        catch (PlatformManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to write registry details", e);
        }
    }

    public void createProcess(String command_line, boolean inherit_handles) throws PlatformManagerException {
        try {
            this.access.createProcess(command_line, inherit_handles);
        }
        catch (Throwable e) {
            throw new PlatformManagerException("Failed to create process", e);
        }
    }
}

