/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.tracker.host.TRHostAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerAuthenticationListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWebPageRequestImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWebPageResponseImpl;

public abstract class TrackerWCHelper
implements TrackerWebContext,
TRHostAuthenticationListener,
TRTrackerServerAuthenticationListener {
    protected Tracker tracker;
    protected List generators = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TrackerWCHelper");

    protected TrackerWCHelper() {
    }

    protected void setTracker(Tracker _tracker) {
        this.tracker = _tracker;
    }

    public boolean handleExternalRequest(String _client_address, String _url, String _header, InputStream _is, OutputStream _os) throws IOException {
        TrackerWebPageRequestImpl request2 = new TrackerWebPageRequestImpl(this.tracker, this, _client_address, _url, _header, _is);
        TrackerWebPageResponseImpl reply = new TrackerWebPageResponseImpl(_os);
        int i = 0;
        while (i < this.generators.size()) {
            TrackerWebPageGenerator generator;
            try {
                this.this_mon.enter();
                if (i >= this.generators.size()) {
                    this.this_mon.exit();
                    break;
                }
                generator = (TrackerWebPageGenerator)this.generators.get(i);
            }
            finally {
                this.this_mon.exit();
            }
            if (generator.generate(request2, reply)) {
                reply.complete();
                return true;
            }
            ++i;
        }
        return false;
    }

    public TrackerWebPageGenerator[] getPageGenerators() {
        TrackerWebPageGenerator[] res = new TrackerWebPageGenerator[this.generators.size()];
        this.generators.toArray(res);
        return res;
    }

    public void addPageGenerator(TrackerWebPageGenerator generator) {
        try {
            this.this_mon.enter();
            this.generators.add(generator);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removePageGenerator(TrackerWebPageGenerator generator) {
        try {
            this.this_mon.enter();
            this.generators.remove(generator);
        }
        finally {
            this.this_mon.exit();
        }
    }
}

