/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.SWT;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.ui.SWT.GraphicSWT;
import org.gudy.azureus2.plugins.ui.SWT.SWTManager;
import org.gudy.azureus2.pluginsimpl.local.ui.SWT.GraphicSWTImpl;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class SWTManagerImpl
implements SWTManager {
    protected static SWTManagerImpl singleton;
    private static AEMonitor class_mon;

    static {
        class_mon = new AEMonitor("SWTManager");
    }

    public static SWTManagerImpl getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new SWTManagerImpl();
            }
            SWTManagerImpl sWTManagerImpl = singleton;
            class_mon.exit();
            return sWTManagerImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public Display getDisplay() {
        return SWTThread.getInstance().getDisplay();
    }

    public GraphicSWT createGraphic(Image img) {
        return new GraphicSWTImpl(img);
    }

    public void addView(final PluginView view, boolean bAutoOpen) {
        try {
            final MainWindow window = MainWindow.getWindow();
            if (window != null) {
                window.getMenu().addPluginView(view);
                if (bAutoOpen) {
                    window.getDisplay().asyncExec((Runnable)new AERunnable(){

                        public void runSupport() {
                            window.openPluginView(view);
                        }
                    });
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addView(PluginView view) {
        this.addView(view, false);
    }
}

