/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;

public class CategoryAdderWindow {
    private Category newCategory = null;

    public CategoryAdderWindow(Display display) {
        final Shell shell = new Shell(display, 67680);
        shell.setText(MessageText.getString("CategoryAddWindow.title"));
        if (!Constants.isOSX) {
            shell.setImage(ImageRepository.getImage("azureus"));
        }
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
        Label label = new Label((Composite)shell, 0);
        label.setText(MessageText.getString("CategoryAddWindow.message"));
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        label.setLayoutData((Object)gridData);
        final Text category = new Text((Composite)shell, 2048);
        gridData = new GridData();
        gridData.widthHint = 300;
        category.setLayoutData((Object)gridData);
        Composite panel = new Composite((Composite)shell, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        panel.setLayoutData((Object)gridData);
        Button ok = new Button(panel, 8);
        ok.setText(MessageText.getString("Button.ok"));
        gridData = new GridData();
        gridData.widthHint = 70;
        ok.setLayoutData((Object)gridData);
        shell.setDefaultButton(ok);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    if (category.getText() != "") {
                        CategoryAdderWindow.this.newCategory = CategoryManager.createCategory(category.getText());
                    }
                    shell.dispose();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        Button cancel = new Button(panel, 8);
        cancel.setText(MessageText.getString("Button.cancel"));
        gridData = new GridData();
        gridData.widthHint = 70;
        cancel.setLayoutData((Object)gridData);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        shell.pack();
        Utils.createURLDropTarget((Control)shell, category);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public Category getNewCategory() {
        return this.newCategory;
    }
}

