/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.animations.Animator;
import org.gudy.azureus2.ui.swt.animations.shell.AnimableShell;
import org.gudy.azureus2.ui.swt.animations.shell.LinearAnimator;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;

public class MessagePopupShell
implements AnimableShell {
    private Shell shell;
    private Shell detailsShell;
    Image shellImg;
    private Display display;
    public static final String ICON_ERROR = "error";
    public static final String ICON_WARNING = "warning";
    public static final String ICON_INFO = "info";
    private Animator currentAnimator;
    private boolean closeAfterAnimation;
    int x0;
    int y0;
    int x1;
    int y1;

    public MessagePopupShell(Display display, String icon, String title, String errorMessage, String details) {
        this.display = display;
        this.detailsShell = new Shell(display, 18432);
        if (!Constants.isOSX) {
            this.detailsShell.setImage(ImageRepository.getImage("azureus"));
        }
        this.detailsShell.setLayout((Layout)new FillLayout());
        StyledText textDetails = new StyledText((Composite)this.detailsShell, 2824);
        textDetails.setBackground(display.getSystemColor(1));
        textDetails.setWordWrap(true);
        this.detailsShell.layout();
        this.detailsShell.setSize(500, 300);
        this.shell = new Shell(display, 16384);
        this.shell.setSize(250, 150);
        if (!Constants.isOSX) {
            this.shell.setImage(ImageRepository.getImage("azureus"));
        }
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        try {
            layout.spacing = 0;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.shell.setLayout((Layout)layout);
        this.shellImg = new Image((Device)display, ImageRepository.getImage("popup"), 0);
        GC gcImage = new GC((Drawable)this.shellImg);
        Image imgIcon = ImageRepository.getImage(icon);
        imgIcon.setBackground(this.shell.getBackground());
        gcImage.drawImage(imgIcon, 5, 5);
        Font tempFont = this.shell.getFont();
        FontData[] fontDataMain = tempFont.getFontData();
        int i = 0;
        while (i < fontDataMain.length) {
            fontDataMain[i].setStyle(1);
            fontDataMain[i].setHeight((int)((double)fontDataMain[i].getHeight() * 1.2));
            ++i;
        }
        Font fontTitle = new Font((Device)display, fontDataMain);
        gcImage.setFont(fontTitle);
        GCStringPrinter.printString(gcImage, title, new Rectangle(59, 11, 182, 43));
        gcImage.setFont(tempFont);
        fontTitle.dispose();
        boolean bItFit = GCStringPrinter.printString(gcImage, errorMessage, new Rectangle(5, 40, 240, 60));
        gcImage.dispose();
        if (!bItFit && details == null) {
            details = errorMessage;
        }
        if (details != null) {
            textDetails.setText(details);
        }
        final Button btnDetails = new Button((Composite)this.shell, 2);
        Messages.setLanguageText((Widget)btnDetails, "popup.error.details");
        btnDetails.setEnabled(details != null);
        Button btnHide = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)btnHide, "popup.error.hide");
        Label lblImage = new Label((Composite)this.shell, 0);
        lblImage.setImage(this.shellImg);
        FormData formData = new FormData();
        formData.right = new FormAttachment((Control)btnHide, -5);
        formData.bottom = new FormAttachment(100, -5);
        btnDetails.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        btnHide.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        lblImage.setLayoutData((Object)formData);
        this.shell.layout();
        btnHide.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (MessagePopupShell.this.currentAnimator == null) {
                    MessagePopupShell.this.detailsShell.setVisible(false);
                    MessagePopupShell.this.detailsShell.forceActive();
                    MessagePopupShell.this.detailsShell.forceFocus();
                    MessagePopupShell.this.currentAnimator = new LinearAnimator(MessagePopupShell.this, new Point(MessagePopupShell.this.x0, MessagePopupShell.this.y1), new Point(MessagePopupShell.this.x1, MessagePopupShell.this.y1), 20, 30);
                    MessagePopupShell.this.currentAnimator.start();
                    MessagePopupShell.this.closeAfterAnimation = true;
                }
            }
        });
        btnDetails.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MessagePopupShell.this.detailsShell.setVisible(btnDetails.getSelection());
            }
        });
        Rectangle bounds = display.getClientArea();
        this.x0 = bounds.x + bounds.width - 255;
        this.x1 = bounds.x + bounds.width;
        this.y0 = bounds.y + bounds.height;
        this.y1 = bounds.y + bounds.height - 155;
        this.shell.setLocation(this.x0, this.y0);
        this.detailsShell.setLocation(this.x1 - this.detailsShell.getSize().x, this.y1 - this.detailsShell.getSize().y);
        this.currentAnimator = new LinearAnimator(this, new Point(this.x0, this.y0), new Point(this.x0, this.y1), 20, 30);
        this.currentAnimator.start();
        this.shell.open();
    }

    public void animationEnded(Animator source) {
        if (source == this.currentAnimator) {
            this.currentAnimator = null;
        }
        if (this.closeAfterAnimation) {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    MessagePopupShell.this.shell.dispose();
                    MessagePopupShell.this.detailsShell.dispose();
                    MessagePopupShell.this.shellImg.dispose();
                }
            });
        }
    }

    public void animationStarted(Animator source) {
    }

    public Shell getShell() {
        return this.shell;
    }

    public void reportPercent(int percent) {
    }
}

