/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.systray;

import java.util.List;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;

public class SystemTraySWT {
    MainWindow mainWindow;
    Display display;
    Tray tray;
    TrayItem trayItem;
    Menu menu;

    public SystemTraySWT(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.display = mainWindow.getDisplay();
        this.tray = this.display.getSystemTray();
        this.trayItem = new TrayItem(this.tray, 0);
        if (!Constants.isOSX) {
            this.trayItem.setImage(ImageRepository.getImage("azureus"));
        }
        this.trayItem.setVisible(true);
        this.menu = new Menu((Decorations)mainWindow.getShell(), 8);
        MenuItem itemShow = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemShow, "SystemTray.menu.show");
        new MenuItem(this.menu, 2);
        MenuItem itemCloseAll = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemCloseAll, "SystemTray.menu.closealldownloadbars");
        new MenuItem(this.menu, 2);
        MenuItem itemStartAll = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemStartAll, "SystemTray.menu.startalltransfers");
        MenuItem itemStopAll = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemStopAll, "SystemTray.menu.stopalltransfers");
        final MenuItem itemPause = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemPause, "SystemTray.menu.pausetransfers");
        final MenuItem itemResume = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemResume, "SystemTray.menu.resumetransfers");
        new MenuItem(this.menu, 2);
        MenuItem itemExit = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemExit, "SystemTray.menu.exit");
        itemShow.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.show();
            }
        });
        itemStartAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.mainWindow.getGlobalManager().startAllDownloads();
            }
        });
        itemStopAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.mainWindow.getGlobalManager().stopAllDownloads();
            }
        });
        itemPause.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.mainWindow.getGlobalManager().pauseDownloads();
            }
        });
        itemResume.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.mainWindow.getGlobalManager().resumeDownloads();
            }
        });
        this.menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent _menu) {
                itemPause.setEnabled(SystemTraySWT.this.mainWindow.getGlobalManager().canPauseDownloads());
                itemResume.setEnabled(SystemTraySWT.this.mainWindow.getGlobalManager().canResumeDownloads());
            }

            public void menuHidden(MenuEvent _menu) {
            }
        });
        itemCloseAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.mainWindow.closeDownloadBars();
            }
        });
        itemExit.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.mainWindow.dispose(false, false);
            }
        });
        this.trayItem.addListener(14, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.show();
            }
        });
        this.trayItem.addListener(35, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.menu.setVisible(true);
            }
        });
    }

    public void dispose() {
        if (this.trayItem != null && !this.trayItem.isDisposed()) {
            this.trayItem.dispose();
        }
    }

    public void update() {
        if (this.trayItem.isDisposed()) {
            return;
        }
        List managers = this.mainWindow.getGlobalManager().getDownloadManagers();
        StringBuffer toolTip = new StringBuffer();
        int seeding = 0;
        int downloading = 0;
        int i = 0;
        while (i < managers.size()) {
            DownloadManager manager = (DownloadManager)managers.get(i);
            int state = manager.getState();
            if (state == 50) {
                ++downloading;
            }
            if (state == 60) {
                ++seeding;
            }
            ++i;
        }
        toolTip.append(seeding);
        toolTip.append(MessageText.getString("SystemTray.tooltip.seeding"));
        toolTip.append(downloading);
        toolTip.append(String.valueOf(MessageText.getString("SystemTray.tooltip.downloading")) + MessageText.getString("ConfigView.download.abbreviated") + " ");
        toolTip.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(this.mainWindow.getGlobalManager().getStats().getDownloadAverage()));
        toolTip.append(", " + MessageText.getString("ConfigView.upload.abbreviated") + " ");
        toolTip.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(this.mainWindow.getGlobalManager().getStats().getUploadAverage()));
        this.trayItem.setToolTipText(toolTip.toString());
        this.trayItem.setImage(ImageRepository.getImage("azureus"));
        this.trayItem.setVisible(true);
    }

    private void show() {
        if (!COConfigurationManager.getBooleanParameter("Password enabled", false)) {
            this.mainWindow.setVisible(true);
        } else {
            PasswordWindow.showPasswordWindow(MainWindow.getWindow().getDisplay());
        }
    }

    public Menu getMenu() {
        return this.menu;
    }
}

