/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.rmi;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.rmi.RMI;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RMIStubSource {
    private static int s_longestBuiltin;
    private static final String s_deleteBuiltin;
    private static final String s_castBuiltin;
    private static final String s_execBuiltin;
    private static final String s_superBuiltin = "_super";
    private static final String s_self = "self";
    SymbolID d_baseClass = null;
    SymbolID d_classInfo = null;
    SymbolID d_classInfoI = null;
    private LanguageWriterForC d_writer;

    public static void generateCode(Symbol symbol, LanguageWriterForC writer) throws CodeGenerationException {
        RMIStubSource source = new RMIStubSource(writer);
        source.generateCode(symbol);
    }

    public RMIStubSource(LanguageWriterForC writer) {
        this.d_writer = writer;
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        if (symbol != null) {
            switch (symbol.getSymbolType()) {
                case 11: 
                case 13: 
                case 14: {
                    break;
                }
                case 12: {
                    this.generateSource((Class)symbol);
                }
            }
        }
    }

    private void lookupSymbolIDs() {
        SymbolTable table = SymbolTable.getInstance();
        this.d_baseClass = table.lookupSymbol(BabelConfiguration.getBaseClass()).getSymbolID();
        this.d_classInfo = table.lookupSymbol(BabelConfiguration.getClassInfo()).getSymbolID();
        this.d_classInfoI = table.lookupSymbol(BabelConfiguration.getClassInfoI()).getSymbolID();
    }

    private void generateSource(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        Object baseClass = null;
        Object classInfo = null;
        Object classInfoI = null;
        String source = IOR.getSourceFile(id);
        this.d_writer.printlnUnformatted("#include <stdlib.h>");
        this.d_writer.printlnUnformatted("#include <string.h>");
        if (!cls.isAbstract()) {
            this.lookupSymbolIDs();
            this.d_writer.generateInclude(C.getHeaderFile(this.d_baseClass), true);
            this.d_writer.generateInclude(C.getHeaderFile(this.d_classInfo), true);
        }
        this.d_writer.printlnUnformatted("#include \"sidl_rmi_ProtocolFactory.h\"");
        this.d_writer.printlnUnformatted("#include \"sidl_rmi_InstanceHandle.h\"");
        this.d_writer.printlnUnformatted("#include \"sidl_rmi_Invocation.h\"");
        this.d_writer.printlnUnformatted("#include \"sidl_rmi_Response.h\"");
        this.d_writer.println();
        this.d_writer.printlnUnformatted("#ifndef NULL");
        this.d_writer.printlnUnformatted("#define NULL 0");
        this.d_writer.printlnUnformatted("#endif");
        this.d_writer.println();
        String my_mutex = IOR.getSymbolName(id) + "__mutex";
        String lock_name = IOR.getLockStaticGlobalsMacroName();
        String unlock_name = IOR.getUnlockStaticGlobalsMacroName();
        String have_lock = IOR.getHaveLockStaticGlobalsMacroName();
        this.d_writer.printlnUnformatted("#include \"sidl_thread.h\"");
        this.d_writer.printlnUnformatted("#ifdef HAVE_PTHREAD");
        this.d_writer.printlnUnformatted("static struct sidl_recursive_mutex_t " + my_mutex + "= SIDL_RECURSIVE_MUTEX_INITIALIZER;");
        this.d_writer.printlnUnformatted("#define " + lock_name + " sidl_recursive_mutex_lock( &" + my_mutex + " )");
        this.d_writer.printlnUnformatted("#define " + unlock_name + " sidl_recursive_mutex_unlock( &" + my_mutex + " )");
        this.d_writer.printlnUnformatted("/* #define " + have_lock + " (sidl_recursive_mutex_trylock( &" + my_mutex + " )==EDEADLOCK) */");
        this.d_writer.printlnUnformatted("#else");
        this.d_writer.printlnUnformatted("#define " + lock_name);
        this.d_writer.printlnUnformatted("#define " + unlock_name);
        this.d_writer.printlnUnformatted("/* #define " + have_lock + " (1) */");
        this.d_writer.printlnUnformatted("#endif");
        this.d_writer.println();
        this.generateStaticVariables(cls);
        this.generateRemoteCastFunction(cls);
        this.generateRemoteDeleteFunction(cls);
        this.generateRemoteExecFunction(cls);
        this.generateRemoteMethodBodies(cls);
        this.generateRemoteInitEPV(cls);
        this.generateRemoteConstructor(cls);
    }

    private void comment(String s) {
        this.d_writer.writeCommentLine(s);
    }

    private void generateStaticVariables(Class cls) {
        this.comment("Static variables to hold version of IOR");
        this.d_writer.println("static const int32_t s_IOR_MAJOR_VERSION = 0;");
        this.d_writer.println("static const int32_t s_IOR_MINOR_VERSION = 9;");
        this.d_writer.println();
        if (!cls.isAbstract()) {
            // empty if block
        }
        this.comment("Static variables for managing EPV initialization.");
        boolean has_static = cls.hasStaticMethod(true);
        boolean doIceptors = IOR.supportInterceptors(cls);
        this.d_writer.println("static int s_remote_initialized = 0;");
        this.d_writer.println();
        IOR.generateStaticEPVVariables(this.d_writer, cls, false, true, 0);
        Set parents = Utilities.getAllParents(cls);
        Set new_interfaces = Utilities.getUniqueInterfaceIDs(cls);
        if (!parents.isEmpty()) {
            ArrayList sorted = Utilities.sort(parents);
            Iterator i = sorted.iterator();
            while (i.hasNext()) {
                SymbolID p_id = (SymbolID)i.next();
                String p_name = IOR.getSymbolName(p_id);
                String p_lower = p_name.toLowerCase();
                String p_epv = "static " + IOR.getEPVName(p_id);
                boolean is_old = !new_interfaces.contains(p_id);
                String p_epvStr = is_old ? p_epv + "  " : p_epv + " ";
                this.d_writer.print(p_epvStr);
                this.d_writer.println(IOR.getStaticEPVVariable(p_id, 2, 0) + ";");
                this.d_writer.println();
            }
        }
    }

    private void generateExternalReferences(Class cls) {
        this.comment("Declare EPV routines defined in the skeleton file.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.openCxxExtern();
        this.d_writer.println("extern void " + IOR.getSetEPVName(id) + "(");
        this.d_writer.tab();
        this.d_writer.println(IOR.getEPVName(id) + "* epv);");
        this.d_writer.backTab();
        if (cls.hasStaticMethod(true)) {
            this.d_writer.println("extern void " + IOR.getSetSEPVName(id) + "(");
            this.d_writer.tab();
            this.d_writer.println(IOR.getSEPVName(id) + "* sepv);");
            this.d_writer.backTab();
        }
        this.d_writer.println("extern void " + IOR.getCallLoadName(id) + "(void);");
        this.d_writer.closeCxxExtern();
        this.d_writer.println();
    }

    private void generateCastFunction(Class cls) {
        this.comment("CAST: dynamic type casting support.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("static void* ior_" + IOR.getSymbolName(id) + '_' + s_castBuiltin + '(');
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* self,");
        this.d_writer.println("const char* name)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("void* cast = NULL;");
        this.d_writer.println();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        this.generateCastLogic(cls, 0);
        this.d_writer.println();
        this.d_writer.println("return cast;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateCastLogic(Class cls, int level) {
        String self = "s" + String.valueOf(level);
        if (level > 0) {
            this.d_writer.print("} else ");
        }
        this.d_writer.println("if (!strcmp(name, \"" + cls.getFullName() + "\")) {");
        this.d_writer.tab();
        this.d_writer.println("cast = (void*) " + self + ";");
        this.d_writer.backTab();
        ArrayList interfaces = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
        Iterator i = interfaces.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            String fn = id.getFullName();
            String lower = IOR.getSymbolName(id).toLowerCase();
            this.d_writer.println("} else if (!strcmp(name, \"" + fn + "\")) {");
            this.d_writer.tab();
            this.d_writer.println("cast = (void*) &" + self + "->d_" + lower + ";");
            this.d_writer.backTab();
        }
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.generateCastLogic(parent, level + 1);
        } else {
            this.d_writer.println("}");
        }
    }

    private String getBaseControls(boolean doStatic, String self) {
        return doStatic ? "s_control_stats" : self + "->" + "d_controls";
    }

    private String getRemoteMethodName(SymbolID id, String name) {
        return "remote_" + IOR.getSymbolName(id) + '_' + name;
    }

    private void generateBaseCall(String name, String suffix, String var, List args, boolean isStatic, boolean doThrows, Type returnType) throws CodeGenerationException {
        boolean isOrig = suffix.equals("");
        if (isOrig && returnType != null && returnType.getType() != 0) {
            this.d_writer.print("_result = ");
        }
        this.d_writer.print("(" + var + "->");
        this.d_writer.println(IOR.getVectorEntry(name + suffix) + ")(");
        this.d_writer.tab();
        this.d_writer.tab();
        C.generateArguments(this.d_writer, s_self, args, isStatic, doThrows, suffix.equals("_post") ? returnType : null, false, false, false);
        this.d_writer.println(");");
        this.d_writer.backTab();
        this.d_writer.backTab();
    }

    private String getBuiltinInterceptorName(SymbolID id, boolean doStatic) {
        return this.getRemoteMethodName(id, IOR.getBuiltinName(7, doStatic));
    }

    private void generateInterceptorFunction(Class cls, boolean doStatic) {
        String desc = doStatic ? "static " : "";
        this.comment("INTERCEPTORS: set " + desc + "interceptor activation.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("static void " + this.getBuiltinInterceptorName(id, doStatic) + '(');
        this.d_writer.tab();
        if (!doStatic) {
            this.d_writer.println(IOR.getObjectName(id) + "* " + s_self + ",");
        }
        this.d_writer.println("int on)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        if (IOR.supportInterceptors(cls)) {
            String base = this.getBaseControls(doStatic, s_self) + ".";
            String use = base + "use_iceptors";
            this.d_writer.println(use + " = on;");
            if (!doStatic) {
                this.d_writer.println();
                this.d_writer.println("/* Ensure the EPVs are set properly. */");
                String publicepv = "self->" + IOR.getEPVVar(0);
                this.d_writer.println("if (" + use + ") {");
                this.d_writer.tab();
                this.d_writer.println(publicepv + "  = &" + IOR.getStaticEPVVariable(id, 0, 2) + ";");
                this.d_writer.backTab();
                this.d_writer.println("} else {");
                this.d_writer.tab();
                this.d_writer.println(publicepv + "  = &" + IOR.getStaticEPVVariable(id, 0, 0) + ";");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println("");
            }
        } else {
            this.comment("Nothing to do since interceptor support not needed.");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private String getInterceptorMethodName(Extendable ext, Method meth) {
        return "iceptor_" + IOR.getSymbolName(ext.getSymbolID()) + '_' + meth.getLongMethodName();
    }

    private void generateAllInterceptors(Class cls) throws CodeGenerationException {
        ArrayList invariants = cls.getAllInvariants();
        List normal = (List)cls.getMethods(true);
        Iterator i = normal.iterator();
        Method meth = null;
        while (i.hasNext()) {
            meth = (Method)i.next();
            this.generateInterceptor(cls, meth);
        }
    }

    private void generateInterceptor(Class cls, Method meth) throws CodeGenerationException {
        String var;
        SymbolID id = cls.getSymbolID();
        String name = meth.getLongMethodName();
        String methname = this.getInterceptorMethodName(cls, meth);
        Type type = meth.getReturnType();
        String retStr = RMIStubSource.getReturnString(type);
        boolean hasReturn = false;
        if (type != null && type.getType() != 0) {
            hasReturn = true;
        }
        this.comment("Sandwich the execution of the method between the pre- and post- calls.");
        this.d_writer.println("static " + retStr + " " + methname + "(");
        this.d_writer.tab();
        ArrayList args = meth.getArgumentList();
        boolean hasThrows = !meth.getThrows().isEmpty();
        boolean isStatic = meth.isStatic();
        C.generateArguments(this.d_writer, IOR.getObjectName(id) + "* " + s_self, (List)args, isStatic, hasThrows, null, true, true, false);
        this.d_writer.println(")");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        boolean addBlank = false;
        if (hasReturn) {
            this.d_writer.println(retStr + " " + "_result" + ";");
            addBlank = true;
        }
        if (isStatic) {
            var = "sepv";
            this.d_writer.println(IOR.getSEPVName(id) + "* " + var + " = " + IOR.getLocalStaticsName(id) + "(" + IOR.getStaticTypeOption(id, 0) + ");");
            addBlank = true;
        } else {
            var = "epv";
            this.d_writer.println(IOR.getEPVName(id) + "* " + var + " = &" + IOR.getStaticEPVVariable(id, 0, 0) + ";");
            addBlank = true;
        }
        if (addBlank) {
            this.d_writer.println();
        }
        this.generateBaseCall(name, "_pre", var, args, isStatic, false, null);
        this.generateBaseCall(name, "", var, args, isStatic, hasThrows, type);
        this.generateBaseCall(name, "_post", var, args, isStatic, false, type);
        if (hasReturn) {
            this.d_writer.println();
            this.d_writer.println("return _result;");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private static String getReturnString(Type type) throws CodeGenerationException {
        return IOR.getReturnString(type, true, false);
    }

    private void generateDeleteFunction(Class cls) {
        this.comment("DELETE: call destructor and free object memory.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        this.d_writer.println("static void ior_" + name + '_' + s_deleteBuiltin + '(');
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* self)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println(IOR.getFiniName(id) + "(self);");
        this.d_writer.println("memset((void*)self, 0, sizeof(" + IOR.getObjectName(id) + "));");
        this.d_writer.println("free((void*) self);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateSuperFunction(Class cls) {
        this.comment("SUPER: return's parent's non-overrided EPV");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        Class parent = cls.getParentClass();
        if (parent != null) {
            SymbolID pid = parent.getSymbolID();
            this.d_writer.println("static " + IOR.getEPVName(pid) + "* " + IOR.getSymbolName(id) + '_' + s_superBuiltin + "(void) {");
            this.d_writer.tab();
            this.d_writer.println("return " + IOR.getStaticEPVVariable(pid, 1, 0) + ';');
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitEPV(Class cls) throws CodeGenerationException {
        this.comment("EPV: create method entry point vector (EPV) structure.");
        String epvVar = "epv";
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String object = IOR.getObjectName(id);
        boolean doIceptors = IOR.supportInterceptors(cls);
        this.d_writer.println("static void " + name + "__init_epv(");
        this.d_writer.tab();
        this.comment("assert( " + IOR.getHaveLockStaticGlobalsMacroName() + " );");
        this.d_writer.println(object + "* self)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        if (cls.getParentClass() != null) {
            this.generateParentSelf(cls, 0, 0);
            this.d_writer.println();
        }
        ArrayList parents = Utilities.sort(Utilities.getAllParents(cls));
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.saveEPVs(parent, 1);
        }
        List methods = (List)cls.getNonstaticMethods(true);
        int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length();
        for (int j = 0; j < 10; ++j) {
            if (!IOR.isBuiltinBasic(j) && (j != 7 || !doIceptors)) continue;
            String mname = IOR.getBuiltinName(j);
            this.d_writer.print("epv->");
            this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
            if (j == 3 || j == 4 || j == 8) {
                this.d_writer.println(" = NULL;");
                continue;
            }
            this.d_writer.println(" = " + this.getRemoteMethodName(id, mname) + ';');
        }
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            boolean parentHas;
            Method method = (Method)i.next();
            String mname = method.getLongMethodName();
            String ename = IOR.getVectorEntry(mname);
            boolean bl = parentHas = parent != null && parent.hasMethodByLongName(mname, true);
            if (doIceptors) {
                this.d_writer.print("epv->");
                this.d_writer.printAligned(ename + "_pre", mwidth);
                this.d_writer.println(" = NULL;");
                this.generateNonstaticEPV(method, object, "epv", ename, parentHas, mwidth);
                this.d_writer.print("epv->");
                this.d_writer.printAligned(ename + "_post", mwidth);
                this.d_writer.println(" = NULL;");
                continue;
            }
            this.generateNonstaticEPV(method, object, "epv", ename, parentHas, mwidth);
        }
        this.d_writer.println();
        this.d_writer.println();
        if (doIceptors) {
            String xEPV = "iepv";
            this.d_writer.println("memcpy((void*)" + xEPV + ", " + "epv" + ", sizeof(" + IOR.getEPVName(id) + "));");
            this.generateEPVMethodAssignments(cls, 2, xEPV, false);
            this.d_writer.println();
        }
        this.copyEPVs(parents);
        this.d_writer.println("s_method_initialized = 1;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateNonstaticEPV(Method m, String object, String var, String ename, boolean parentHas, int width) throws CodeGenerationException {
        this.d_writer.print(var + "->");
        this.d_writer.printAligned(ename, width);
        if (parentHas) {
            this.d_writer.print(" = ");
            this.d_writer.print(IOR.getCast(m, object + "*"));
            this.d_writer.println(" s1->" + IOR.getEPVVar(0) + "->" + ename + ";");
        } else {
            this.d_writer.println(" = NULL;");
        }
    }

    private void generateInitSEPV(Class cls) throws CodeGenerationException {
        if (cls.hasStaticMethod(true)) {
            int w;
            this.comment("SEPV: create the static entry point vector (SEPV).");
            SymbolID id = cls.getSymbolID();
            String name = IOR.getSymbolName(id);
            String lower = name.toLowerCase();
            int width = name.length();
            this.d_writer.println("static void " + name + "__init_sepv(void)");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.comment("assert( " + IOR.getHaveLockStaticGlobalsMacroName() + " );");
            Class parent = cls.getParentClass();
            SymbolID pid = null;
            boolean includeParent = parent != null && parent.hasStaticMethod(true);
            boolean doIceptors = IOR.supportInterceptors(cls);
            if (includeParent && (w = IOR.getSymbolName(pid = parent.getSymbolID()).length()) > width) {
                width = w;
            }
            this.d_writer.printAligned(IOR.getSEPVName(id) + "*", width += "struct __sepv*".length());
            this.d_writer.println(" s = &" + IOR.getStaticEPVVariable(id, 3, 0) + ";");
            if (doIceptors) {
                this.d_writer.printAligned(IOR.getSEPVName(id) + "*", width);
                this.d_writer.println("is = &" + IOR.getStaticEPVVariable(id, 3, 2) + ";");
            }
            if (includeParent) {
                this.d_writer.printAligned(IOR.getSEPVName(pid) + "*", width);
                this.d_writer.println(" p = " + IOR.getStaticsName(pid) + "();");
            }
            this.d_writer.println();
            String var = "s";
            List methods = (List)cls.getStaticMethods(true);
            int mwidth = Utilities.getWidth(methods) + IOR.getVectorEntry("").length() + 5 + var.length() + 2;
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                boolean parentHas;
                Method method = (Method)i.next();
                String mname = method.getLongMethodName();
                String ename = IOR.getVectorEntry(mname);
                boolean bl = parentHas = parent != null && parent.hasMethodByLongName(mname, true);
                if (doIceptors) {
                    this.d_writer.print(var + "->");
                    this.d_writer.printAligned(ename + "_pre", mwidth);
                    this.d_writer.print(" = NULL;");
                    this.generateStaticEPV(var, ename, parentHas, mwidth);
                    this.d_writer.print(var + "->");
                    this.d_writer.printAligned(ename + "_post", mwidth);
                    this.d_writer.print(" = NULL;");
                    continue;
                }
                this.generateStaticEPV(var, ename, parentHas, mwidth);
            }
            this.d_writer.println();
            this.d_writer.println(IOR.getSetSEPVName(id) + "(s);");
            this.d_writer.println();
            this.d_writer.println("s_static_initialized = 1;");
            this.d_writer.println("ior_" + name + "__ensure_load_called();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateStaticEPV(String var, String ename, boolean parentHas, int mwidth) throws CodeGenerationException {
        this.d_writer.print(var + "->");
        this.d_writer.printAligned(ename, mwidth);
        if (parentHas) {
            this.d_writer.println(" = p->" + ename + ";");
        } else {
            this.d_writer.println(" = NULL;");
        }
    }

    void generateEPVMethodAssignments(Extendable ext, int setType, String ptrVar, boolean doStatics) {
        List methods = doStatics ? (List)ext.getStaticMethods(true) : (List)ext.getNonstaticMethods(true);
        Iterator i = methods.iterator();
        Method m = null;
        int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length() + ptrVar.length() + 2;
        while (i.hasNext()) {
            m = (Method)i.next();
            String mName = m.getLongMethodName();
            this.d_writer.printAligned(ptrVar + "->" + IOR.getVectorEntry(mName), mwidth);
            this.d_writer.println(" = " + this.getInterceptorMethodName(ext, m) + ";");
        }
    }

    private void generateStaticFunction(Class cls, boolean doLocal) {
        boolean doIceptors = IOR.supportInterceptors(cls);
        if (cls.hasStaticMethod(true) && (!doLocal || doIceptors)) {
            String desc = doLocal ? "specified " : "";
            this.comment("STATIC: return pointer to " + desc + "static EPV structure.");
            SymbolID id = cls.getSymbolID();
            String name = IOR.getSymbolName(id);
            String lower = name.toLowerCase();
            this.d_writer.println(IOR.getSEPVName(id) + "*");
            if (doLocal) {
                this.d_writer.println(IOR.getLocalStaticsName(id) + "(int type)");
            } else {
                this.d_writer.println(IOR.getStaticsName(id) + "(void)");
            }
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
            if (doIceptors) {
                this.d_writer.println(IOR.getSEPVName(id) + "* sepv;");
            }
            this.d_writer.println("if (!s_static_initialized) {");
            this.d_writer.tab();
            this.d_writer.println(name + "__init_sepv();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
            boolean cont = false;
            if (doIceptors) {
                if (cont) {
                    this.d_writer.print(" else ");
                }
                if (doLocal) {
                    this.d_writer.println("if (type == " + IOR.getStaticTypeOption(id, 2) + ") {");
                } else {
                    this.d_writer.println("if (" + this.getBaseControls(true, "") + "." + "use_iceptors" + ") {");
                }
                this.d_writer.tab();
                this.d_writer.println("sepv = &" + IOR.getStaticEPVVariable(id, 3, 2) + ";");
                this.d_writer.backTab();
                this.d_writer.print("}");
            }
            if (doIceptors) {
                this.d_writer.println(" else {");
                this.d_writer.tab();
                this.d_writer.println("sepv = &" + IOR.getStaticEPVVariable(id, 3, 0) + ";");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println("return sepv;");
            } else {
                this.d_writer.println("return &" + IOR.getStaticEPVVariable(id, 3, 0) + ";");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateEnsureLoad(Class cls) {
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String lower = name.toLowerCase();
        this.d_writer.println("static void ior_" + name + "__ensure_load_called(void) {");
        this.d_writer.tab();
        this.comment("assert( " + IOR.getHaveLockStaticGlobalsMacroName() + " );");
        this.d_writer.println("if (! s_load_called ) {");
        this.d_writer.tab();
        this.d_writer.println(name + "__call_load();");
        this.d_writer.println("s_load_called=1;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateStaticFunction(Class cls) {
        if (cls.hasStaticMethod(true)) {
            this.comment("STATIC: return static EPV structure for static methods.");
            SymbolID id = cls.getSymbolID();
            String name = IOR.getSymbolName(id);
            String lower = name.toLowerCase();
            this.d_writer.println(IOR.getSEPVName(id) + "*");
            this.d_writer.println(IOR.getStaticsName(id) + "(void)");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
            this.d_writer.println("if (!s_static_initialized) {");
            this.d_writer.tab();
            this.d_writer.println(name + "__init_sepv();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
            this.d_writer.println("return &" + IOR.getStaticEPVVariable(id, 3, 0) + ";");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitClassInfo(Class cls) {
        if (!cls.isAbstract()) {
            if (this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println("static void initMetadata(" + IOR.getObjectName(cls.getSymbolID()) + "*);");
                this.d_writer.println();
            }
            this.comment("initClassInfo: create a ClassInfo interface if necessary.");
            this.d_writer.println("static void");
            this.d_writer.println("initClassInfo(" + C.getObjectName(this.d_classInfo) + " *info)");
            this.d_writer.println("{");
            this.d_writer.tab();
            if (!this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
            } else {
                this.d_writer.writeCommentLine("ClassInfo for ClassInfoI is a special case");
                this.d_writer.writeCommentLine(IOR.getUnlockStaticGlobalsMacroName() + ";");
            }
            this.d_writer.println("if (s_classInfo_init) {");
            this.d_writer.tab();
            this.d_writer.println(C.getObjectName(this.d_classInfoI) + " impl;");
            this.d_writer.println("s_classInfo_init = 0;");
            this.d_writer.println("impl = " + C.getFullMethodName(this.d_classInfoI, "_create") + "();");
            this.d_writer.println("s_classInfo = " + C.getFullMethodName(this.d_classInfo, "_cast") + "(impl);");
            this.d_writer.println("if (impl) {");
            this.d_writer.tab();
            this.d_writer.println(C.getFullMethodName(this.d_classInfoI, "setName") + "(impl, \"" + cls.getFullName() + "\");");
            this.d_writer.println(C.getFullMethodName(this.d_classInfoI, "setIORVersion") + "(impl, s_IOR_MAJOR_VERSION, s_IOR_MINOR_VERSION);");
            if (this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println("initMetadata(impl);");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (s_classInfo) {");
            this.d_writer.tab();
            this.d_writer.println("if (*info) {");
            this.d_writer.tab();
            this.d_writer.println(C.getFullMethodName(this.d_classInfo, "deleteRef") + "(*info);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("*info = s_classInfo;");
            this.d_writer.println(C.getFullMethodName(this.d_classInfo, "addRef") + "(*info);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            if (!this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
            } else {
                this.d_writer.writeCommentLine("ClassInfo for ClassInfoI is a special case");
                this.d_writer.writeCommentLine(IOR.getUnlockStaticGlobalsMacroName() + ";");
            }
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitMetadata(Class cls) {
        if (!cls.isAbstract()) {
            SymbolID id = cls.getSymbolID();
            String object = IOR.getObjectName(id);
            this.comment("initMetadata: store IOR version & class in sidl.BaseClass's data");
            this.d_writer.println("static void");
            this.d_writer.println("initMetadata(" + object + "* self)");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println("if (self) {");
            this.d_writer.tab();
            this.d_writer.println(C.getDataName(this.d_baseClass) + " *data = " + C.getDataGetName(this.d_baseClass) + "(" + C.getFullMethodName(this.d_baseClass, "_cast") + "(self));");
            this.d_writer.println("if (data) {");
            this.d_writer.tab();
            this.d_writer.println("data->d_IOR_major_version = s_IOR_MAJOR_VERSION;");
            this.d_writer.println("data->d_IOR_minor_version = s_IOR_MINOR_VERSION;");
            this.d_writer.println("initClassInfo(&(data->d_classinfo));");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateNewFunction(Class cls) {
        if (!cls.isAbstract()) {
            this.comment("NEW: allocate object and initialize it.");
            SymbolID id = cls.getSymbolID();
            String object = IOR.getObjectName(id);
            this.d_writer.println(object + "*");
            this.d_writer.println(IOR.getNewName(id) + "(void)");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println(object + "* self =");
            this.d_writer.tab();
            this.d_writer.println("(" + object + "*) malloc(");
            this.d_writer.tab();
            this.d_writer.println("sizeof(" + object + "));");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println(IOR.getInitName(id) + "(self);");
            this.d_writer.println("initMetadata(self);");
            this.d_writer.println("return self;");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitFunction(Class cls) {
        this.comment("INIT: initialize a new instance of the class object.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void " + IOR.getInitName(id) + "(");
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* self)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        Class parent = cls.getParentClass();
        if (parent != null) {
            String p = IOR.getSymbolName(parent.getSymbolID());
            this.d_writer.println(IOR.getInitName(parent.getSymbolID()) + "(s1);");
            this.d_writer.println();
        }
        this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
        this.d_writer.println("if (!s_method_initialized) {");
        this.d_writer.tab();
        this.d_writer.println(IOR.getSymbolName(id) + "__init_epv(s0);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
        this.d_writer.println();
        this.fixEPVs(cls, 0, true);
        ArrayList interfaces = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
        Iterator i = interfaces.iterator();
        while (i.hasNext()) {
            SymbolID iid = (SymbolID)i.next();
            String n = IOR.getSymbolName(iid).toLowerCase();
            this.d_writer.println("s0->d_" + n + ".d_object = self;");
            this.d_writer.println();
        }
        this.d_writer.println("s0->d_data = NULL;");
        this.d_writer.println();
        if (IOR.supportInterceptors(cls)) {
            this.d_writer.println(this.getBuiltinInterceptorName(id, false) + "(s0, " + "0" + ");");
        }
        this.d_writer.println();
        this.d_writer.println(RMIStubSource.methodCall(cls, s_self, IOR.getBuiltinName(3), ""));
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateFiniFunction(Class cls) {
        this.comment("FINI: deallocate a class instance (destructor).");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void " + IOR.getFiniName(id) + "(");
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* self)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        this.d_writer.println(RMIStubSource.methodCall(cls, "s0", IOR.getBuiltinName(4), ""));
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.d_writer.println();
            this.fixEPVs(parent, 1, false);
            String p = IOR.getSymbolName(parent.getSymbolID());
            this.d_writer.println(IOR.getFiniName(parent.getSymbolID()) + "(s1);");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateVersionFunction(Class cls) {
        this.comment("VERSION: Return the version of the IOR used to generate this IOR.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.println(IOR.getVersionName(id) + "(int32_t *major, int32_t *" + "minor)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("*major = s_IOR_MAJOR_VERSION;");
        this.d_writer.println("*minor = s_IOR_MINOR_VERSION;");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateRemoteCastFunction(Class cls) {
        this.comment("REMOTE CAST: dynamic type casting for remote objects.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        this.d_writer.println("static void* remote_" + name + '_' + s_castBuiltin + '(');
        this.d_writer.tab();
        if (cls.isInterface()) {
            this.d_writer.println("void* self,");
        } else {
            this.d_writer.println(IOR.getObjectName(id) + "* self,");
        }
        this.d_writer.println("const char* name)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("return NULL;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateRemoteDeleteFunction(Class cls) {
        this.comment("REMOTE DELETE: call the remote destructor for the object.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        this.d_writer.println("static void remote_" + name + '_' + s_deleteBuiltin + '(');
        this.d_writer.tab();
        if (cls.isInterface()) {
            this.d_writer.println("void* self)");
        } else {
            this.d_writer.println(IOR.getObjectName(id) + "* self)");
        }
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("free((void*) self);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateRemoteExecFunction(Class cls) throws CodeGenerationException {
        this.comment("REMOTE EXEC: call the exec function for the object.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String object = IOR.getObjectName(id);
        Method m_exec = C.getExecMethod();
        this.d_writer.println("static void remote_" + name + '_' + s_execBuiltin + '(');
        this.d_writer.tab();
        boolean has_throws = !m_exec.getThrows().isEmpty();
        ArrayList args = m_exec.getArgumentList();
        this.d_writer.print(object + "* self");
        if (args.size() > 0 || has_throws) {
            this.d_writer.println(",");
        }
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            this.d_writer.print(IOR.getArgumentWithFormal(arg, false, false, true));
            if (!a.hasNext() && !has_throws) continue;
            this.d_writer.println(",");
        }
        this.d_writer.println(")");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateRemoteMethodBodies(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String object = IOR.getObjectName(id);
        Iterator m = cls.getNonstaticMethods(true).iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            String method_name = method.getLongMethodName();
            boolean hasThrows = !method.getThrows().isEmpty();
            Type returnType = method.getReturnType();
            this.comment("REMOTE METHOD STUB:" + method_name);
            this.d_writer.println("static " + RMIStubSource.getReturnString(returnType));
            this.d_writer.println("remote_" + name + "_" + method_name + "(");
            this.d_writer.tab();
            C.generateArgumentList(this.d_writer, "self /* TLD */", cls.isInterface(), id, method, true, true, true, hasThrows, false, false, false);
            this.d_writer.println(")");
            this.d_writer.backTab();
            this.d_writer.println("{");
            this.d_writer.tab();
            if (method_name.compareTo("addRef") == 0) {
                this.comment("FIXME  need to think through all of these special cases");
            } else if (method_name.compareTo("isSame") == 0 || method_name.compareTo("queryInt") == 0 || method_name.compareTo("isType") == 0 || method_name.compareTo("getClassInfo") == 0) {
                if (!hasThrows) {
                    this.d_writer.println("sidl_BaseInterface _ex = NULL;");
                    this.d_writer.println("sidl_BaseInterface *_ex2 =&_ex;");
                } else {
                    this.d_writer.println("sidl_BaseInterface *_ex2 =_ex;");
                }
                this.comment("FIXME  need to think through all of these special cases");
                this.d_writer.println("return 0;");
                this.d_writer.println("sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;");
                this.d_writer.println("self->d_data = NULL;");
                this.d_writer.println("sidl_rmi_InstanceHandle_close(conn, _ex2);");
                this.d_writer.println("sidl_rmi_InstanceHandle_deleteRef(conn);");
            } else {
                Argument arg;
                if (!hasThrows) {
                    this.d_writer.println("sidl_BaseInterface _ex = NULL;");
                    this.d_writer.println("sidl_BaseInterface *_ex2 =&_ex;");
                } else {
                    this.d_writer.println("sidl_BaseInterface *_ex2 =_ex;");
                }
                this.comment("initialize a new invocation");
                this.d_writer.println("sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;");
                this.d_writer.println("sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn, \"" + method_name + "\", _ex2 );");
                this.d_writer.println("sidl_rmi_Response rsvp = NULL;");
                if (returnType.getType() != 0) {
                    if (returnType.getDetailedType() >= 12) {
                        this.comment("TODO: Fix returning objects and arrays");
                        this.d_writer.println(RMIStubSource.getReturnString(returnType) + " _retval = " + "NULL" + ";");
                    } else {
                        this.d_writer.println(RMIStubSource.getReturnString(returnType) + " _retval;");
                    }
                }
                this.d_writer.println();
                this.comment("pack in and inout arguments");
                ArrayList args = method.getArgumentList();
                Iterator a = args.iterator();
                while (a.hasNext()) {
                    arg = (Argument)a.next();
                    if (arg.getType().isArray() || arg.getType().isSymbol() || arg.getType().getType() == 9 || arg.getMode() != 0 && arg.getMode() != 1) continue;
                    this.d_writer.println(RMI.packArg("sidl_rmi_Invocation", "inv", arg));
                }
                this.d_writer.println();
                this.comment("send actual RMI request");
                this.d_writer.println("rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);");
                this.d_writer.println();
                if (hasThrows) {
                    this.comment("check if exception thrown.");
                    this.comment("FIXME");
                    this.d_writer.println();
                }
                this.comment("extract return value");
                if (!returnType.isArray() && !returnType.isSymbol() && returnType.getType() != 9 && returnType.getType() != 0) {
                    this.d_writer.println(RMI.unpackType("sidl_rmi_Response", "rsvp", returnType, "_retval", "&_retval"));
                }
                this.d_writer.println();
                this.comment("unpack out and inout arguments");
                a = args.iterator();
                while (a.hasNext()) {
                    arg = (Argument)a.next();
                    if (arg.getType().isArray() || arg.getType().isSymbol() || arg.getType().getType() == 9 || arg.getMode() != 2 && arg.getMode() != 1) continue;
                    this.d_writer.println(RMI.unpackArg("sidl_rmi_Response", "rsvp", arg));
                }
                this.d_writer.println();
                this.comment("cleanup and return");
                this.d_writer.println("sidl_rmi_Response_done(rsvp, _ex2);");
                this.d_writer.println("sidl_rmi_Invocation_deleteRef(inv);");
                this.d_writer.println("sidl_rmi_Response_deleteRef(rsvp);");
                if (returnType.getType() != 0) {
                    this.d_writer.println("return _retval;");
                }
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateRemoteInitEPV(Class cls) throws CodeGenerationException {
        this.comment("REMOTE EPV: create remote entry point vectors (EPVs).");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String lower = name.toLowerCase();
        this.d_writer.println("static void " + name + "__init_remote_epv(void)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.comment("assert( " + IOR.getHaveLockStaticGlobalsMacroName() + " );");
        ArrayList parents = null;
        if (cls.isInterface()) {
            this.d_writer.print(IOR.getEPVName(id) + "*");
            this.d_writer.println(" epv = &" + IOR.getStaticEPVVariable(id, 2, 0) + ";");
            this.d_writer.println();
        } else {
            parents = Utilities.sort(Utilities.getAllParents(cls));
            this.aliasEPVs(cls, parents, true);
        }
        List methods = (List)cls.getNonstaticMethods(true);
        int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length() + "_post".length();
        for (int j = 0; j < 10; ++j) {
            if (!IOR.isBuiltinBasic(j) && (j != 7 || !IOR.supportInterceptors(cls))) continue;
            String mname = IOR.getBuiltinName(j);
            this.d_writer.print("epv->");
            this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
            if (j == 3 || j == 4 || j == 8) {
                this.d_writer.println(" = NULL;");
                continue;
            }
            this.d_writer.println(" = " + this.getRemoteMethodName(id, mname) + ';');
        }
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            String mname = method.getLongMethodName();
            String ename = IOR.getVectorEntry(mname);
            if (IOR.supportInterceptors(cls)) {
                this.d_writer.print("epv->");
                this.d_writer.printAligned(ename + "_pre", mwidth);
                this.d_writer.println(" = NULL;");
                this.d_writer.print("epv->");
                this.d_writer.printAligned(ename, mwidth);
                this.d_writer.println(" = remote_" + name + "_" + mname + ";");
                this.d_writer.print("epv->");
                this.d_writer.printAligned(ename + "_post", mwidth);
                this.d_writer.println(" = NULL;");
                continue;
            }
            this.d_writer.print("epv->");
            this.d_writer.printAligned(ename, mwidth);
            this.d_writer.println(" = remote_" + name + "_" + mname + ";");
        }
        if (parents != null) {
            this.d_writer.println();
            this.copyEPVs(parents);
        }
        this.d_writer.println("s_remote_initialized = 1;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateRemoteConstructor(Class cls) {
        this.comment("REMOTE: generate remote instance given URL string.");
        SymbolID id = cls.getSymbolID();
        String idName = id.getFullName();
        String name = IOR.getSymbolName(id);
        String lower = name.toLowerCase();
        String object = IOR.getObjectName(id);
        this.d_writer.println("static " + object + "*");
        this.d_writer.println(IOR.getRemoteName(id) + "(const char *url, sidl_BaseInterface *_ex)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("sidl_rmi_InstanceHandle instance = sidl_rmi_ProtocolFactory_createInstance(url, \"" + idName + "\", _ex );");
        this.d_writer.println("if ( instance == NULL) { return NULL; }");
        this.d_writer.println(object + "* self =");
        this.d_writer.tab();
        this.d_writer.println("(" + object + "*) malloc(");
        this.d_writer.tab();
        this.d_writer.println("sizeof(" + object + "));");
        this.d_writer.backTab();
        this.d_writer.backTab();
        this.d_writer.println();
        if (!cls.isInterface()) {
            this.generateParentSelf(cls, 0, 0);
            this.d_writer.println();
        }
        this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
        this.d_writer.println("if (!s_remote_initialized) {");
        this.d_writer.tab();
        this.d_writer.println(name + "__init_remote_epv();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
        this.d_writer.println();
        if (cls.isInterface()) {
            this.d_writer.println("self->" + IOR.getEPVVar(0) + "    = &" + IOR.getStaticEPVVariable(id, 2, 0) + ";");
            this.d_writer.println("self->d_object = (void*) instance;");
        } else {
            this.remoteEPVs(cls, 0);
            this.d_writer.println("self->d_data = (void*) instance;");
        }
        this.d_writer.println();
        this.d_writer.println("return self;");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateParentSelf(Class cls, int level, int width) {
        if (cls != null) {
            if (width == 0) {
                for (Class parent = cls; parent != null; parent = parent.getParentClass()) {
                    int w = IOR.getObjectName(parent.getSymbolID()).length();
                    if (w <= width) continue;
                    width = w;
                }
            }
            SymbolID id = cls.getSymbolID();
            this.d_writer.printAligned(IOR.getObjectName(id) + "*", width + 1);
            this.d_writer.print(" s" + String.valueOf(level) + " = ");
            if (level == 0) {
                this.d_writer.println("self;");
            } else {
                this.d_writer.print("&s" + String.valueOf(level - 1) + "->d_");
                this.d_writer.println(IOR.getSymbolName(id).toLowerCase() + ";");
            }
            this.generateParentSelf(cls.getParentClass(), level + 1, width);
        }
    }

    private void fixEPVs(Class cls, int level, boolean is_new) {
        if (cls != null) {
            String epvVar = IOR.getEPVVar(0);
            this.fixEPVs(cls.getParentClass(), level + 1, is_new);
            String self = "s" + String.valueOf(level);
            String news = is_new ? "new" : "old";
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            int width = Utilities.getWidth(ifce) + "d_.".length() + epvVar.length();
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                String n = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.print(self + "->");
                this.d_writer.printAligned("d_" + n + "." + epvVar, width);
                this.d_writer.print(" = ");
                if (is_new) {
                    this.d_writer.print("&");
                }
                this.d_writer.println("s_" + news + "__" + n + ";");
            }
            String lower = IOR.getSymbolName(cls.getSymbolID()).toLowerCase();
            this.d_writer.print(self + "->");
            this.d_writer.printAligned(epvVar, width);
            this.d_writer.print(" = ");
            if (is_new) {
                this.d_writer.print("&");
            }
            this.d_writer.println("s_" + news + "__" + lower + ";");
            this.d_writer.println();
        }
    }

    private void saveEPVs(Class cls, int level) {
        if (cls != null) {
            String epvVar = IOR.getEPVVar(0);
            this.saveEPVs(cls.getParentClass(), level + 1);
            String self = "s" + String.valueOf(level);
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            int width = Utilities.getWidth(ifce);
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                String n = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.print(IOR.getStaticEPVVariable(id, 1, 0));
                this.d_writer.printSpaces(width - n.length());
                this.d_writer.println(" = " + self + "->d_" + n + "." + epvVar + ";");
            }
            String lower = IOR.getSymbolName(cls.getSymbolID()).toLowerCase();
            this.d_writer.print(IOR.getStaticEPVVariable(cls.getSymbolID(), 1, 0));
            this.d_writer.printSpaces(width - lower.length());
            this.d_writer.println(" = " + self + "->" + epvVar + ";");
            this.d_writer.println();
        }
    }

    private void remoteEPVs(Class cls, int level) {
        if (cls != null) {
            String epvVar = IOR.getEPVVar(0);
            this.remoteEPVs(cls.getParentClass(), level + 1);
            String self = "s" + String.valueOf(level);
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                String n = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.println(self + "->d_" + n + "." + epvVar + "    = &" + IOR.getStaticEPVVariable(id, 2, 0) + ";");
                this.d_writer.println(self + "->d_" + n + ".d_object = (void*) " + "instance;");
                this.d_writer.println();
            }
            String lower = IOR.getSymbolName(cls.getSymbolID()).toLowerCase();
            this.d_writer.println(self + "->d_data = (void*) instance;");
            this.d_writer.println(self + "->" + epvVar + "  = &" + IOR.getStaticEPVVariable(cls.getSymbolID(), 2, 0) + ";");
            this.d_writer.println();
        }
    }

    private void aliasEPVs(Class cls, Collection parents, boolean remote) {
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String epv = IOR.getEPVName(id);
        int epvType = remote ? 2 : 0;
        int width = epv.length() + 1;
        int w = Utilities.getWidth(parents) + "struct __epv*".length();
        if (w > width) {
            width = w;
        }
        this.d_writer.printAligned(epv + "*", width);
        this.d_writer.println(" epv = &" + IOR.getStaticEPVVariable(id, epvType, 0) + ";");
        if (IOR.supportInterceptors(cls)) {
            this.d_writer.printAligned(epv + "*", width);
            this.d_writer.println(" iepv = &" + IOR.getStaticEPVVariable(id, epvType, 2) + ";");
        }
        int e = 0;
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            SymbolID sid = (SymbolID)i.next();
            String lower = IOR.getSymbolName(sid).toLowerCase();
            this.d_writer.printAligned(IOR.getEPVName(sid) + "*", width);
            this.d_writer.printAligned(" e" + String.valueOf(e++), 4);
            this.d_writer.println(" = &" + IOR.getStaticEPVVariable(sid, epvType, 0) + ";");
        }
        this.d_writer.println();
    }

    private void copyEPVs(Collection parents) throws CodeGenerationException {
        int e = 0;
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            Extendable ext = (Extendable)Utilities.lookupSymbol(id);
            String name = IOR.getSymbolName(id);
            List methods = (List)ext.getNonstaticMethods(true);
            int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length();
            String self = null;
            self = ext.isInterface() ? "void*" : IOR.getObjectName(id) + "*";
            String estring = "e" + String.valueOf(e) + "->";
            String vecEntry = IOR.getVectorEntry(s_castBuiltin);
            this.d_writer.print(estring);
            this.d_writer.printAligned(vecEntry, mwidth);
            this.d_writer.print(" = (void* (*)(" + self);
            this.d_writer.print(",const char*)) epv->");
            this.d_writer.print(vecEntry);
            this.d_writer.println(";");
            vecEntry = IOR.getVectorEntry(s_deleteBuiltin);
            this.d_writer.print(estring);
            this.d_writer.printAligned(vecEntry, mwidth);
            this.d_writer.println(" = (void (*)(" + self + ")) epv->" + vecEntry + ";");
            vecEntry = IOR.getVectorEntry(s_execBuiltin);
            Method m_exec = C.getExecMethod();
            String ename = m_exec.getLongMethodName();
            this.d_writer.print(estring);
            this.d_writer.printAligned(IOR.getVectorEntry(ename), mwidth);
            this.d_writer.print(" = " + IOR.getCast(m_exec, self));
            this.d_writer.println(" epv->" + IOR.getVectorEntry(ename) + ";");
            Iterator j = methods.iterator();
            while (j.hasNext()) {
                Method method = (Method)j.next();
                String mname = method.getLongMethodName();
                this.d_writer.print(estring);
                this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
                this.d_writer.print(" = " + IOR.getCast(method, self));
                this.d_writer.println(" epv->" + IOR.getVectorEntry(mname) + ";");
            }
            this.d_writer.println();
            ++e;
        }
    }

    private static String methodCall(Extendable ext, String var, String method, String args) {
        String result = "(*(" + var + "->" + IOR.getEPVVar(0) + "->" + IOR.getVectorEntry(method) + "))(" + var;
        if (ext.isInterface()) {
            result = result + "->d_object";
        }
        result = result + args;
        result = result + ");";
        return result;
    }

    private void generateReplaceValue(Symbol symbol) {
        this.d_writer.println("if (result) {");
        this.d_writer.tab();
        if (symbol instanceof Extendable) {
            this.d_writer.println("if (value) {");
            this.d_writer.tab();
            this.d_writer.println(RMIStubSource.methodCall((Extendable)symbol, "value", "addRef", ""));
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (*result) {");
            this.d_writer.tab();
            this.d_writer.println(RMIStubSource.methodCall((Extendable)symbol, "(*result)", "deleteRef", ""));
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.println("*result = value;");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    public static void generateExternalSignature(LanguageWriter lw, Symbol sym, String terminator) {
        SymbolID id = sym.getSymbolID();
        lw.beginBlockComment(false);
        lw.println("This function returns a pointer to a static structure of");
        lw.println("pointers to function entry points.  Its purpose is to provide");
        lw.println("one-stop shopping for loading DLLs.");
        lw.endBlockComment(false);
        lw.println("const " + IOR.getExternalName(id) + "*");
        lw.println(IOR.getExternalFunc(id) + "(void)" + terminator);
    }

    private void generateExternalFunc(Symbol sym) {
        SymbolID id = sym.getSymbolID();
        this.d_writer.println("static const " + IOR.getExternalName(id));
        this.d_writer.println("s_externalEntryPoints = {");
        this.d_writer.tab();
        if (sym instanceof Class) {
            Class cls = (Class)sym;
            if (!cls.isAbstract()) {
                this.d_writer.println(IOR.getNewName(id) + ",");
            }
            this.d_writer.println(IOR.getRemoteName(id) + ",");
            if (cls.hasStaticMethod(true)) {
                this.d_writer.println(IOR.getStaticsName(id) + ",");
            }
            if (cls.getParentClass() != null) {
                this.d_writer.println(IOR.getSymbolName(id) + "__super");
            }
        }
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
        RMIStubSource.generateExternalSignature(this.d_writer, sym, "");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("return &s_externalEntryPoints;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    static {
        s_deleteBuiltin = IOR.getBuiltinName(1);
        s_castBuiltin = IOR.getBuiltinName(0);
        s_execBuiltin = IOR.getBuiltinName(2);
        s_longestBuiltin = 0;
        for (int j = 0; j < 10; ++j) {
            String mname = IOR.getBuiltinName(j);
            if (mname.length() <= s_longestBuiltin) continue;
            s_longestBuiltin = mname.length();
        }
    }
}

