// 
// File:          objarg_EmployeeArray_Impl.cc
// Symbol:        objarg.EmployeeArray-v0.5
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for objarg.EmployeeArray
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "objarg_EmployeeArray_Impl.hh"

#line 14 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.cc"
// DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._includes)
#include <float.h>
// DO-NOT-DELETE splicer.end(objarg.EmployeeArray._includes)
#line 18 "objarg_EmployeeArray_Impl.cc"

// user-defined constructor.
void objarg::EmployeeArray_impl::_ctor() {
#line 20 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray._ctor)
#line 26 "objarg_EmployeeArray_Impl.cc"
}

// user-defined destructor.
void objarg::EmployeeArray_impl::_dtor() {
#line 27 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray._dtor)
#line 35 "objarg_EmployeeArray_Impl.cc"
}

// static class initializer.
void objarg::EmployeeArray_impl::_load() {
#line 34 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray._load)
#line 44 "objarg_EmployeeArray_Impl.cc"
}

// user-defined static methods: (none)

// user-defined non-static methods:
/**
 * Return the number of employees in the employee array.
 */
int32_t
objarg::EmployeeArray_impl::getLength ()
throw () 

{
#line 50 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray.getLength)
  return d_array.size();
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray.getLength)
#line 62 "objarg_EmployeeArray_Impl.cc"
}

/**
 * Return the employee in position <code>index</code> where
 * <code>index</code> ranges from 1 to the length of the array.
 * If <code>index</code> is outside the range of the array (i.e.
 * less than or equal to zero or greater than the current number
 * of elements in the array), this method returns a NULL
 * employee object.
 */
::objarg::Employee
objarg::EmployeeArray_impl::at (
  /* in */ int32_t index ) 
throw () 
{
#line 68 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray.at)
  if ( index >= 1 && index <= (int32_t) d_array.size() ) {
    return d_array[index-1];
  } else { 
    return 0;
  }
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray.at)
#line 86 "objarg_EmployeeArray_Impl.cc"
}

/**
 * Add an employee onto the end of the array.  It is perfectly
 * legal to add the same employee multiple times.
 * <code>true</code> is returned when the append was successful;
 * otherwise, <code>false</code> is returned to indicate
 * failure.  This method will not add a NULL employee.
 */
bool
objarg::EmployeeArray_impl::appendEmployee (
  /* in */ ::objarg::Employee e ) 
throw () 
{
#line 89 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray.appendEmployee)
  if (e._not_nil()) {
    d_array.push_back( e );
    return true;
  }
  return false;
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray.appendEmployee)
#line 109 "objarg_EmployeeArray_Impl.cc"
}

/**
 * Find the first employee in the array that has a name matching
 * <code>name</code>.  If a match exists, the index is returned,
 * and the employee is returned in parameter <code>e</code>.
 * 
 * If no match exists, 0 is returned, and <code>e</code> is NULL.
 */
int32_t
objarg::EmployeeArray_impl::findByName (
  /* in */ const ::std::string& name,
  /* out */ ::objarg::Employee& e ) 
throw () 
{
#line 111 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray.findByName)
  int i=1;
  for( d_array_t::iterator cur = d_array.begin(), end = d_array.end();
       cur != end; ++cur,++i ) { 
    if ( cur->getName() == name ) { 
      e = *cur;
      return i;
    }
  }
  e = 0;
  return 0;
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray.findByName)
#line 138 "objarg_EmployeeArray_Impl.cc"
}

/**
 * Determine the maximum salary in the array. If the maximum
 * salary in the array is greater than the current salary of
 * <code>e</code>, the salary of <code>e</code> will be 
 * increased to the maximum salary in the array.  If the
 * array is empty, no change will be made to <code>e</code>.
 * 
 * This method returns <code>true</code> iff the salary of
 * <code>e</code> is modified.
 */
bool
objarg::EmployeeArray_impl::promoteToMaxSalary (
  /* inout */ ::objarg::Employee& e ) 
throw () 
{
#line 140 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray.promoteToMaxSalary)
  if (d_array.size() && e._not_nil()) {
    float max_salary = -FLT_MAX;
    for( d_array_t::iterator cur = d_array.begin(), end = d_array.end();
	 cur != end; ++cur ) { 
      max_salary = std::max( cur->getSalary(), max_salary );
    }
    if ( e.getSalary() < max_salary ) { 
      e.setSalary( max_salary );
      return true;
    }
  }
  return false;
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray.promoteToMaxSalary)
#line 171 "objarg_EmployeeArray_Impl.cc"
}


#line 157 "../../../../babel/regression/objarg/libCxx/objarg_EmployeeArray_Impl.cc"
// DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(objarg.EmployeeArray._misc)
#line 179 "objarg_EmployeeArray_Impl.cc"

