/*
 * Copyright 1999-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: FlateEncodeOutputStream.java 197384 2004-02-27 18:01:30Z jeremias $ */

package org.apache.fop.util;

import java.io.OutputStream;
import java.io.IOException;

/**
 * This class applies a FlateEncode filter to the stream. It is basically the
 * normal DeflaterOutputStream except now also implementing the Finalizable
 * interface.
 *
 * @author <a href="mailto:jeremias@apache.org">Jeremias Maerki</a>
 * @version $Id: FlateEncodeOutputStream.java 197384 2004-02-27 18:01:30Z jeremias $
 */
public class FlateEncodeOutputStream extends java.util.zip.DeflaterOutputStream
            implements Finalizable {


    /** @see java.util.zip.DeflaterOutputStream **/
    public FlateEncodeOutputStream(OutputStream out) {
        super(out);
    }


    /** @see Finalizable **/
    public void finalizeStream() throws IOException {
        finish();
        flush();
        if (out instanceof Finalizable) {
            ((Finalizable)out).finalizeStream();
        }
    }

}


