/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.LinkedRectangle;

public class LinkSet {
    String externalDestination;
    Vector rects = new Vector();
    private int xoffset = 0;
    private int yoffset = 0;
    protected int startIndent;
    protected int endIndent;
    private Area area;
    int contentRectangleWidth = 0;

    public LinkSet(String string, Area area) {
        this.externalDestination = string;
        this.area = area;
    }

    public void addRect(Rectangle rectangle, LineArea lineArea) {
        LinkedRectangle linkedRectangle = new LinkedRectangle(rectangle, lineArea);
        linkedRectangle.setY(this.yoffset);
        this.rects.addElement(linkedRectangle);
    }

    public void align() {
        Enumeration enumeration = this.rects.elements();
        while (enumeration.hasMoreElements()) {
            LinkedRectangle linkedRectangle = (LinkedRectangle)enumeration.nextElement();
            linkedRectangle.setX(linkedRectangle.getX() + linkedRectangle.getLineArea().getStartIndent());
        }
    }

    public void applyAreaContainerOffsets(AreaContainer areaContainer) {
        Enumeration enumeration = this.rects.elements();
        while (enumeration.hasMoreElements()) {
            LinkedRectangle linkedRectangle = (LinkedRectangle)enumeration.nextElement();
            linkedRectangle.setX(linkedRectangle.getX() + areaContainer.getXPosition());
            linkedRectangle.setY(areaContainer.getYPosition() - areaContainer.getHeight() - linkedRectangle.getY());
        }
    }

    public Area getArea() {
        return this.area;
    }

    public String getDest() {
        return this.externalDestination;
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    public Vector getRects() {
        return this.rects;
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    public void mergeLinks() {
        int n = this.rects.size();
        if (n == 1) {
            return;
        }
        LinkedRectangle linkedRectangle = new LinkedRectangle((LinkedRectangle)this.rects.elementAt(0));
        Vector<LinkedRectangle> vector = new Vector<LinkedRectangle>();
        int n2 = 1;
        while (n2 < n) {
            LinkedRectangle linkedRectangle2 = (LinkedRectangle)this.rects.elementAt(n2);
            if (linkedRectangle2.getLineArea() == linkedRectangle.getLineArea()) {
                linkedRectangle.setWidth(linkedRectangle2.getX() + linkedRectangle2.getWidth() - linkedRectangle.getX());
            } else {
                vector.addElement(linkedRectangle);
                linkedRectangle = new LinkedRectangle(linkedRectangle2);
            }
            if (n2 == n - 1) {
                vector.addElement(linkedRectangle);
            }
            ++n2;
        }
        this.rects = vector;
    }

    public void setContentRectangleWidth(int n) {
        this.contentRectangleWidth = n;
    }

    public void setXOffset(int n) {
        this.xoffset = n;
    }

    public void setYOffset(int n) {
        this.yoffset = n;
    }
}

