/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.parser;

import java.io.IOException;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.parser.AbstractParser;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.framework.Version;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XercesParser
extends AbstractParser
implements Status {
    public Document createEmptyDocument() {
        return new DocumentImpl();
    }

    public String getStatus() {
        return String.valueOf(Version.fVersion) + " XML Parser (validation = " + this.validation + ")";
    }

    public Document parse(InputSource input, boolean validate) throws SAXException, IOException {
        DOMParser parser = new DOMParser();
        parser.setErrorHandler((ErrorHandler)this);
        parser.setFeature("http://xml.org/sax/features/validation", validate);
        parser.setFeature("http://xml.org/sax/features/namespaces", true);
        parser.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", validate);
        parser.setFeature("http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", validate);
        parser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", false);
        parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", true);
        parser.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        parser.parse(this.resolveSystemId(input));
        return parser.getDocument();
    }

    private InputSource resolveSystemId(InputSource input) {
        String id = input.getSystemId();
        if (id != null) {
            if ((id = id.replace('\\', '/')).indexOf("://") < 0 && !id.startsWith("file:")) {
                id = "file:" + id;
            }
            input.setSystemId(id);
        }
        return input;
    }
}

