/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.MutableObject;
import org.w3c.tidy.Node;
import org.w3c.tidy.PPrint;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.Style;
import org.w3c.tidy.StyleProp;
import org.w3c.tidy.TagTable;

public class Clean {
    private int classNum = 1;

    private static void addAlign(Node node, String string) {
        Clean.addStyleProperty(node, "text-align: " + string.toLowerCase());
    }

    private static void addColorRule(Lexer lexer, String string, String string2) {
        if (string2 != null) {
            lexer.addStringLiteral(string);
            lexer.addStringLiteral(" { color: ");
            lexer.addStringLiteral(string2);
            lexer.addStringLiteral(" }\n");
        }
    }

    private static void addFontColor(Node node, String string) {
        Clean.addStyleProperty(node, "color: " + string);
    }

    private static void addFontFace(Node node, String string) {
        Clean.addStyleProperty(node, "font-family: " + string);
    }

    private static void addFontSize(Node node, String string) {
        if (string.equals("6") && node.tag == TagTable.tagP) {
            node.element = new String("h1");
            TagTable.getDefaultTagTable().findTag(node);
            return;
        }
        if (string.equals("5") && node.tag == TagTable.tagP) {
            node.element = new String("h2");
            TagTable.getDefaultTagTable().findTag(node);
            return;
        }
        if (string.equals("4") && node.tag == TagTable.tagP) {
            node.element = new String("h3");
            TagTable.getDefaultTagTable().findTag(node);
            return;
        }
        String string2 = Clean.fontSize2Name(string);
        if (string2 != null) {
            Clean.addStyleProperty(node, "font-size: " + string2);
        }
    }

    private static void addFontStyles(Node node, AttVal attVal) {
        while (attVal != null) {
            if (attVal.attribute.equals("face")) {
                Clean.addFontFace(node, attVal.value);
            } else if (attVal.attribute.equals("size")) {
                Clean.addFontSize(node, attVal.value);
            } else if (attVal.attribute.equals("color")) {
                Clean.addFontColor(node, attVal.value);
            }
            attVal = attVal.next;
        }
    }

    private static String addProperty(String string, String string2) {
        StyleProp styleProp = Clean.createProps(null, string);
        styleProp = Clean.createProps(styleProp, string2);
        string = Clean.createPropString(styleProp);
        return string;
    }

    private static void addStyleProperty(Node node, String string) {
        AttVal attVal = node.attributes;
        while (attVal != null) {
            if (attVal.attribute.equals("style")) break;
            attVal = attVal.next;
        }
        if (attVal != null) {
            String string2;
            attVal.value = string2 = Clean.addProperty(attVal.value, string);
        } else {
            attVal = new AttVal(node.attributes, null, 34, new String("style"), new String(string));
            attVal.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal);
            node.attributes = attVal;
        }
    }

    public static void bQ2Div(Node node) {
        while (node != null) {
            if (node.tag == TagTable.tagBlockquote && node.implicit) {
                int n = 1;
                while (node.hasOneChild() && node.content.tag == TagTable.tagBlockquote && node.implicit) {
                    ++n;
                    Clean.stripOnlyChild(node);
                }
                if (node.content != null) {
                    Clean.bQ2Div(node.content);
                }
                String string = "margin-left: " + new Integer(2 * n).toString() + "em";
                node.element = new String(TagTable.tagDiv.name);
                node.tag = TagTable.tagDiv;
                node.addAttribute("style", string);
            } else if (node.content != null) {
                Clean.bQ2Div(node.content);
            }
            node = node.next;
        }
    }

    private static boolean blockStyle(Lexer lexer, Node node, MutableObject mutableObject) {
        if ((node.tag.model & 0xE8) != 0 && node.tag != TagTable.tagTable && node.tag != TagTable.tagTr && node.tag != TagTable.tagLi) {
            Node node2;
            if (node.tag != TagTable.tagCaption) {
                Clean.textAlign(lexer, node);
            }
            if ((node2 = node.content) == null) {
                return false;
            }
            if (node2.next != null) {
                return false;
            }
            if (node2.tag == TagTable.tagB) {
                Clean.mergeStyles(node, node2);
                Clean.addStyleProperty(node, "font-weight: bold");
                Clean.stripOnlyChild(node);
                return true;
            }
            if (node2.tag == TagTable.tagI) {
                Clean.mergeStyles(node, node2);
                Clean.addStyleProperty(node, "font-style: italic");
                Clean.stripOnlyChild(node);
                return true;
            }
            if (node2.tag == TagTable.tagFont) {
                Clean.mergeStyles(node, node2);
                Clean.addFontStyles(node, node2.attributes);
                Clean.stripOnlyChild(node);
                return true;
            }
        }
        return false;
    }

    private static boolean center2Div(Lexer lexer, Node node, MutableObject mutableObject) {
        if (node.tag == TagTable.tagCenter) {
            if (lexer.configuration.DropFontTags) {
                if (node.content != null) {
                    Node node2 = node.last;
                    Node node3 = node.parent;
                    Clean.discardContainer(node, mutableObject);
                    node = lexer.inferredTag("br");
                    if (node2.next != null) {
                        node2.next.prev = node;
                    }
                    node.next = node2.next;
                    node2.next = node;
                    node.prev = node2;
                    if (node3.last == node2) {
                        node3.last = node;
                    }
                    node.parent = node3;
                } else {
                    Node node4 = node.prev;
                    Node node5 = node.next;
                    Node node6 = node.parent;
                    Clean.discardContainer(node, mutableObject);
                    node = lexer.inferredTag("br");
                    node.next = node5;
                    node.prev = node4;
                    node.parent = node6;
                    if (node5 != null) {
                        node5.prev = node;
                    } else {
                        node6.last = node;
                    }
                    if (node4 != null) {
                        node4.next = node;
                    } else {
                        node6.content = node;
                    }
                }
                return true;
            }
            node.tag = TagTable.tagDiv;
            node.element = new String("div");
            Clean.addStyleProperty(node, "text-align: center");
            return true;
        }
        return false;
    }

    private static void cleanBodyAttrs(Lexer lexer, Node node) {
        String string = null;
        String string2 = null;
        String string3 = null;
        AttVal attVal = node.getAttrByName("background");
        if (attVal != null) {
            string = attVal.value;
            attVal.value = null;
            node.removeAttribute(attVal);
        }
        if ((attVal = node.getAttrByName("bgcolor")) != null) {
            string2 = attVal.value;
            attVal.value = null;
            node.removeAttribute(attVal);
        }
        if ((attVal = node.getAttrByName("text")) != null) {
            string3 = attVal.value;
            attVal.value = null;
            node.removeAttribute(attVal);
        }
        if (string != null || string2 != null || string3 != null) {
            lexer.addStringLiteral(" body {\n");
            if (string != null) {
                lexer.addStringLiteral("  background-image: url(");
                lexer.addStringLiteral(string);
                lexer.addStringLiteral(");\n");
            }
            if (string2 != null) {
                lexer.addStringLiteral("  background-color: ");
                lexer.addStringLiteral(string2);
                lexer.addStringLiteral(";\n");
            }
            if (string3 != null) {
                lexer.addStringLiteral("  color: ");
                lexer.addStringLiteral(string3);
                lexer.addStringLiteral(";\n");
            }
            lexer.addStringLiteral(" }\n");
        }
        if ((attVal = node.getAttrByName("link")) != null) {
            Clean.addColorRule(lexer, " :link", attVal.value);
            node.removeAttribute(attVal);
        }
        if ((attVal = node.getAttrByName("vlink")) != null) {
            Clean.addColorRule(lexer, " :visited", attVal.value);
            node.removeAttribute(attVal);
        }
        if ((attVal = node.getAttrByName("alink")) != null) {
            Clean.addColorRule(lexer, " :active", attVal.value);
            node.removeAttribute(attVal);
        }
    }

    private static Node cleanNode(Lexer lexer, Node node) {
        Node node2 = null;
        MutableObject mutableObject = new MutableObject();
        boolean bl = false;
        node2 = node;
        while (node.isElement()) {
            mutableObject.setObject(node2);
            bl = Clean.dir2Div(lexer, node, mutableObject);
            node2 = (Node)mutableObject.getObject();
            if (!bl) {
                bl = Clean.nestedList(lexer, node, mutableObject);
                node2 = (Node)mutableObject.getObject();
                if (!bl) {
                    bl = Clean.center2Div(lexer, node, mutableObject);
                    node2 = (Node)mutableObject.getObject();
                    if (!bl) {
                        bl = Clean.mergeDivs(lexer, node, mutableObject);
                        node2 = (Node)mutableObject.getObject();
                        if (!bl) {
                            bl = Clean.blockStyle(lexer, node, mutableObject);
                            node2 = (Node)mutableObject.getObject();
                            if (!bl) {
                                bl = Clean.inlineStyle(lexer, node, mutableObject);
                                node2 = (Node)mutableObject.getObject();
                                if (!bl) {
                                    bl = Clean.font2Span(lexer, node, mutableObject);
                                    node2 = (Node)mutableObject.getObject();
                                    if (!bl) break;
                                }
                            }
                        }
                    }
                }
            }
            node = node2;
        }
        return node2;
    }

    public void cleanTree(Lexer lexer, Node node) {
        node = Clean.createStyleProperties(lexer, node);
        if (!lexer.configuration.MakeClean) {
            this.defineStyleRules(lexer, node);
            Clean.createStyleElement(lexer, node);
        }
    }

    public static void cleanWord2000(Lexer lexer, Node node) {
        Node node2 = null;
        while (node != null) {
            AttVal attVal;
            if (node.tag == TagTable.tagStyle || node.tag == TagTable.tagMeta || node.type == 2) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.tag == TagTable.tagSpan) {
                node = Clean.stripSpan(lexer, node);
                continue;
            }
            if (node.tag == TagTable.tagHtml && node.getAttrByName("xmlns:o") == null) {
                return;
            }
            if (node.tag == TagTable.tagLink && (attVal = node.getAttrByName("rel")) != null && attVal.value != null && attVal.value.equals("File-List")) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.content == null && node.tag == TagTable.tagP) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.tag == TagTable.tagP) {
                attVal = node.getAttrByName("class");
                if (attVal != null && attVal.value != null && attVal.value.equals("MsoListBullet")) {
                    Node.coerceNode(lexer, node, TagTable.tagLi);
                    if (node2 == null || node2.tag != TagTable.tagUl) {
                        node2 = lexer.inferredTag("ul");
                        Node.insertNodeBeforeElement(node, node2);
                    }
                    Clean.purgeAttributes(node);
                    if (node.content != null) {
                        Clean.cleanWord2000(lexer, node.content);
                    }
                    Node.removeNode(node);
                    Node.insertNodeAtEnd(node2, node);
                    node = node2.next;
                } else if (attVal != null && attVal.value != null && attVal.value.equals("Code")) {
                    Node node3 = lexer.newLineNode();
                    Clean.normalizeSpaces(lexer, node);
                    if (node2 == null || node2.tag != TagTable.tagPre) {
                        node2 = lexer.inferredTag("pre");
                        Node.insertNodeBeforeElement(node, node2);
                    }
                    Node.removeNode(node);
                    Node.insertNodeAtEnd(node2, node);
                    Clean.stripSpan(lexer, node);
                    Node.insertNodeAtEnd(node2, node3);
                    node = node2.next;
                } else {
                    node2 = null;
                }
            } else {
                node2 = null;
            }
            if (node.type == 5 || node.type == 7) {
                Clean.purgeAttributes(node);
            }
            if (node.content != null) {
                Clean.cleanWord2000(lexer, node.content);
            }
            node = node.next;
        }
    }

    private static String createPropString(StyleProp styleProp) {
        String string = "";
        int n = 0;
        StyleProp styleProp2 = styleProp;
        while (styleProp2 != null) {
            n += styleProp2.name.length() + 2;
            n += styleProp2.value.length() + 2;
            styleProp2 = styleProp2.next;
        }
        styleProp2 = styleProp;
        while (styleProp2 != null) {
            string = string.concat(styleProp2.name);
            string = string.concat(": ");
            string = string.concat(styleProp2.value);
            if (styleProp2.next == null) break;
            string = string.concat("; ");
            styleProp2 = styleProp2.next;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private static StyleProp createProps(StyleProp var0, String var1_1) {
        var4_2 = 0;
        var5_3 = 0;
        var5_3 = 0;
        ** GOTO lbl30
        {
            ++var5_3;
            do {
                if (var5_3 < var1_1.length() && var1_1.charAt(var5_3) == ' ') continue block0;
                var2_4 = var5_3;
                while (var2_4 < var1_1.length()) {
                    if (var1_1.charAt(var2_4) == ':') {
                        var4_2 = var2_4 + 1;
                        break;
                    }
                    ++var2_4;
                }
                if (var2_4 < var1_1.length() && var1_1.charAt(var2_4) == ':') ** GOTO lbl18
                break block0;
lbl-1000:
                // 1 sources

                {
                    ++var4_2;
lbl18:
                    // 2 sources

                    ** while (var4_2 < var1_1.length() && var1_1.charAt((int)var4_2) == ' ')
                }
lbl19:
                // 1 sources

                var3_5 = var4_2;
                var6_6 = false;
                while (var3_5 < var1_1.length()) {
                    if (var1_1.charAt(var3_5) == ';') {
                        var6_6 = true;
                        break;
                    }
                    ++var3_5;
                }
                var0 = Clean.insertProperty(var0, var1_1.substring(var5_3, var2_4), var1_1.substring(var4_2, var3_5));
                if (!var6_6) break block0;
                var5_3 = var3_5 + 1;
lbl30:
                // 2 sources

            } while (var5_3 < var1_1.length());
        }
        return var0;
    }

    private static void createStyleElement(Lexer lexer, Node node) {
        if (lexer.styles == null && Clean.niceBody(lexer, node)) {
            return;
        }
        Node node2 = lexer.newNode((short)5, null, 0, 0, new String("style"));
        node2.implicit = true;
        AttVal attVal = new AttVal(null, null, 34, new String("type"), new String("text/css"));
        attVal.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal);
        node2.attributes = attVal;
        Node node3 = Node.findBody(node);
        lexer.txtstart = lexer.lexsize;
        if (node3 != null) {
            Clean.cleanBodyAttrs(lexer, node3);
        }
        Style style = lexer.styles;
        while (style != null) {
            lexer.addCharToLexer(32);
            lexer.addStringLiteral(style.tag);
            lexer.addCharToLexer(46);
            lexer.addStringLiteral(style.tagClass);
            lexer.addCharToLexer(32);
            lexer.addCharToLexer(123);
            lexer.addStringLiteral(style.properties);
            lexer.addCharToLexer(125);
            lexer.addCharToLexer(10);
            style = style.next;
        }
        lexer.txtend = lexer.lexsize;
        Node.insertNodeAtEnd(node2, lexer.newNode((short)4, lexer.lexbuf, lexer.txtstart, lexer.txtend));
        Node node4 = Node.findHead(node);
        if (node4 != null) {
            Node.insertNodeAtEnd(node4, node2);
        }
    }

    private static Node createStyleProperties(Lexer lexer, Node node) {
        if (node.content != null) {
            Node node2 = node.content;
            while (node2 != null) {
                node2 = Clean.createStyleProperties(lexer, node2);
                node2 = node2.next;
            }
        }
        return Clean.cleanNode(lexer, node);
    }

    private void defineStyleRules(Lexer lexer, Node node) {
        if (node.content != null) {
            Node node2 = node.content;
            while (node2 != null) {
                this.defineStyleRules(lexer, node2);
                node2 = node2.next;
            }
        }
        this.style2Rule(lexer, node);
    }

    private static boolean dir2Div(Lexer lexer, Node node, MutableObject mutableObject) {
        if (node.tag == TagTable.tagDir || node.tag == TagTable.tagUl || node.tag == TagTable.tagOl) {
            Node node2 = node.content;
            if (node2 == null) {
                return false;
            }
            if (node2.next != null) {
                return false;
            }
            if (node2.tag != TagTable.tagLi) {
                return false;
            }
            if (!node2.implicit) {
                return false;
            }
            node.tag = TagTable.tagDiv;
            node.element = new String("div");
            Clean.addStyleProperty(node, "margin-left: 2em");
            Clean.stripOnlyChild(node);
            return true;
        }
        return false;
    }

    private static void discardContainer(Node node, MutableObject mutableObject) {
        Node node2 = node.parent;
        if (node.content != null) {
            node.last.next = node.next;
            if (node.next != null) {
                node.next.prev = node.last;
                node.last.next = node.next;
            } else {
                node2.last = node.last;
            }
            if (node.prev != null) {
                node.content.prev = node.prev;
                node.prev.next = node.content;
            } else {
                node2.content = node.content;
            }
            Node node3 = node.content;
            while (node3 != null) {
                node3.parent = node2;
                node3 = node3.next;
            }
            mutableObject.setObject(node.content);
        } else {
            if (node.next != null) {
                node.next.prev = node.prev;
            } else {
                node2.last = node.prev;
            }
            if (node.prev != null) {
                node.prev.next = node.next;
            } else {
                node2.content = node.next;
            }
            mutableObject.setObject(node.next);
        }
        node.next = null;
        node.content = null;
    }

    public static void dropSections(Lexer lexer, Node node) {
        while (node != null) {
            if (node.type == 9) {
                if (Lexer.getString(node.textarray, node.start, 2).equals("if")) {
                    node = Clean.pruneSection(lexer, node);
                    continue;
                }
                node = Node.discardElement(node);
                continue;
            }
            if (node.content != null) {
                Clean.dropSections(lexer, node.content);
            }
            node = node.next;
        }
    }

    public static void emFromI(Node node) {
        while (node != null) {
            if (node.tag == TagTable.tagI) {
                node.element = new String(TagTable.tagEm.name);
                node.tag = TagTable.tagEm;
            } else if (node.tag == TagTable.tagB) {
                node.element = new String(TagTable.tagStrong.name);
                node.tag = TagTable.tagStrong;
            }
            if (node.content != null) {
                Clean.emFromI(node.content);
            }
            node = node.next;
        }
    }

    private String findStyle(Lexer lexer, String string, String string2) {
        Style style = lexer.styles;
        while (style != null) {
            if (style.tag.equals(string) && style.properties.equals(string2)) {
                return style.tagClass;
            }
            style = style.next;
        }
        lexer.styles = style = new Style(new String(string), this.gensymClass(string), new String(string2), lexer.styles);
        return style.tagClass;
    }

    private static void fixNodeLinks(Node node) {
        if (node.prev != null) {
            node.prev.next = node;
        } else {
            node.parent.content = node;
        }
        if (node.next != null) {
            node.next.prev = node;
        } else {
            node.parent.last = node;
        }
        Node node2 = node.content;
        while (node2 != null) {
            node2.parent = node;
            node2 = node2.next;
        }
    }

    private static boolean font2Span(Lexer lexer, Node node, MutableObject mutableObject) {
        if (node.tag == TagTable.tagFont) {
            if (lexer.configuration.DropFontTags) {
                Clean.discardContainer(node, mutableObject);
                return false;
            }
            if (node.parent.content == node && node.next == null) {
                return false;
            }
            Clean.addFontStyles(node, node.attributes);
            AttVal attVal = node.attributes;
            AttVal attVal2 = null;
            while (attVal != null) {
                AttVal attVal3 = attVal.next;
                if (attVal.attribute.equals("style")) {
                    attVal.next = null;
                    attVal2 = attVal;
                }
                attVal = attVal3;
            }
            node.attributes = attVal2;
            node.tag = TagTable.tagSpan;
            node.element = new String("span");
            return true;
        }
        return false;
    }

    private static String fontSize2Name(String string) {
        String[] stringArray = new String[]{"60%", "70%", "80%", null, "120%", "150%", "200%"};
        if (string.length() > 0 && string.charAt(0) >= '0' && string.charAt(0) <= '6') {
            int n = string.charAt(0) - 48;
            return stringArray[n];
        }
        if (string.length() > 0 && string.charAt(0) == '-') {
            if (string.length() > 1 && string.charAt(1) >= '0' && string.charAt(1) <= '6') {
                int n = string.charAt(1) - 48;
                double d = 1.0;
                while (n > 0) {
                    d *= 0.8;
                    --n;
                }
                String string2 = (int)(d *= 100.0) + "%";
                return string2;
            }
            return "smaller";
        }
        if (string.length() > 1 && string.charAt(1) >= '0' && string.charAt(1) <= '6') {
            int n = string.charAt(1) - 48;
            double d = 1.0;
            while (n > 0) {
                d *= 1.2;
                --n;
            }
            String string3 = (int)(d *= 100.0) + "%";
            return string3;
        }
        return "larger";
    }

    private String gensymClass(String string) {
        String string2 = "c" + this.classNum;
        ++this.classNum;
        return string2;
    }

    private static boolean inlineStyle(Lexer lexer, Node node, MutableObject mutableObject) {
        if (node.tag != TagTable.tagFont && (node.tag.model & 0x210) != 0) {
            Node node2 = node.content;
            if (node2 == null) {
                return false;
            }
            if (node2.next != null) {
                return false;
            }
            if (node2.tag == TagTable.tagB && lexer.configuration.LogicalEmphasis) {
                Clean.mergeStyles(node, node2);
                Clean.addStyleProperty(node, "font-weight: bold");
                Clean.stripOnlyChild(node);
                return true;
            }
            if (node2.tag == TagTable.tagI && lexer.configuration.LogicalEmphasis) {
                Clean.mergeStyles(node, node2);
                Clean.addStyleProperty(node, "font-style: italic");
                Clean.stripOnlyChild(node);
                return true;
            }
            if (node2.tag == TagTable.tagFont) {
                Clean.mergeStyles(node, node2);
                Clean.addFontStyles(node, node2.attributes);
                Clean.stripOnlyChild(node);
                return true;
            }
        }
        return false;
    }

    private static StyleProp insertProperty(StyleProp styleProp, String string, String string2) {
        StyleProp styleProp2 = null;
        StyleProp styleProp3 = styleProp;
        while (styleProp != null) {
            int n = styleProp.name.compareTo(string);
            if (n == 0) {
                return styleProp3;
            }
            if (n > 0) {
                StyleProp styleProp4 = new StyleProp(new String(string), new String(string2), styleProp);
                if (styleProp2 != null) {
                    styleProp2.next = styleProp4;
                } else {
                    styleProp3 = styleProp4;
                }
                return styleProp3;
            }
            styleProp2 = styleProp;
            styleProp = styleProp.next;
        }
        StyleProp styleProp5 = new StyleProp(new String(string), new String(string2));
        if (styleProp2 != null) {
            styleProp2.next = styleProp5;
        } else {
            styleProp3 = styleProp5;
        }
        return styleProp3;
    }

    public static boolean isWord2000(Node node) {
        Node node2 = node.findHTML();
        return node2 != null && node2.getAttrByName("xmlns:o") != null;
    }

    public static void list2BQ(Node node) {
        while (node != null) {
            if (node.content != null) {
                Clean.list2BQ(node.content);
            }
            if (node.tag != null && node.tag.parser == ParserImpl.getParseList() && node.hasOneChild() && node.content.implicit) {
                Clean.stripOnlyChild(node);
                node.element = new String(TagTable.tagBlockquote.name);
                node.tag = TagTable.tagBlockquote;
                node.implicit = true;
            }
            node = node.next;
        }
    }

    private static boolean mergeDivs(Lexer lexer, Node node, MutableObject mutableObject) {
        if (node.tag != TagTable.tagDiv) {
            return false;
        }
        Node node2 = node.content;
        if (node2 == null) {
            return false;
        }
        if (node2.tag != TagTable.tagDiv) {
            return false;
        }
        if (node2.next != null) {
            return false;
        }
        Clean.mergeStyles(node, node2);
        Clean.stripOnlyChild(node);
        return true;
    }

    private static String mergeProperties(String string, String string2) {
        StyleProp styleProp = Clean.createProps(null, string);
        styleProp = Clean.createProps(styleProp, string2);
        String string3 = Clean.createPropString(styleProp);
        return string3;
    }

    private static void mergeStyles(Node node, Node node2) {
        String string = null;
        AttVal attVal = node2.attributes;
        while (attVal != null) {
            if (attVal.attribute.equals("style")) {
                string = attVal.value;
                break;
            }
            attVal = attVal.next;
        }
        String string2 = null;
        attVal = node.attributes;
        while (attVal != null) {
            if (attVal.attribute.equals("style")) {
                string2 = attVal.value;
                break;
            }
            attVal = attVal.next;
        }
        if (string2 != null) {
            if (string != null) {
                String string3;
                attVal.value = string3 = Clean.mergeProperties(string2, string);
            }
        } else if (string != null) {
            attVal = new AttVal(node.attributes, null, 34, new String("style"), new String(string));
            attVal.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal);
            node.attributes = attVal;
        }
    }

    public static void nestedEmphasis(Node node) {
        MutableObject mutableObject = new MutableObject();
        while (node != null) {
            Node node2 = node.next;
            if ((node.tag == TagTable.tagB || node.tag == TagTable.tagI) && node.parent != null && node.parent.tag == node.tag) {
                mutableObject.setObject(node2);
                Clean.discardContainer(node, mutableObject);
                node = node2 = (Node)mutableObject.getObject();
                continue;
            }
            if (node.content != null) {
                Clean.nestedEmphasis(node.content);
            }
            node = node2;
        }
    }

    private static boolean nestedList(Lexer lexer, Node node, MutableObject mutableObject) {
        if (node.tag == TagTable.tagUl || node.tag == TagTable.tagOl) {
            Node node2 = node.content;
            if (node2 == null) {
                return false;
            }
            if (node2.next != null) {
                return false;
            }
            Node node3 = node2.content;
            if (node3 == null) {
                return false;
            }
            if (node3.tag != node.tag) {
                return false;
            }
            mutableObject.setObject(node.next);
            node3.prev = node.prev;
            node3.next = node.next;
            node3.parent = node.parent;
            Clean.fixNodeLinks(node3);
            node2.content = null;
            node.content = null;
            node.next = null;
            if (node3.prev != null) {
                node = node3;
                node3 = node.prev;
                if (node3.tag == TagTable.tagUl || node3.tag == TagTable.tagOl) {
                    node3.next = node.next;
                    if (node3.next != null) {
                        node3.next.prev = node3;
                    }
                    node.parent = node2 = node3.last;
                    node.next = null;
                    node.prev = node2.last;
                    Clean.fixNodeLinks(node);
                }
            }
            Clean.cleanNode(lexer, node);
            return true;
        }
        return false;
    }

    private static boolean niceBody(Lexer lexer, Node node) {
        Node node2 = Node.findBody(node);
        if (node2 != null && (node2.getAttrByName("background") != null || node2.getAttrByName("bgcolor") != null || node2.getAttrByName("text") != null || node2.getAttrByName("link") != null || node2.getAttrByName("vlink") != null || node2.getAttrByName("alink") != null)) {
            lexer.badLayout = (short)(lexer.badLayout | 0x10);
            return false;
        }
        return true;
    }

    private static void normalizeSpaces(Lexer lexer, Node node) {
        while (node != null) {
            if (node.content != null) {
                Clean.normalizeSpaces(lexer, node.content);
            }
            if (node.type == 4) {
                MutableInteger mutableInteger = new MutableInteger();
                int n = node.start;
                int n2 = node.start;
                while (n2 < node.end) {
                    mutableInteger.value = node.textarray[n2];
                    if (mutableInteger.value > 127) {
                        n2 += PPrint.getUTF8(node.textarray, n2, mutableInteger);
                    }
                    if (mutableInteger.value == 160) {
                        mutableInteger.value = 32;
                    }
                    n = PPrint.putUTF8(node.textarray, n, mutableInteger.value);
                    ++n2;
                }
            }
            node = node.next;
        }
    }

    public static Node pruneSection(Lexer lexer, Node node) {
        while (true) {
            if ((node = Node.discardElement(node)) == null) {
                return null;
            }
            if (node.type != 9) continue;
            if (Lexer.getString(node.textarray, node.start, 2).equals("if")) {
                node = Clean.pruneSection(lexer, node);
                continue;
            }
            if (Lexer.getString(node.textarray, node.start, 5).equals("endif")) break;
        }
        node = Node.discardElement(node);
        return node;
    }

    public static void purgeAttributes(Node node) {
        AttVal attVal = node.attributes;
        AttVal attVal2 = null;
        AttVal attVal3 = null;
        while (attVal != null) {
            attVal2 = attVal.next;
            if (attVal.attribute != null && attVal.value != null && attVal.attribute.equals("class") && attVal.value.equals("Code")) {
                attVal3 = attVal;
            } else if (attVal.attribute != null && (attVal.attribute.equals("class") || attVal.attribute.equals("style") || attVal.attribute.equals("lang") || attVal.attribute.startsWith("x:") || (attVal.attribute.equals("height") || attVal.attribute.equals("width")) && (node.tag == TagTable.tagTd || node.tag == TagTable.tagTr || node.tag == TagTable.tagTh))) {
                if (attVal3 != null) {
                    attVal3.next = attVal2;
                } else {
                    node.attributes = attVal2;
                }
            } else {
                attVal3 = attVal;
            }
            attVal = attVal2;
        }
    }

    private static void stripOnlyChild(Node node) {
        Node node2 = node.content;
        node.content = node2.content;
        node.last = node2.last;
        node2.content = null;
        node2 = node.content;
        while (node2 != null) {
            node2.parent = node;
            node2 = node2.next;
        }
    }

    public static Node stripSpan(Lexer lexer, Node node) {
        Node node2;
        Node node3 = null;
        Clean.cleanWord2000(lexer, node.content);
        Node node4 = node.content;
        if (node.prev != null) {
            node3 = node.prev;
        } else if (node4 != null) {
            node2 = node4;
            node4 = node4.next;
            Node.removeNode(node2);
            Node.insertNodeBeforeElement(node, node2);
            node3 = node2;
        }
        while (node4 != null) {
            node2 = node4;
            node4 = node4.next;
            Node.removeNode(node2);
            Node.insertNodeAfterElement(node3, node2);
            node3 = node2;
        }
        if (node.next == null) {
            node.parent.last = node3;
        }
        node2 = node.next;
        node.content = null;
        Node.discardElement(node);
        return node2;
    }

    private void style2Rule(Lexer lexer, Node node) {
        AttVal attVal = node.getAttrByName("style");
        if (attVal != null) {
            String string = this.findStyle(lexer, node.element, attVal.value);
            AttVal attVal2 = node.getAttrByName("class");
            if (attVal2 != null) {
                attVal2.value = String.valueOf(attVal2.value) + " " + string;
                node.removeAttribute(attVal);
            } else {
                attVal.attribute = "class";
                attVal.value = string;
            }
        }
    }

    private static void textAlign(Lexer lexer, Node node) {
        AttVal attVal = null;
        AttVal attVal2 = node.attributes;
        while (attVal2 != null) {
            if (attVal2.attribute.equals("align")) {
                if (attVal != null) {
                    attVal.next = attVal2.next;
                } else {
                    node.attributes = attVal2.next;
                }
                if (attVal2.value == null) break;
                Clean.addAlign(node, attVal2.value);
                break;
            }
            attVal = attVal2;
            attVal2 = attVal2.next;
        }
    }
}

