/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Keep;
import org.apache.fop.fo.EnumProperty;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.KeepProperty;
import org.apache.fop.fo.NumberProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;

public class GenericKeep
extends KeepProperty.Maker {
    private static final Property.Maker s_WithinPageMaker = new SP_WithinPageMaker("generic-keep.within-page");
    private static final Property.Maker s_WithinLineMaker = new SP_WithinLineMaker("generic-keep.within-line");
    private static final Property.Maker s_WithinColumnMaker = new SP_WithinColumnMaker("generic-keep.within-column");
    Property.Maker m_shorthandMaker = this.getSubpropMaker("within-page");
    private Property m_defaultProp = null;

    protected GenericKeep(String string) {
        super(string);
    }

    public Property checkEnumValues(String string) {
        return this.m_shorthandMaker.checkEnumValues(string);
    }

    public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws FOPException {
        if (property instanceof KeepProperty) {
            return property;
        }
        if (!(property instanceof EnumProperty)) {
            property = this.m_shorthandMaker.convertProperty(property, propertyList, fObj);
        }
        if (property != null) {
            Property property2 = this.makeCompound(propertyList, fObj);
            Keep keep = property2.getKeep();
            keep.setComponent("within-page", property, false);
            keep.setComponent("within-line", property, false);
            keep.setComponent("within-column", property, false);
            return property2;
        }
        return null;
    }

    protected String getDefaultForWithinColumn() {
        return "auto";
    }

    protected String getDefaultForWithinLine() {
        return "auto";
    }

    protected String getDefaultForWithinPage() {
        return "auto";
    }

    protected Property.Maker getSubpropMaker(String string) {
        if (string.equals("within-page")) {
            return s_WithinPageMaker;
        }
        if (string.equals("within-line")) {
            return s_WithinLineMaker;
        }
        if (string.equals("within-column")) {
            return s_WithinColumnMaker;
        }
        return super.getSubpropMaker(string);
    }

    public Property getSubpropValue(Property property, String string) {
        Keep keep = property.getKeep();
        return keep.getComponent(string);
    }

    protected boolean isCompoundMaker() {
        return true;
    }

    public Property make(PropertyList propertyList) throws FOPException {
        if (this.m_defaultProp == null) {
            this.m_defaultProp = this.makeCompound(propertyList, propertyList.getParentFObj());
        }
        return this.m_defaultProp;
    }

    protected Property makeCompound(PropertyList propertyList, FObj fObj) throws FOPException {
        Keep keep = new Keep();
        Property property = this.getSubpropMaker("within-page").make(propertyList, this.getDefaultForWithinPage(), fObj);
        keep.setComponent("within-page", property, true);
        property = this.getSubpropMaker("within-line").make(propertyList, this.getDefaultForWithinLine(), fObj);
        keep.setComponent("within-line", property, true);
        property = this.getSubpropMaker("within-column").make(propertyList, this.getDefaultForWithinColumn(), fObj);
        keep.setComponent("within-column", property, true);
        return new KeepProperty(keep);
    }

    public static Property.Maker maker(String string) {
        return new GenericKeep(string);
    }

    protected Property setSubprop(Property property, String string, Property property2) {
        Keep keep = property.getKeep();
        keep.setComponent(string, property2, false);
        return property;
    }

    public static interface Enums {

        public static interface WithinPage {
            public static final int AUTO = 1;
            public static final int ALWAYS = 2;
        }

        public static interface WithinLine {
            public static final int AUTO = 1;
            public static final int ALWAYS = 2;
        }

        public static interface WithinColumn {
            public static final int AUTO = 1;
            public static final int ALWAYS = 2;
        }
    }

    private static class SP_WithinPageMaker
    extends NumberProperty.Maker
    implements Enums.WithinPage {
        protected static final EnumProperty s_propAUTO = new EnumProperty(1);
        protected static final EnumProperty s_propALWAYS = new EnumProperty(2);

        SP_WithinPageMaker(String string) {
            super(string);
        }

        public Property checkEnumValues(String string) {
            if (string.equals("auto")) {
                return s_propAUTO;
            }
            if (string.equals("always")) {
                return s_propALWAYS;
            }
            return super.checkEnumValues(string);
        }
    }

    private static class SP_WithinLineMaker
    extends NumberProperty.Maker
    implements Enums.WithinLine {
        protected static final EnumProperty s_propAUTO = new EnumProperty(1);
        protected static final EnumProperty s_propALWAYS = new EnumProperty(2);

        SP_WithinLineMaker(String string) {
            super(string);
        }

        public Property checkEnumValues(String string) {
            if (string.equals("auto")) {
                return s_propAUTO;
            }
            if (string.equals("always")) {
                return s_propALWAYS;
            }
            return super.checkEnumValues(string);
        }
    }

    private static class SP_WithinColumnMaker
    extends NumberProperty.Maker
    implements Enums.WithinColumn {
        protected static final EnumProperty s_propAUTO = new EnumProperty(1);
        protected static final EnumProperty s_propALWAYS = new EnumProperty(2);

        SP_WithinColumnMaker(String string) {
            super(string);
        }

        public Property checkEnumValues(String string) {
            if (string.equals("auto")) {
                return s_propAUTO;
            }
            if (string.equals("always")) {
                return s_propALWAYS;
            }
            return super.checkEnumValues(string);
        }
    }
}

