/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.Vector;
import org.apache.fop.pdf.PDFObject;

public class PDFOutline
extends PDFObject {
    private Vector _subentries = new Vector();
    private PDFOutline _parent = null;
    private PDFOutline _prev = null;
    private PDFOutline _next = null;
    private PDFOutline _first = null;
    private PDFOutline _last = null;
    private int _count = 0;
    private String _title;
    String _actionRef;

    public PDFOutline(int n, String string, String string2) {
        super(n);
        this._title = string;
        this._actionRef = string2;
    }

    public void addOutline(PDFOutline pDFOutline) {
        if (this._subentries.size() > 0) {
            pDFOutline._prev = (PDFOutline)this._subentries.elementAt(this._subentries.size() - 1);
            pDFOutline._prev._next = pDFOutline;
        } else {
            this._first = pDFOutline;
        }
        this._subentries.addElement(pDFOutline);
        pDFOutline._parent = this;
        this.incrementCount();
        this._last = pDFOutline;
    }

    private String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c > '\u007f') {
                    stringBuffer.append("\\");
                    stringBuffer.append(Integer.toOctalString(c));
                } else {
                    switch (c) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            stringBuffer.append('\\');
                            break;
                        }
                    }
                    stringBuffer.append(c);
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    private void incrementCount() {
        ++this._count;
        if (this._parent != null) {
            this._parent.incrementCount();
        }
    }

    public void setTitle(String string) {
        this._title = string;
    }

    protected byte[] toPDF() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.number) + " " + this.generation + " obj\n<<\n");
        if (this._parent == null) {
            if (this._first != null && this._last != null) {
                stringBuffer.append(" /First " + this._first.referencePDF() + "\n");
                stringBuffer.append(" /Last " + this._last.referencePDF() + "\n");
            }
        } else {
            stringBuffer.append(" /Title (" + this.escapeString(this._title) + ")\n");
            stringBuffer.append(" /Parent " + this._parent.referencePDF() + "\n");
            if (this._first != null && this._last != null) {
                stringBuffer.append(" /First " + this._first.referencePDF() + "\n");
                stringBuffer.append(" /Last " + this._last.referencePDF() + "\n");
            }
            if (this._prev != null) {
                stringBuffer.append(" /Prev " + this._prev.referencePDF() + "\n");
            }
            if (this._next != null) {
                stringBuffer.append(" /Next " + this._next.referencePDF() + "\n");
            }
            if (this._count > 0) {
                stringBuffer.append(" /Count -" + this._count + "\n");
            }
            if (this._actionRef != null) {
                stringBuffer.append(" /A " + this._actionRef + "\n");
            }
        }
        stringBuffer.append(">> endobj\n");
        return stringBuffer.toString().getBytes();
    }
}

