/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.Kernel;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.image.renderable.ConvolveMatrixRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGFeConvolveMatrixElementBridge
implements FilterPrimitiveBridge,
SVGConstants {
    public Filter create(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element, Element element2, Filter filter, Rectangle2D rectangle2D, Map map) {
        String string;
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        String string2 = element.getAttributeNS(null, "order");
        Float[] floatArray = SVGUtilities.buildFloatPair(string2);
        int n = 0;
        int n2 = 0;
        if (floatArray[0] != null && (n = (int)floatArray[0].floatValue()) != (int)floatArray[0].floatValue()) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.order.notPosInt", null));
        }
        if (n <= 0) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.order.notPosInt", null));
        }
        if (floatArray[1] == null) {
            n2 = n;
        } else {
            n2 = (int)floatArray[1].floatValue();
            if (n2 != (int)floatArray[1].floatValue()) {
                throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.order.notPosInt", null));
            }
        }
        if (n2 <= 0) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.order.notPosInt", null));
        }
        float[] fArray = new float[n * n2];
        string2 = element.getAttributeNS(null, "kernelMatrix");
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            fArray[n3++] = SVGUtilities.convertSVGNumber("kernelMatrix", stringTokenizer.nextToken());
            if (n3 == n * n2) break;
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.kernelMatrix.tooMany", null));
        }
        if (n3 != n * n2) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.kernelMatrix.notEnough", null));
        }
        string2 = element.getAttributeNS(null, "divisor");
        float f = 0.0f;
        if (string2.length() != 0) {
            f = SVGUtilities.convertSVGNumber("divisor", string2);
        } else {
            n3 = 0;
            while (n3 < fArray.length) {
                f += fArray[n3];
                ++n3;
            }
            if (f == 0.0f) {
                f = 1.0f;
            }
        }
        if (f == 0.0f) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.divisor.zero", null));
        }
        string2 = element.getAttributeNS(null, "bias");
        float f2 = 0.0f;
        if (string2.length() != 0) {
            f2 = SVGUtilities.convertSVGNumber("bias", string2);
        }
        string2 = element.getAttributeNS(null, "targetX");
        int n4 = n / 2;
        if (string2.length() != 0) {
            n4 = SVGUtilities.convertSVGInteger("targetX", string2);
        }
        if (n4 < 0 || n4 >= n) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.targetX.invalid", null));
        }
        string2 = element.getAttributeNS(null, "targetY");
        int n5 = n2 / 2;
        if (string2.length() != 0) {
            n5 = SVGUtilities.convertSVGInteger("targetY", string2);
        }
        if (n5 < 0 || n5 >= n2) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.targetY.invalid", null));
        }
        string2 = element.getAttributeNS(null, "edgeMode");
        PadMode padMode = PadMode.REPLICATE;
        if (string2.length() != 0) {
            if ((string2 = string2.toLowerCase()).equals("duplicate")) {
                padMode = PadMode.REPLICATE;
            } else if (string2.equals("wrap")) {
                padMode = PadMode.WRAP;
            } else if (string2.equals("none")) {
                padMode = PadMode.ZERO_PAD;
            } else {
                throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.edgeMode.invalid", new Object[]{string2}));
            }
        }
        string2 = element.getAttributeNS(null, "kernelUnitLength");
        double[] dArray = null;
        if (string2.length() != 0) {
            Float[] floatArray2 = SVGUtilities.buildFloatPair(string2);
            dArray = new double[2];
            if (floatArray2[0] != null) {
                dArray[0] = floatArray2[0].floatValue();
            }
            dArray[1] = floatArray2[1] != null ? (double)floatArray2[1].floatValue() : dArray[0];
        }
        if (dArray != null) {
            if (dArray[0] <= 0.0) {
                throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.kernelUnitLength.notPositive", null));
            }
            if (dArray[1] <= 0.0) {
                throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.kernelUnitLength.notPositive", null));
            }
        }
        string2 = element.getAttributeNS(null, "preserveAlpha");
        boolean bl = false;
        if (string2.length() != 0) {
            if ((string2 = string2.toLowerCase()).equals("false")) {
                bl = false;
            } else if (string2.equals("true")) {
                bl = true;
            } else {
                throw new IllegalAttributeValueException(Messages.formatMessage("feConvolveMatrix.preserveAlpha.invalid", new Object[]{string2}));
            }
        }
        if ((filter = CSSUtilities.getFilterSource(graphicsNode, string = element.getAttributeNS(null, "in"), bridgeContext, element2, filter, map)) == null) {
            return null;
        }
        Filter filter2 = (Filter)map.get("SourceGraphic");
        Rectangle2D rectangle2D2 = filter.getBounds2D();
        if (filter == filter2) {
            rectangle2D2 = rectangle2D;
        }
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, rectangle2D2, rectangle2D, graphicsNode, graphicsNodeRenderContext, defaultUnitProcessorContext, documentLoader);
        PadRable8Bit padRable8Bit = new PadRable8Bit(filter, rectangle2D3, PadMode.ZERO_PAD);
        ConvolveMatrixRable8Bit convolveMatrixRable8Bit = new ConvolveMatrixRable8Bit(padRable8Bit);
        int n6 = 0;
        while (n6 < fArray.length) {
            int n7 = n6++;
            fArray[n7] = fArray[n7] / f;
        }
        convolveMatrixRable8Bit.setKernel(new Kernel(n, n2, fArray));
        convolveMatrixRable8Bit.setTarget(new Point(n4, n5));
        convolveMatrixRable8Bit.setBias(f2);
        convolveMatrixRable8Bit.setEdgeMode(padMode);
        convolveMatrixRable8Bit.setKernelUnitLength(dArray);
        convolveMatrixRable8Bit.setPreserveAlpha(bl);
        String string3 = element.getAttributeNS(null, "result");
        if (string3 != null && string3.trim().length() > 0) {
            map.put(string3, convolveMatrixRable8Bit);
        }
        return convolveMatrixRable8Bit;
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }
}

