/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.MissingAttributeException;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PreserveAspectRatioHandler;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.apache.batik.util.SVGConstants;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLangSpace;

public class SVGUtilities
implements SVGConstants {
    public static final int EMPTY = 0;
    public static final int BACKGROUND_ALPHA = 1;
    public static final int BACKGROUND_IMAGE = 2;
    public static final int FILL_PAINT = 3;
    public static final int SOURCE_ALPHA = 4;
    public static final int SOURCE_GRAPHIC = 5;
    public static final int STROKE_PAINT = 6;
    public static final int IDENTIFIER = 7;
    public static final int OBJECT_BOUNDING_BOX = 0;
    public static final int USER_SPACE_ON_USE = 1;

    protected SVGUtilities() {
    }

    public static int parseCoordinateSystem(String string) {
        int n = string.length();
        if (n == 0) {
            throw new Error("Can't accept empty coordinate system");
        }
        if ("userSpaceOnUse".equals(string)) {
            return 1;
        }
        if ("objectBoundingBox".equals(string)) {
            return 0;
        }
        throw new IllegalArgumentException();
    }

    public static int parseInAttribute(String string) {
        int n = string.length();
        if (string.length() == 0) {
            return 0;
        }
        switch (string.charAt(0)) {
            case 'B': {
                if (n != 15) {
                    return 7;
                }
                switch (string.charAt(10)) {
                    case 'A': {
                        if (string.charAt(1) != 'a' || string.charAt(2) != 'c' || string.charAt(3) != 'k' || string.charAt(4) != 'g' || string.charAt(5) != 'r' || string.charAt(6) != 'o' || string.charAt(7) != 'u' || string.charAt(8) != 'n' || string.charAt(9) != 'd' || string.charAt(11) != 'l' || string.charAt(12) != 'p' || string.charAt(13) != 'h' || string.charAt(14) != 'a') {
                            return 7;
                        }
                        return 1;
                    }
                    case 'I': {
                        if (string.charAt(1) != 'a' || string.charAt(2) != 'c' || string.charAt(3) != 'k' || string.charAt(4) != 'g' || string.charAt(5) != 'r' || string.charAt(6) != 'o' || string.charAt(7) != 'u' || string.charAt(8) != 'n' || string.charAt(9) != 'd' || string.charAt(11) != 'm' || string.charAt(12) != 'a' || string.charAt(13) != 'g' || string.charAt(14) != 'e') {
                            return 7;
                        }
                        return 2;
                    }
                }
                return 7;
            }
            case 'F': {
                if (n != 9 || string.charAt(1) != 'i' || string.charAt(2) != 'l' || string.charAt(3) != 'l' || string.charAt(4) != 'P' || string.charAt(5) != 'a' || string.charAt(6) != 'i' || string.charAt(7) != 'n' || string.charAt(8) != 't') {
                    return 7;
                }
                return 3;
            }
            case 'S': {
                if (n < 11) {
                    return 7;
                }
                switch (string.charAt(1)) {
                    case 'o': {
                        switch (string.charAt(6)) {
                            case 'A': {
                                if (n != 11 || string.charAt(2) != 'u' || string.charAt(3) != 'r' || string.charAt(4) != 'c' || string.charAt(5) != 'e' || string.charAt(7) != 'l' || string.charAt(8) != 'p' || string.charAt(9) != 'h' || string.charAt(10) != 'a') {
                                    return 7;
                                }
                                return 4;
                            }
                            case 'G': {
                                if (n != 13 || string.charAt(2) != 'u' || string.charAt(3) != 'r' || string.charAt(4) != 'c' || string.charAt(5) != 'e' || string.charAt(7) != 'r' || string.charAt(8) != 'a' || string.charAt(9) != 'p' || string.charAt(10) != 'h' || string.charAt(11) != 'i' || string.charAt(12) != 'c') {
                                    return 7;
                                }
                                return 5;
                            }
                        }
                        return 7;
                    }
                    case 't': {
                        if (n != 11 || string.charAt(2) != 'r' || string.charAt(3) != 'o' || string.charAt(4) != 'k' || string.charAt(5) != 'e' || string.charAt(6) != 'P' || string.charAt(7) != 'a' || string.charAt(8) != 'i' || string.charAt(9) != 'n' || string.charAt(10) != 't') {
                            return 7;
                        }
                        return 6;
                    }
                }
                return 7;
            }
        }
        return 7;
    }

    public static float[] parseViewBoxAttribute(String string) {
        if (string.length() == 0) {
            return null;
        }
        int n = 0;
        float[] fArray = new float[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (n < 4 && stringTokenizer.hasMoreTokens()) {
            fArray[n] = Float.parseFloat(stringTokenizer.nextToken());
            ++n;
        }
        return fArray;
    }

    public static AffineTransform getPreserveAspectRatioTransform(SVGElement sVGElement, float f, float f2) {
        AffineTransform affineTransform = new AffineTransform();
        String string = sVGElement.getAttributeNS(null, "viewBox");
        float[] fArray = SVGUtilities.parseViewBoxAttribute(string);
        if (fArray == null || fArray[2] == 0.0f || fArray[3] == 0.0f) {
            return affineTransform;
        }
        PreserveAspectRatioParser preserveAspectRatioParser = new PreserveAspectRatioParser();
        PreserveAspectRatio preserveAspectRatio = new PreserveAspectRatio();
        preserveAspectRatioParser.setPreserveAspectRatioHandler(preserveAspectRatio);
        preserveAspectRatioParser.parse(new StringReader(sVGElement.getAttributeNS(null, "preserveAspectRatio")));
        float f3 = fArray[2] / fArray[3];
        float f4 = f / f2;
        if (preserveAspectRatio.align == 1) {
            affineTransform.scale(f / fArray[2], f2 / fArray[3]);
            affineTransform.translate(-fArray[0], -fArray[1]);
        } else if (f3 < f4 && preserveAspectRatio.meet || f3 >= f4 && !preserveAspectRatio.meet) {
            float f5 = f2 / fArray[3];
            affineTransform.scale(f5, f5);
            switch (preserveAspectRatio.align) {
                case 2: 
                case 5: 
                case 8: {
                    affineTransform.translate(-fArray[0], -fArray[1]);
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    affineTransform.translate(-fArray[0] - (fArray[2] - f * fArray[3] / f2) / 2.0f, -fArray[1]);
                    break;
                }
                default: {
                    affineTransform.translate(-fArray[0] - (fArray[2] - f * fArray[3] / f2), -fArray[1]);
                    break;
                }
            }
        } else {
            float f6 = f / fArray[2];
            affineTransform.scale(f6, f6);
            switch (preserveAspectRatio.align) {
                case 2: 
                case 3: 
                case 4: {
                    affineTransform.translate(-fArray[0], -fArray[1]);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    affineTransform.translate(-fArray[0], -fArray[1] - (fArray[3] - f2 * fArray[2] / f) / 2.0f);
                    break;
                }
                default: {
                    affineTransform.translate(-fArray[0], -fArray[1] - (fArray[3] - f2 * fArray[2] / f));
                }
            }
        }
        return affineTransform;
    }

    public static String getDescription(SVGElement sVGElement) {
        String string = "";
        boolean bl = false;
        Node node = sVGElement.getFirstChild();
        if (node != null && node.getNodeType() == 1) {
            String string2;
            String string3 = string2 = node.getPrefix() == null ? node.getNodeName() : node.getLocalName();
            if (string2.equals("desc")) {
                bl = ((SVGLangSpace)((Object)node)).getXMLspace().equals("preserve");
                node = node.getFirstChild();
                while (node != null) {
                    if (node.getNodeType() == 3) {
                        string = string + node.getNodeValue();
                    }
                    node = node.getNextSibling();
                }
            }
        }
        return bl ? XMLSupport.preserveXMLSpace(string) : XMLSupport.defaultXMLSpace(string);
    }

    public static boolean matchUserAgent(Element element, UserAgent userAgent) {
        if (element.hasAttributeNS(null, "systemLanguage")) {
            String string = element.getAttributeNS(null, "systemLanguage");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!SVGUtilities.matchUserLanguage(string2, userAgent.getLanguages())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected static boolean matchUserLanguage(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string.startsWith(string3)) continue;
            if (string.length() > string3.length()) {
                return string.charAt(string3.length()) == '-';
            }
            return true;
        }
        return false;
    }

    public static int convertSVGInteger(String string, String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("integer.invalid", new Object[]{string2, string}));
        }
    }

    public static float convertSVGNumber(String string, String string2) {
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("float.invalid", new Object[]{string2, string}));
        }
    }

    public static String getChainableAttributeNS(Element element, String string, String string2, DocumentLoader documentLoader) {
        Element element2 = element;
        LinkedList<URL> linkedList = new LinkedList<URL>();
        String string3;
        while ((string3 = element2.getAttributeNS(string, string2)).length() <= 0) {
            String string4 = XLinkSupport.getXLinkHref(element2);
            if (string4.length() == 0) {
                return "";
            }
            SVGDocument sVGDocument = (SVGDocument)element2.getOwnerDocument();
            URL uRL = ((SVGOMDocument)sVGDocument).getURLObject();
            try {
                Object object;
                URL uRL2 = new URL(uRL, string4);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    object = (URL)iterator.next();
                    if (!((URL)object).sameFile(uRL2) || !((URL)object).getRef().equals(uRL2.getRef())) continue;
                    throw new IllegalAttributeValueException("circular reference on " + element2);
                }
                object = new URIResolver(sVGDocument, documentLoader);
                element2 = ((URIResolver)object).getElement(uRL2.toString());
                linkedList.add(uRL2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalAttributeValueException("bad url on " + string4);
            }
            catch (IOException iOException) {
                throw new IllegalAttributeValueException("I/O error on " + string4);
            }
        }
        return string3;
    }

    public static Rectangle2D convertFilterChainRegion(Element element, Element element2, GraphicsNode graphicsNode, GraphicsNodeRenderContext graphicsNodeRenderContext, UnitProcessor.Context context, DocumentLoader documentLoader) {
        String string = SVGUtilities.getChainableAttributeNS(element, null, "x", documentLoader);
        String string2 = SVGUtilities.getChainableAttributeNS(element, null, "y", documentLoader);
        String string3 = SVGUtilities.getChainableAttributeNS(element, null, "width", documentLoader);
        String string4 = SVGUtilities.getChainableAttributeNS(element, null, "height", documentLoader);
        String string5 = SVGUtilities.getChainableAttributeNS(element, null, "filterUnits", documentLoader);
        return SVGUtilities.convertRegion(element, element2, graphicsNode, graphicsNodeRenderContext, context, string5, "objectBoundingBox", string, "-10%", string2, "-10%", string3, "120%", string4, "120%");
    }

    public static Rectangle2D convertMaskRegion(Element element, Element element2, GraphicsNode graphicsNode, GraphicsNodeRenderContext graphicsNodeRenderContext, UnitProcessor.Context context) {
        String string = element.getAttributeNS(null, "x");
        String string2 = element.getAttributeNS(null, "y");
        String string3 = element.getAttributeNS(null, "width");
        String string4 = element.getAttributeNS(null, "height");
        String string5 = element.getAttributeNS(null, "maskUnits");
        return SVGUtilities.convertRegion(element, element2, graphicsNode, graphicsNodeRenderContext, context, string5, "objectBoundingBox", string, "-10%", string2, "-10%", string3, "120%", string4, "120%");
    }

    public static Rectangle2D convertPatternRegion(Element element, Element element2, GraphicsNode graphicsNode, GraphicsNodeRenderContext graphicsNodeRenderContext, UnitProcessor.Context context, DocumentLoader documentLoader) {
        String string = SVGUtilities.getChainableAttributeNS(element, null, "x", documentLoader);
        String string2 = SVGUtilities.getChainableAttributeNS(element, null, "y", documentLoader);
        String string3 = SVGUtilities.getChainableAttributeNS(element, null, "width", documentLoader);
        String string4 = SVGUtilities.getChainableAttributeNS(element, null, "height", documentLoader);
        String string5 = SVGUtilities.getChainableAttributeNS(element, null, "patternUnits", documentLoader);
        return SVGUtilities.convertRegion(element, element2, graphicsNode, graphicsNodeRenderContext, context, string5, "objectBoundingBox", string, "-10%", string2, "-10%", string3, "120%", string4, "120%");
    }

    protected static Rectangle2D convertRegion(Element element, Element element2, GraphicsNode graphicsNode, GraphicsNodeRenderContext graphicsNodeRenderContext, UnitProcessor.Context context, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        double d;
        double d2;
        double d3;
        double d4;
        int n;
        if (string.length() == 0) {
            string = string2;
        }
        if (string3.length() == 0) {
            if (string4 == null) {
                throw new MissingAttributeException(Messages.formatMessage("region.x.required", new Object[]{element.getLocalName()}));
            }
            string3 = string4;
        }
        if (string5.length() == 0) {
            if (string6 == null) {
                throw new MissingAttributeException(Messages.formatMessage("region.y.required", new Object[]{element.getLocalName()}));
            }
            string5 = string6;
        }
        if (string7.length() == 0) {
            if (string8 == null) {
                throw new MissingAttributeException(Messages.formatMessage("region.width.required", new Object[]{element.getLocalName()}));
            }
            string7 = string8;
        }
        if (string9.length() == 0) {
            if (string10 == null) {
                throw new MissingAttributeException(Messages.formatMessage("region.height.required", new Object[]{element.getLocalName()}));
            }
            string9 = string10;
        }
        try {
            n = SVGUtilities.parseCoordinateSystem(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("region.units.invalid", new Object[]{string, element.getLocalName()}));
        }
        short s = 2;
        short s2 = 1;
        switch (n) {
            case 0: {
                d4 = SVGUtilities.svgToObjectBoundingBox(element2, "x", string3, context, s);
                d3 = SVGUtilities.svgToObjectBoundingBox(element2, "yChannelSelector", string5, context, s2);
                d2 = SVGUtilities.svgToObjectBoundingBox(element2, "width", string7, context, s);
                d = SVGUtilities.svgToObjectBoundingBox(element2, "height", string9, context, s2);
                Rectangle2D rectangle2D = graphicsNode.getGeometryBounds(graphicsNodeRenderContext);
                if (rectangle2D != null) {
                    d4 = rectangle2D.getX() + d4 * rectangle2D.getWidth();
                    d3 = rectangle2D.getY() + d3 * rectangle2D.getHeight();
                    d2 *= rectangle2D.getWidth();
                    d *= rectangle2D.getHeight();
                    break;
                }
                d4 = 0.0;
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
                break;
            }
            case 1: {
                d4 = SVGUtilities.svgToUserSpaceOnUse(element2, "x", string3, context, s);
                d3 = SVGUtilities.svgToUserSpaceOnUse(element2, "y", string5, context, s2);
                d2 = SVGUtilities.svgToUserSpaceOnUse(element2, "width", string7, context, s);
                d = SVGUtilities.svgToUserSpaceOnUse(element2, "height", string9, context, s2);
                break;
            }
            default: {
                throw new Error();
            }
        }
        if (d2 < 0.0) {
            throw new IllegalAttributeValueException(Messages.formatMessage("region.width.illegal", new Object[]{element.getLocalName()}));
        }
        if (d < 0.0) {
            throw new IllegalAttributeValueException(Messages.formatMessage("region.height.illegal", new Object[]{element.getLocalName()}));
        }
        return new Rectangle2D.Double(d4, d3, d2, d);
    }

    public static Rectangle2D convertFilterPrimitiveRegion(Element element, Element element2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, GraphicsNode graphicsNode, GraphicsNodeRenderContext graphicsNodeRenderContext, UnitProcessor.Context context, DocumentLoader documentLoader) {
        int n;
        Object object;
        Node node = element.getParentNode();
        String string = "";
        if (node != null && node.getNodeType() == 1) {
            object = (Element)node;
            string = SVGUtilities.getChainableAttributeNS((Element)object, null, "primitiveUnits", documentLoader);
        }
        if (string.length() == 0) {
            string = "userSpaceOnUse";
        }
        object = element.getAttributeNS(null, "x");
        String string2 = element.getAttributeNS(null, "y");
        String string3 = element.getAttributeNS(null, "width");
        String string4 = element.getAttributeNS(null, "height");
        try {
            n = SVGUtilities.parseCoordinateSystem(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("region.units.invalid", new Object[]{string, "primitiveUnits", element.getLocalName()}));
        }
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        short s = 2;
        short s2 = 1;
        switch (n) {
            case 0: {
                Rectangle2D rectangle2D3 = graphicsNode.getGeometryBounds(graphicsNodeRenderContext);
                if (((String)object).length() != 0) {
                    d = SVGUtilities.svgToObjectBoundingBox(element2, "x", (String)object, context, s);
                    d = rectangle2D3.getX() + d * rectangle2D3.getWidth();
                }
                if (string2.length() != 0) {
                    d2 = SVGUtilities.svgToObjectBoundingBox(element2, "y", string2, context, s2);
                    d2 = rectangle2D3.getY() + d2 * rectangle2D3.getHeight();
                }
                if (string3.length() != 0) {
                    d3 = SVGUtilities.svgToObjectBoundingBox(element2, "width", string3, context, s);
                    d3 *= rectangle2D3.getWidth();
                }
                if (string4.length() == 0) break;
                d4 = SVGUtilities.svgToObjectBoundingBox(element2, "height", string4, context, s2);
                d4 *= rectangle2D3.getHeight();
                break;
            }
            case 1: {
                if (((String)object).length() != 0) {
                    d = SVGUtilities.svgToUserSpaceOnUse(element2, "x", (String)object, context, s);
                }
                if (string2.length() != 0) {
                    d2 = SVGUtilities.svgToUserSpaceOnUse(element2, "y", string2, context, s2);
                }
                if (string3.length() != 0) {
                    d3 = SVGUtilities.svgToUserSpaceOnUse(element2, "width", string3, context, s);
                }
                if (string4.length() == 0) break;
                d4 = SVGUtilities.svgToUserSpaceOnUse(element2, "height", string4, context, s2);
                break;
            }
            default: {
                throw new Error();
            }
        }
        if (d3 < 0.0) {
            throw new IllegalAttributeValueException(Messages.formatMessage("region.width.illegal", new Object[]{element.getLocalName()}));
        }
        if (d4 < 0.0) {
            throw new IllegalAttributeValueException(Messages.formatMessage("region.height.illegal", new Object[]{element.getLocalName()}));
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        Rectangle2D.intersect(double_, rectangle2D2, double_);
        return double_;
    }

    public static Point2D convertGradientPoint(Element element, String string, String string2, String string3, String string4, int n, UnitProcessor.Context context) {
        float f;
        float f2;
        short s = 2;
        short s2 = 1;
        switch (n) {
            case 0: {
                f2 = SVGUtilities.svgToObjectBoundingBox(element, string, string2, context, s);
                f = SVGUtilities.svgToObjectBoundingBox(element, string3, string4, context, s2);
                break;
            }
            case 1: {
                f2 = SVGUtilities.svgToUserSpaceOnUse(element, string, string2, context, s);
                f = SVGUtilities.svgToUserSpaceOnUse(element, string3, string4, context, s2);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return new Point2D.Float(f2, f);
    }

    public static float convertGradientLength(Element element, String string, String string2, int n, UnitProcessor.Context context) {
        float f;
        short s = 0;
        switch (n) {
            case 0: {
                f = SVGUtilities.svgToObjectBoundingBox(element, string, string2, context, s);
                break;
            }
            case 1: {
                f = SVGUtilities.svgToUserSpaceOnUse(element, string, string2, context, s);
                break;
            }
            default: {
                throw new Error();
            }
        }
        if (f < 0.0f) {
            throw new IllegalAttributeValueException(Messages.formatMessage("length.illegal", new Object[]{string}));
        }
        return f;
    }

    public static AffineTransform convertAffineTransform(String string) {
        try {
            StringReader stringReader = new StringReader(string);
            return AWTTransformProducer.createAffineTransform(stringReader);
        }
        catch (ParseException parseException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("transform.invalid", new Object[]{string, parseException.getMessage()}));
        }
    }

    public static AffineTransform convertAffineTransform(AffineTransform affineTransform, GraphicsNode graphicsNode, GraphicsNodeRenderContext graphicsNodeRenderContext, int n) {
        AffineTransform affineTransform2 = new AffineTransform();
        switch (n) {
            case 0: {
                Rectangle2D rectangle2D = graphicsNode.getGeometryBounds(graphicsNodeRenderContext);
                affineTransform2.translate(rectangle2D.getX(), rectangle2D.getY());
                affineTransform2.scale(rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new Error();
            }
        }
        affineTransform2.concatenate(affineTransform);
        return affineTransform2;
    }

    public static Float[] buildFloatPair(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Float[] floatArray = new Float[2];
        if (stringTokenizer.countTokens() > 0) {
            String string2 = stringTokenizer.nextToken();
            try {
                floatArray[0] = new Float(Float.parseFloat(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new Error(numberFormatException.getMessage());
            }
            if (floatArray[0] != null && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    floatArray[1] = new Float(Float.parseFloat(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Error(numberFormatException.getMessage());
                }
            }
        }
        return floatArray;
    }

    public static float svgToUserSpace(Element element, String string, String string2, UnitProcessor.Context context, short s) {
        if (string2 == null || string2.length() == 0) {
            throw new Error("The value is null or empty");
        }
        LengthParser lengthParser = new LengthParser();
        UnitProcessor.UnitResolver unitResolver = new UnitProcessor.UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        try {
            lengthParser.parse(new StringReader(string2));
        }
        catch (ParseException parseException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("length.invalid", new Object[]{string2, string}));
        }
        return UnitProcessor.svgToUserSpace(unitResolver.unit, unitResolver.value, (SVGElement)element, s, context);
    }

    public static float[] svgToUserSpaceArray(Element element, String string, String string2, UnitProcessor.Context context, short s) {
        Object object;
        if (string2 == null || string2.length() == 0) {
            throw new Error("The value is null or empty");
        }
        LengthParser lengthParser = new LengthParser();
        UnitProcessor.UnitResolver unitResolver = new UnitProcessor.UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ", false);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            try {
                lengthParser.parse(new StringReader((String)object));
                ++n;
            }
            catch (ParseException parseException) {
                throw new IllegalAttributeValueException(Messages.formatMessage("length.invalid", new Object[]{object, string}));
            }
            arrayList.add(new Float(UnitProcessor.svgToUserSpace(unitResolver.unit, unitResolver.value, (SVGElement)element, s, context)));
        }
        object = new float[n];
        int n2 = 0;
        while (n2 < n) {
            object[n2] = ((Float)arrayList.get(n2)).floatValue();
            ++n2;
        }
        return object;
    }

    protected static float svgToObjectBoundingBox(Element element, String string, String string2, UnitProcessor.Context context, short s) {
        if (string2 == null || string2.length() == 0) {
            throw new Error("The value is null or empty");
        }
        LengthParser lengthParser = new LengthParser();
        UnitProcessor.UnitResolver unitResolver = new UnitProcessor.UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        try {
            lengthParser.parse(new StringReader(string2));
        }
        catch (ParseException parseException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("length.invalid", new Object[]{string2, string}));
        }
        float f = unitResolver.value;
        if (unitResolver.unit == 2) {
            f /= 100.0f;
        }
        return f;
    }

    protected static float svgToUserSpaceOnUse(Element element, String string, String string2, UnitProcessor.Context context, short s) {
        return SVGUtilities.svgToUserSpace(element, string, string2, context, s);
    }

    protected static class PreserveAspectRatio
    implements PreserveAspectRatioHandler {
        public short align;
        public boolean meet;

        protected PreserveAspectRatio() {
        }

        public void startPreserveAspectRatio() throws ParseException {
        }

        public void none() throws ParseException {
            this.align = 1;
        }

        public void xMaxYMax() throws ParseException {
            this.align = (short)10;
        }

        public void xMaxYMid() throws ParseException {
            this.align = (short)7;
        }

        public void xMaxYMin() throws ParseException {
            this.align = (short)4;
        }

        public void xMidYMax() throws ParseException {
            this.align = (short)9;
        }

        public void xMidYMid() throws ParseException {
            this.align = (short)6;
        }

        public void xMidYMin() throws ParseException {
            this.align = (short)3;
        }

        public void xMinYMax() throws ParseException {
            this.align = (short)8;
        }

        public void xMinYMid() throws ParseException {
            this.align = (short)5;
        }

        public void xMinYMin() throws ParseException {
            this.align = (short)2;
        }

        public void meet() throws ParseException {
            this.meet = true;
        }

        public void slice() throws ParseException {
            this.meet = false;
        }

        public void endPreserveAspectRatio() throws ParseException {
        }
    }
}

