/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

import java.io.StringReader;
import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSDocumentHandler;
import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.DocumentHandlerAdapter;
import org.apache.batik.css.PropertyMap;
import org.apache.batik.css.event.CSSStyleDeclarationChangeListener;
import org.apache.batik.css.event.CSSStyleDeclarationChangeSupport;
import org.apache.batik.css.event.CSSValueChangeListener;
import org.apache.batik.css.value.ValueFactory;
import org.apache.batik.css.value.ValueFactoryMap;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSOMStyleDeclaration
implements CSSStyleDeclaration,
CSSValueChangeListener {
    protected static final ValueFactoryMap EMPTY_MAP = new ValueFactoryMap(){

        public ValueFactory get(String string) {
            return null;
        }
    };
    protected Parser parser;
    protected PropertyMap properties = new PropertyMap();
    protected PropertyMap oldProperties;
    protected DocumentHandler handler = new StyleDeclarationHandler();
    protected ValueFactoryMap factories = EMPTY_MAP;
    protected CSSRule parentRule;
    protected CSSStyleDeclarationChangeSupport declarationChangeSupport;

    public CSSOMStyleDeclaration() {
        try {
            this.parser = CSSDocumentHandler.createParser();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public CSSOMStyleDeclaration(CSSRule cSSRule, Parser parser) {
        this.parser = parser;
        this.parentRule = cSSRule;
    }

    public void setValueFactoryMap(ValueFactoryMap valueFactoryMap) {
        this.factories = valueFactoryMap;
    }

    public ValueFactoryMap getValueFactoryMap() {
        return this.factories;
    }

    public void cssValueChange(String string, CSSValue cSSValue, CSSValue cSSValue2) {
        if (this.declarationChangeSupport != null) {
            this.declarationChangeSupport.fireCSSPropertyChange(string, cSSValue, cSSValue2);
        }
    }

    public void addCSSStyleDeclarationChangeListener(CSSStyleDeclarationChangeListener cSSStyleDeclarationChangeListener) {
        if (this.declarationChangeSupport == null) {
            this.declarationChangeSupport = new CSSStyleDeclarationChangeSupport(this);
        }
        this.declarationChangeSupport.addCSSStyleDeclarationChangeListener(cSSStyleDeclarationChangeListener);
    }

    public void removeCSSStyleDeclarationChangeListener(CSSStyleDeclarationChangeListener cSSStyleDeclarationChangeListener) {
        if (this.declarationChangeSupport == null) {
            return;
        }
        this.declarationChangeSupport.removeCSSStyleDeclarationChangeListener(cSSStyleDeclarationChangeListener);
    }

    public void fireCSSStyleDeclarationChangeStart() {
        if (this.declarationChangeSupport == null) {
            return;
        }
        this.declarationChangeSupport.fireCSSStyleDeclarationChangeStart();
    }

    public void fireCSSStyleDeclarationChangeCancel() {
        if (this.declarationChangeSupport == null) {
            return;
        }
        this.declarationChangeSupport.fireCSSStyleDeclarationChangeCancel();
    }

    public void fireCSSStyleDeclarationChangeEnd() {
        if (this.declarationChangeSupport == null) {
            return;
        }
        this.declarationChangeSupport.fireCSSStyleDeclarationChangeEnd();
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.properties.size() - 1;
        while (n >= 0) {
            String string = (String)this.properties.key(n);
            stringBuffer.append("    ").append(string).append(": ");
            ValueEntry valueEntry = (ValueEntry)this.properties.get(string);
            if (valueEntry.value != null) {
                stringBuffer.append(valueEntry.value.getCssText());
            }
            stringBuffer.append(valueEntry.priority).append(";\n");
            --n;
        }
        return stringBuffer.toString();
    }

    public void setCssText(String string) throws DOMException {
        this.fireCSSStyleDeclarationChangeStart();
        PropertyMap propertyMap = this.properties;
        this.oldProperties = new PropertyMap(this.properties);
        this.properties = new PropertyMap();
        try {
            StringReader stringReader = new StringReader(string);
            this.parser.setDocumentHandler(this.handler);
            this.parser.parseStyleDeclaration(new InputSource(stringReader));
        }
        catch (DOMException dOMException) {
            this.properties = propertyMap;
            this.oldProperties = null;
            this.fireCSSStyleDeclarationChangeCancel();
            throw dOMException;
        }
        catch (Exception exception) {
            this.properties = propertyMap;
            this.oldProperties = null;
            this.fireCSSStyleDeclarationChangeCancel();
            throw CSSDOMExceptionFactory.createDOMException((short)15, "style.declaration.value", new Object[]{string});
        }
        int n = 0;
        while (n < propertyMap.size()) {
            ValueEntry valueEntry = (ValueEntry)propertyMap.item(n);
            valueEntry.value.setCSSValueChangeListener(null);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.oldProperties.size()) {
            ValueEntry valueEntry = (ValueEntry)this.oldProperties.item(n2);
            this.cssValueChange((String)this.oldProperties.key(n2), valueEntry.value, null);
            ++n2;
        }
        this.oldProperties = null;
        this.fireCSSStyleDeclarationChangeEnd();
    }

    public String getPropertyValue(String string) {
        ValueEntry valueEntry = (ValueEntry)this.properties.get(string.toLowerCase().intern());
        return valueEntry == null ? "" : valueEntry.value.getCssText();
    }

    public CSSValue getPropertyCSSValue(String string) {
        ValueEntry valueEntry = (ValueEntry)this.properties.get(string.toLowerCase().intern());
        return valueEntry == null ? null : valueEntry.value;
    }

    public void setPropertyCSSValue(String string, CSSValue cSSValue, String string2) {
        CSSOMValue cSSOMValue;
        ValueEntry valueEntry = (ValueEntry)this.properties.put(string, new ValueEntry((CSSOMValue)cSSValue, string2));
        CSSOMValue cSSOMValue2 = cSSOMValue = valueEntry == null ? null : valueEntry.value;
        if (cSSOMValue == null && this.oldProperties != null && (valueEntry = (ValueEntry)this.oldProperties.remove(string)) != null) {
            cSSOMValue = valueEntry.value;
        }
        if (cSSOMValue != null) {
            cSSOMValue.setCSSValueChangeListener(null);
        }
        ((CSSOMValue)cSSValue).setCSSValueChangeListener(this);
        this.cssValueChange(string, cSSOMValue, cSSValue);
    }

    public String removeProperty(String string) throws DOMException {
        ValueEntry valueEntry = (ValueEntry)this.properties.remove(string.toLowerCase().intern());
        if (valueEntry == null) {
            return "";
        }
        CSSOMValue cSSOMValue = valueEntry.value;
        cSSOMValue.setCSSValueChangeListener(null);
        return cSSOMValue.getCssText();
    }

    public String getPropertyPriority(String string) {
        ValueEntry valueEntry = (ValueEntry)this.properties.get(string.toLowerCase().intern());
        return valueEntry == null ? "" : (valueEntry.priority == null ? "" : valueEntry.priority);
    }

    public void setProperty(String string, String string2, String string3) throws DOMException {
        try {
            ValueFactory valueFactory = this.factories.get(string.toLowerCase().intern());
            InputSource inputSource = new InputSource(new StringReader(string2));
            LexicalUnit lexicalUnit = this.parser.parsePropertyValue(inputSource);
            valueFactory.createCSSValue(lexicalUnit, this, string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw CSSDOMExceptionFactory.createDOMException((short)15, "property.value", new Object[]{string2});
        }
    }

    public int getLength() {
        return this.properties.size();
    }

    public String item(int n) {
        String string = (String)this.properties.key(n);
        return string == null ? "" : string;
    }

    public CSSRule getParentRule() {
        return this.parentRule;
    }

    protected class StyleDeclarationHandler
    extends DocumentHandlerAdapter {
        protected StyleDeclarationHandler() {
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            String string2 = bl ? "!important" : "";
            ValueFactory valueFactory = CSSOMStyleDeclaration.this.factories.get(string.toLowerCase().intern());
            valueFactory.createCSSValue(lexicalUnit, CSSOMStyleDeclaration.this, string2);
        }
    }

    protected static class ValueEntry {
        public CSSOMValue value;
        public String priority;

        public ValueEntry(CSSOMValue cSSOMValue, String string) {
            this.value = cSSOMValue;
            this.priority = string;
        }
    }
}

