/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.svg;

import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.svg.ImmutableSVGColorValue;
import org.apache.batik.css.svg.SVGCSSNumberList;
import org.apache.batik.css.value.ImmutableValue;
import org.w3c.dom.css.CSSPrimitiveValue;

public class ImmutableSVGPaintValue
extends ImmutableSVGColorValue {
    protected String uri;

    public ImmutableSVGPaintValue(short s, CSSPrimitiveValue cSSPrimitiveValue, CSSPrimitiveValue cSSPrimitiveValue2, CSSPrimitiveValue cSSPrimitiveValue3, String string, SVGCSSNumberList sVGCSSNumberList, String string2) {
        super(s, cSSPrimitiveValue, cSSPrimitiveValue2, cSSPrimitiveValue3, string, sVGCSSNumberList);
        this.uri = string2;
    }

    public short getPaintType() {
        return this.getColorType();
    }

    public String getUri() {
        return this.uri;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ImmutableSVGPaintValue)) {
            return false;
        }
        ImmutableSVGPaintValue immutableSVGPaintValue = (ImmutableSVGPaintValue)object;
        if (!super.equals(object)) {
            return false;
        }
        return !(this.uri != null ? !this.uri.equals(immutableSVGPaintValue.uri) : immutableSVGPaintValue.uri != null);
    }

    public ImmutableValue createReadOnlyCopy() {
        return new ImmutableSVGPaintValue(this.colorType, this.red == null ? null : ((CSSOMValue)this.red).createReadOnlyCopy(), this.green == null ? null : ((CSSOMValue)this.green).createReadOnlyCopy(), this.blue == null ? null : ((CSSOMValue)this.blue).createReadOnlyCopy(), this.colorProfile, this.colors == null ? null : this.colors.createReadOnlyCopy(), this.uri);
    }

    public String getCssText() {
        switch (this.colorType) {
            case 103: {
                return "url('" + this.uri + "') none";
            }
            case 104: {
                return "url('" + this.uri + "') currentColor";
            }
            case 105: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("url('").append(this.uri).append("') rgb(").append(this.red.getCssText()).append(", ").append(this.green.getCssText()).append(", ").append(this.blue.getCssText()).append(")");
                return stringBuffer.toString();
            }
            case 106: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("url('").append(this.uri).append("') rgb(").append(this.red.getCssText()).append(", ").append(this.green.getCssText()).append(", ").append(this.blue.getCssText()).append(") icc-color(").append(this.colorProfile);
                if (this.colors.getNumberOfItems() != 0) {
                    stringBuffer.append(", ").append(this.colors.toString());
                }
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
        }
        return super.getCssText();
    }
}

