/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.experiment;

import java.awt.Composite;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.ext.awt.font.TextPathLayout;
import org.apache.batik.ext.awt.image.renderable.Clip;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.filter.Mask;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.util.SVGConstants;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;

public class TextPathElementBridge
implements GraphicsNodeBridge,
SVGConstants {
    protected static final Map fonts = new HashMap(11);

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Object object;
        Object object2;
        Shape shape;
        Object object3;
        int n;
        String string;
        int n2;
        float f;
        boolean bl;
        float f2;
        ShapeNode shapeNode;
        block51: {
            Object object4;
            CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
            DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
            shapeNode = new ShapeNode();
            String string2 = element.getAttributeNS(null, "transform");
            if (string2.length() > 0) {
                object4 = SVGUtilities.convertAffineTransform(string2);
                shapeNode.setTransform((AffineTransform)object4);
            }
            object4 = element.getAttributeNS(null, "startOffset");
            f2 = UnitProcessor.svgToUserSpace((String)object4, (SVGElement)element, (short)2, defaultUnitProcessorContext);
            object4 = element.getAttributeNS(null, "textLength");
            bl = true;
            f = UnitProcessor.svgToUserSpace((String)object4, (SVGElement)element, (short)2, defaultUnitProcessorContext);
            if (f == 0.0f) {
                bl = false;
            }
            object4 = element.getAttributeNS(null, "method");
            n2 = 0;
            if (((String)object4).equals("align")) {
                n2 = 0;
            } else if (((String)object4).equals("stretch")) {
                n2 = 1;
            }
            element.normalize();
            string = element.getFirstChild().getNodeValue();
            String string3 = XMLSupport.getXMLSpace(element);
            string = string3.equals("preserve") ? XMLSupport.preserveXMLSpace(string) : XMLSupport.defaultXMLSpace(string);
            string = string.length() == 0 ? " " : string;
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
            float f3 = CSSUtilities.convertFontSize((SVGElement)element, bridgeContext, cSSStyleDeclaration, defaultUnitProcessorContext);
            f3 = (float)((double)f3 * 0.92);
            hashMap.put(TextAttribute.SIZE, new Float(f3));
            CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("text-anchor");
            object4 = cSSPrimitiveValue.getStringValue();
            switch (((String)object4).charAt(0)) {
                case 's': {
                    n = 0;
                    break;
                }
                case 'm': {
                    n = 1;
                    break;
                }
                default: {
                    n = 2;
                }
            }
            CSSValueList cSSValueList = (CSSValueList)cSSStyleDeclaration.getPropertyCSSValue("font-family");
            object4 = null;
            int n3 = 0;
            while (object4 == null && n3 < cSSValueList.getLength()) {
                cSSPrimitiveValue = (CSSPrimitiveValue)cSSValueList.item(n3);
                object4 = (String)fonts.get(cSSPrimitiveValue.getStringValue());
                ++n3;
            }
            object4 = object4 == null ? "SansSerif" : object4;
            hashMap.put(TextAttribute.FAMILY, object4);
            cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("font-weight");
            if (cSSPrimitiveValue.getPrimitiveType() == 21) {
                if (cSSPrimitiveValue.getStringValue().charAt(0) == 'n') {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
                } else {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                }
            } else {
                switch ((int)cSSPrimitiveValue.getFloatValue((short)1)) {
                    case 100: {
                        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT);
                        break;
                    }
                    case 200: {
                        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
                        break;
                    }
                    case 300: {
                        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMILIGHT);
                        break;
                    }
                    case 400: {
                        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
                        break;
                    }
                    case 500: {
                        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_SEMIBOLD);
                        break;
                    }
                    case 600: {
                        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMIBOLD);
                        break;
                    }
                    case 700: {
                        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                        break;
                    }
                    case 800: {
                        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                        break;
                    }
                    case 900: {
                        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    }
                }
            }
            cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("font-style");
            object4 = cSSPrimitiveValue.getStringValue();
            switch (((String)object4).charAt(0)) {
                case 'n': {
                    hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
                    break;
                }
                case 'i': 
                case 'o': {
                    hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                }
            }
            cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("font-stretch");
            object4 = cSSPrimitiveValue.getStringValue();
            switch (((String)object4).charAt(0)) {
                case 'u': {
                    if (((String)object4).charAt(6) == 'c') {
                        hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                        break;
                    }
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                    break;
                }
                case 'e': {
                    if (((String)object4).charAt(6) == 'c') {
                        hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                        break;
                    }
                    if (((String)object4).length() == 8) {
                        hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
                        break;
                    }
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                    break;
                }
                case 's': {
                    if (((String)object4).charAt(6) == 'c') {
                        hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED);
                        break;
                    }
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
                    break;
                }
                default: {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_REGULAR);
                }
            }
            CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("text-decoration");
            short s = cSSValue.getCssValueType();
            if (s == 2) {
                object3 = (CSSValueList)cSSValue;
                int n4 = 0;
                while (n4 < object3.getLength()) {
                    cSSPrimitiveValue = (CSSPrimitiveValue)object3.item(n4);
                    object4 = cSSPrimitiveValue.getStringValue();
                    switch (((String)object4).charAt(0)) {
                        case 'u': {
                            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                            break;
                        }
                        case 'o': {
                            break;
                        }
                        case 'l': {
                            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                        }
                    }
                    ++n4;
                }
            }
            object3 = new Font(hashMap);
            URIResolver uRIResolver = new URIResolver((SVGDocument)element.getOwnerDocument(), bridgeContext.getDocumentLoader());
            String string4 = XLinkSupport.getXLinkHref(element);
            shape = null;
            try {
                object2 = uRIResolver.getNode(string4);
                if (object2.getOwnerDocument() == null) {
                    throw new Error("Can't use documents");
                }
                object = (Element)object2;
                boolean bl2 = object2.getOwnerDocument() == element.getOwnerDocument();
                Element element2 = null;
                element2 = bl2 ? (Element)object.cloneNode(true) : (Element)element.getOwnerDocument().importNode((Node)object, true);
                if (element2 == null) break block51;
                String string5 = element2.getAttributeNS(null, "d");
                try {
                    shape = AWTPathProducer.createShape(new StringReader(string5), 1);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.getMessage());
                }
            }
            catch (Exception exception) {
                System.out.println("bad url " + string4);
                exception.printStackTrace();
            }
        }
        object2 = ((Font)object3).createGlyphVector(new FontRenderContext(null, true, true), new String(string));
        object = null;
        if (!bl) {
            f = (float)((GlyphVector)object2).getVisualBounds().getWidth();
        }
        object = TextPathLayout.layoutGlyphVector((GlyphVector)object2, shape, n, f2, f, n2);
        shapeNode.setShape((Shape)object);
        shapeNode.setVisible(CSSUtilities.convertVisibility(element));
        return shapeNode;
    }

    public void buildGraphicsNode(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element) {
        ShapeNode shapeNode = (ShapeNode)graphicsNode;
        SVGElement sVGElement = (SVGElement)element;
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        ShapePainter shapePainter = CSSUtilities.convertStrokeAndFill(shapeNode.getShape(), sVGElement, shapeNode, bridgeContext, cSSStyleDeclaration, defaultUnitProcessorContext);
        shapeNode.setShapePainter(shapePainter);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("opacity");
        Composite composite = CSSUtilities.convertOpacityToComposite(cSSPrimitiveValue);
        shapeNode.setComposite(composite);
        Filter filter = CSSUtilities.convertFilter(element, shapeNode, bridgeContext);
        shapeNode.setFilter(filter);
        Mask mask = CSSUtilities.convertMask(element, shapeNode, bridgeContext);
        shapeNode.setMask(mask);
        Clip clip = CSSUtilities.convertClipPath(element, shapeNode, bridgeContext);
        shapeNode.setClip(clip);
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }

    public boolean isContainer() {
        return false;
    }

    static {
        fonts.put("serif", "Serif");
        fonts.put("Times", "Serif");
        fonts.put("Times New Roman", "Serif");
        fonts.put("Garamond", "Serif");
        fonts.put("sans-serif", "SansSerif");
        fonts.put("Arial", "SansSerif");
        fonts.put("Helvetica", "SansSerif");
        fonts.put("Verdana", "SansSerif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("Courier", "Monospaced");
        fonts.put("Courier New", "Monospaced");
    }
}

