/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import org.apache.batik.ext.awt.image.renderable.ComponentTransferFunction;

public class ConcreteComponentTransferFunction
implements ComponentTransferFunction {
    private int type;
    private float slope;
    private float[] tableValues;
    private float intercept;
    private float amplitude;
    private float exponent;
    private float offset;

    private ConcreteComponentTransferFunction() {
    }

    public static ComponentTransferFunction getIdentityTransfer() {
        ConcreteComponentTransferFunction concreteComponentTransferFunction = new ConcreteComponentTransferFunction();
        concreteComponentTransferFunction.type = 0;
        return concreteComponentTransferFunction;
    }

    public static ComponentTransferFunction getTableTransfer(float[] fArray) {
        ConcreteComponentTransferFunction concreteComponentTransferFunction = new ConcreteComponentTransferFunction();
        concreteComponentTransferFunction.type = 1;
        if (fArray == null) {
            throw new IllegalArgumentException();
        }
        if (fArray.length < 2) {
            throw new IllegalArgumentException();
        }
        concreteComponentTransferFunction.tableValues = new float[fArray.length];
        System.arraycopy(fArray, 0, concreteComponentTransferFunction.tableValues, 0, fArray.length);
        return concreteComponentTransferFunction;
    }

    public static ComponentTransferFunction getDiscreteTransfer(float[] fArray) {
        ConcreteComponentTransferFunction concreteComponentTransferFunction = new ConcreteComponentTransferFunction();
        concreteComponentTransferFunction.type = 2;
        if (fArray == null) {
            throw new IllegalArgumentException();
        }
        if (fArray.length < 2) {
            throw new IllegalArgumentException();
        }
        concreteComponentTransferFunction.tableValues = new float[fArray.length];
        System.arraycopy(fArray, 0, concreteComponentTransferFunction.tableValues, 0, fArray.length);
        return concreteComponentTransferFunction;
    }

    public static ComponentTransferFunction getLinearTransfer(float f, float f2) {
        ConcreteComponentTransferFunction concreteComponentTransferFunction = new ConcreteComponentTransferFunction();
        concreteComponentTransferFunction.type = 3;
        concreteComponentTransferFunction.slope = f;
        concreteComponentTransferFunction.intercept = f2;
        return concreteComponentTransferFunction;
    }

    public static ComponentTransferFunction getGammaTransfer(float f, float f2, float f3) {
        ConcreteComponentTransferFunction concreteComponentTransferFunction = new ConcreteComponentTransferFunction();
        concreteComponentTransferFunction.type = 4;
        concreteComponentTransferFunction.amplitude = f;
        concreteComponentTransferFunction.exponent = f2;
        concreteComponentTransferFunction.offset = f3;
        return concreteComponentTransferFunction;
    }

    public int getType() {
        return this.type;
    }

    public float getSlope() {
        return this.slope;
    }

    public float[] getTableValues() {
        return this.tableValues;
    }

    public float getIntercept() {
        return this.intercept;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public float getExponent() {
        return this.exponent;
    }

    public float getOffset() {
        return this.offset;
    }
}

