/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.image.renderable.AffineRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.PatternPaintContext;
import org.apache.batik.gvt.filter.GraphicsNodeRable8Bit;

public class PatternPaint
implements Paint {
    private GraphicsNode node;
    private GraphicsNodeRenderContext gnrc;
    private Rectangle2D patternRegion;
    private AffineTransform patternTransform;
    private boolean overflow;
    private Filter tile;

    public PatternPaint(GraphicsNode graphicsNode, GraphicsNodeRenderContext graphicsNodeRenderContext, AffineTransform affineTransform, Rectangle2D rectangle2D, boolean bl, AffineTransform affineTransform2) {
        if (graphicsNode == null) {
            throw new IllegalArgumentException();
        }
        if (rectangle2D == null) {
            throw new IllegalArgumentException();
        }
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        this.node = graphicsNode;
        this.gnrc = graphicsNodeRenderContext;
        this.patternRegion = rectangle2D;
        this.overflow = bl;
        this.patternTransform = affineTransform2;
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.translate(rectangle2D.getX(), rectangle2D.getY());
        affineTransform3.concatenate(affineTransform);
        GraphicsNodeRable8Bit graphicsNodeRable8Bit = new GraphicsNodeRable8Bit(graphicsNode, graphicsNodeRenderContext);
        AffineRable8Bit affineRable8Bit = new AffineRable8Bit((Filter)graphicsNodeRable8Bit, affineTransform3);
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        if (bl) {
            Rectangle2D rectangle2D3 = graphicsNode.getBounds(graphicsNodeRenderContext);
            Rectangle2D rectangle2D4 = affineTransform3.createTransformedShape(rectangle2D3).getBounds2D();
            rectangle2D2.add(rectangle2D4);
        }
        this.tile = new PadRable8Bit(affineRable8Bit, rectangle2D2, PadMode.ZERO_PAD);
    }

    public GraphicsNode getGraphicsNode() {
        return this.node;
    }

    public Rectangle2D getPatternRect() {
        return (Rectangle2D)this.patternRegion.clone();
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public AffineTransform getPatternTransform() {
        return this.patternTransform;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (this.patternTransform != null) {
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.concatenate(this.patternTransform);
            try {
                AffineTransform affineTransform2 = this.patternTransform.createInverse();
                rectangle2D = affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return new PatternPaintContext(colorModel, affineTransform, renderingHints, this.tile, this.patternRegion, rectangle2D, this.overflow);
    }

    public int getTransparency() {
        return 3;
    }
}

