/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Rectangle;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import org.apache.batik.svggen.AbstractSVGFilterConverter;
import org.apache.batik.svggen.SVGFilterDescriptor;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGConvolveOp
extends AbstractSVGFilterConverter {
    public SVGConvolveOp(Document document) {
        super(document);
    }

    public SVGFilterDescriptor toSVG(BufferedImageOp bufferedImageOp, Rectangle rectangle) {
        if (bufferedImageOp instanceof ConvolveOp) {
            return this.toSVG((ConvolveOp)bufferedImageOp);
        }
        return null;
    }

    public SVGFilterDescriptor toSVG(ConvolveOp convolveOp) {
        SVGFilterDescriptor sVGFilterDescriptor = (SVGFilterDescriptor)this.descMap.get(convolveOp);
        if (sVGFilterDescriptor == null) {
            Kernel kernel = convolveOp.getKernel();
            Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "filter");
            Element element2 = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "feConvolveMatrix");
            element2.setAttributeNS(null, "order", kernel.getWidth() + " " + kernel.getHeight());
            StringBuffer stringBuffer = new StringBuffer();
            float[] fArray = kernel.getKernelData(null);
            int n = 0;
            while (n < fArray.length) {
                stringBuffer.append(AbstractSVGFilterConverter.doubleString(fArray[n]));
                stringBuffer.append(" ");
                ++n;
            }
            element2.setAttributeNS(null, "kernelMatrix", stringBuffer.toString().trim());
            element.appendChild(element2);
            element.setAttributeNS(null, "id", SVGIDGenerator.generateID("convolve"));
            if (convolveOp.getEdgeCondition() == 1) {
                element2.setAttributeNS(null, "edgeMode", "duplicate");
            } else {
                element2.setAttributeNS(null, "edgeMode", "none");
            }
            StringBuffer stringBuffer2 = new StringBuffer("url(");
            stringBuffer2.append("#");
            stringBuffer2.append(element.getAttributeNS(null, "id"));
            stringBuffer2.append(")");
            sVGFilterDescriptor = new SVGFilterDescriptor(stringBuffer2.toString(), element);
            this.defSet.add(element);
            this.descMap.put(convolveOp, sVGFilterDescriptor);
        }
        return sVGFilterDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        Element element;
        Object object;
        Document document = TestUtil.getDocumentPrototype();
        Kernel kernel = new Kernel(5, 3, new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f});
        ConvolveOp[] convolveOpArray = new ConvolveOp[]{new ConvolveOp(kernel), new ConvolveOp(kernel, 1, null), new ConvolveOp(kernel, 0, null)};
        SVGConvolveOp sVGConvolveOp = new SVGConvolveOp(document);
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < convolveOpArray.length) {
            SVGFilterDescriptor sVGFilterDescriptor = sVGConvolveOp.toSVG(convolveOpArray[n]);
            object = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            object.setAttributeNS(null, "filter", sVGFilterDescriptor.getFilterValue());
            element4.appendChild((Node)object);
            ++n;
        }
        int n2 = 0;
        while (n2 < convolveOpArray.length) {
            object = sVGConvolveOp.toSVG(convolveOpArray[n2]);
            element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            element.setAttributeNS(null, "filter", ((SVGFilterDescriptor)object).getFilterValue());
            element5.appendChild(element);
            ++n2;
        }
        object = sVGConvolveOp.getDefinitionSet().iterator();
        while (object.hasNext()) {
            element = (Element)object.next();
            element3.appendChild(element);
        }
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        TestUtil.trace(element2, System.out);
    }
}

