/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class CharacterEncoder {
    protected PrintStream pStream;

    abstract int bytesPerAtom();

    abstract int bytesPerLine();

    void encodeBufferPrefix(OutputStream outputStream) {
        this.pStream = new PrintStream(outputStream);
    }

    void encodeBufferSuffix(OutputStream outputStream) {
    }

    void encodeLinePrefix(OutputStream outputStream, int n) {
    }

    void encodeLineSuffix(OutputStream outputStream) {
        this.pStream.println();
    }

    abstract void encodeAtom(OutputStream var1, byte[] var2, int var3, int var4) throws IOException;

    public void encodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        while ((n = inputStream.read(byArray)) != -1) {
            this.encodeLinePrefix(outputStream, n);
            int n2 = 0;
            while (n2 < n) {
                if (n2 + this.bytesPerAtom() <= n) {
                    this.encodeAtom(outputStream, byArray, n2, this.bytesPerAtom());
                } else {
                    this.encodeAtom(outputStream, byArray, n2, byArray.length - n2);
                }
                n2 += this.bytesPerAtom();
            }
            this.encodeLineSuffix(outputStream);
            if (n >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix(outputStream);
    }

    public void encodeBuffer(byte[] byArray, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.encodeBuffer(byteArrayInputStream, outputStream);
    }

    public String encodeBuffer(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.encodeBuffer(byteArrayInputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }
}

