/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;

public class DOMViewer
extends JFrame
implements ActionMap {
    protected static final String RESOURCE = "org.apache.batik.util.gui.resources.DOMViewerMessages";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.util.gui.resources.DOMViewerMessages", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected Map listeners = new HashMap();
    protected Panel panel = new Panel();

    public DOMViewer() {
        super(resources.getString("Frame.title"));
        ((Component)this).setSize(resources.getInteger("Frame.width"), resources.getInteger("Frame.height"));
        this.listeners.put("CloseButtonAction", new CloseButtonAction());
        this.getContentPane().add(this.panel);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        ButtonFactory buttonFactory = new ButtonFactory(bundle, this);
        jPanel.add(buttonFactory.createJButton("CloseButton"));
        this.getContentPane().add("South", jPanel);
    }

    public void setDocument(Document document) {
        this.panel.setDocument(document);
    }

    public void setDocument(Document document, ViewCSS viewCSS) {
        this.panel.setDocument(document, viewCSS);
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    public static class Panel
    extends JPanel {
        protected Document document;
        protected ViewCSS viewCSS;
        protected JTree tree;
        protected JSplitPane splitPane;
        protected JPanel rightPanel = new JPanel(new BorderLayout());
        protected JTable attributesTable = new JTable();
        protected JTable propertiesTable = new JTable();
        protected JPanel elementPanel = new JPanel(new GridLayout(2, 1));
        protected JTextArea characterData;
        protected JPanel characterDataPanel;
        protected JTextArea documentInfo;
        protected JPanel documentInfoPanel;

        public Panel() {
            super(new BorderLayout());
            Serializable serializable = new JScrollPane();
            serializable.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("AttributesPanel.title")), BorderFactory.createLoweredBevelBorder())));
            serializable.getViewport().add(this.attributesTable);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("CSSValuesPanel.title")), BorderFactory.createLoweredBevelBorder())));
            jScrollPane.getViewport().add(this.propertiesTable);
            this.elementPanel.add((Component)serializable);
            this.elementPanel.add(jScrollPane);
            this.characterData = new JTextArea();
            this.characterDataPanel = new JPanel(new BorderLayout());
            this.characterDataPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("CDataPanel.title")), BorderFactory.createLoweredBevelBorder())));
            serializable = new JScrollPane();
            serializable.getViewport().add(this.characterData);
            this.characterDataPanel.add((Component)serializable);
            this.characterData.setEditable(false);
            this.documentInfo = new JTextArea();
            this.documentInfoPanel = new JPanel(new BorderLayout());
            this.documentInfoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("DocumentInfoPanel.title")), BorderFactory.createLoweredBevelBorder())));
            serializable = new JScrollPane();
            serializable.getViewport().add(this.documentInfo);
            this.documentInfoPanel.add((Component)serializable);
            this.documentInfo.setEditable(false);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("DOMViewerPanel.title")));
            serializable = new DefaultMutableTreeNode(resources.getString("EmptyDocument.text"));
            this.tree = new JTree((TreeNode)((Object)serializable));
            this.tree.setCellRenderer(new NodeRenderer());
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
            jScrollPane = new JScrollPane();
            jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("DOMViewer.title")), BorderFactory.createLoweredBevelBorder())));
            jScrollPane.getViewport().add(this.tree);
            this.splitPane = new JSplitPane(1, true, jScrollPane, this.rightPanel);
            int n = resources.getInteger("SplitPane.dividerLocation");
            this.splitPane.setDividerLocation(n);
            this.add(this.splitPane);
            this.tree.addTreeSelectionListener(new DOMTreeSelectionListener());
        }

        public void setDocument(Document document) {
            this.setDocument(document, null);
        }

        public void setDocument(Document document, ViewCSS viewCSS) {
            this.document = document;
            this.viewCSS = viewCSS;
            MutableTreeNode mutableTreeNode = Panel.createTree(document);
            ((DefaultTreeModel)this.tree.getModel()).setRoot(mutableTreeNode);
            if (this.rightPanel.getComponentCount() != 0) {
                this.rightPanel.remove(0);
                this.splitPane.revalidate();
                this.splitPane.repaint();
            }
        }

        protected static MutableTreeNode createTree(Node node) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new NodeInfo(node));
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                defaultMutableTreeNode.add(Panel.createTree(node2));
                node2 = node2.getNextSibling();
            }
            return defaultMutableTreeNode;
        }

        protected static class NodeInfo {
            protected Node node;

            public NodeInfo(Node node) {
                this.node = node;
            }

            public Node getNode() {
                return this.node;
            }

            public String toString() {
                return this.node.getNodeName();
            }
        }

        protected class NodeCSSValuesModel
        extends AbstractTableModel {
            protected Node node;
            protected CSSStyleDeclaration style;
            protected List propertyNames;

            public NodeCSSValuesModel(Node node) {
                this.node = node;
                if (Panel.this.viewCSS != null) {
                    this.style = Panel.this.viewCSS.getComputedStyle((Element)node, null);
                    this.propertyNames = new ArrayList();
                    int n = 0;
                    while (n < this.style.getLength()) {
                        this.propertyNames.add(this.style.item(n));
                        ++n;
                    }
                    Collections.sort(this.propertyNames);
                }
            }

            public String getColumnName(int n) {
                if (n == 0) {
                    return resources.getString("CSSValuesTable.column1");
                }
                return resources.getString("CSSValuesTable.column2");
            }

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                if (this.style == null) {
                    return 0;
                }
                return this.style.getLength();
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public Object getValueAt(int n, int n2) {
                String string = (String)this.propertyNames.get(n);
                if (n2 == 0) {
                    return string;
                }
                return this.style.getPropertyValue(string);
            }
        }

        protected class NodeAttributesModel
        extends AbstractTableModel {
            protected Node node;

            public NodeAttributesModel(Node node) {
                this.node = node;
            }

            public String getColumnName(int n) {
                if (n == 0) {
                    return resources.getString("AttributesTable.column1");
                }
                return resources.getString("AttributesTable.column2");
            }

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return this.node.getAttributes().getLength();
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public Object getValueAt(int n, int n2) {
                NamedNodeMap namedNodeMap = this.node.getAttributes();
                Node node = namedNodeMap.item(n);
                if (n2 == 0) {
                    return node.getNodeName();
                }
                return node.getNodeValue();
            }
        }

        protected class NodeRenderer
        extends DefaultTreeCellRenderer {
            ImageIcon elementIcon;
            ImageIcon commentIcon;
            ImageIcon piIcon;
            ImageIcon textIcon;

            public NodeRenderer() {
                String string = resources.getString("Element.icon");
                this.elementIcon = new ImageIcon(this.getClass().getResource(string));
                string = resources.getString("Comment.icon");
                this.commentIcon = new ImageIcon(this.getClass().getResource(string));
                string = resources.getString("PI.icon");
                this.piIcon = new ImageIcon(this.getClass().getResource(string));
                string = resources.getString("Text.icon");
                this.textIcon = new ImageIcon(this.getClass().getResource(string));
            }

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                switch (this.getNodeType(object)) {
                    case 1: {
                        this.setIcon(this.elementIcon);
                        break;
                    }
                    case 8: {
                        this.setIcon(this.commentIcon);
                        break;
                    }
                    case 7: {
                        this.setIcon(this.piIcon);
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.setIcon(this.textIcon);
                    }
                }
                return this;
            }

            protected short getNodeType(Object object) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                Object object2 = defaultMutableTreeNode.getUserObject();
                if (object2 instanceof NodeInfo) {
                    Node node = ((NodeInfo)object2).getNode();
                    return node.getNodeType();
                }
                return -1;
            }
        }

        protected class DOMTreeSelectionListener
        implements TreeSelectionListener {
            protected DOMTreeSelectionListener() {
            }

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)Panel.this.tree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                if (Panel.this.rightPanel.getComponentCount() != 0) {
                    Panel.this.rightPanel.remove(0);
                }
                if ((object = defaultMutableTreeNode.getUserObject()) instanceof NodeInfo) {
                    Node node = ((NodeInfo)object).getNode();
                    switch (node.getNodeType()) {
                        case 9: {
                            Panel.this.documentInfo.setText(this.createDocumentText((Document)node));
                            Panel.this.rightPanel.add(Panel.this.documentInfoPanel);
                            break;
                        }
                        case 1: {
                            Panel.this.attributesTable.setModel(new NodeAttributesModel(node));
                            Panel.this.propertiesTable.setModel(new NodeCSSValuesModel(node));
                            Panel.this.rightPanel.add(Panel.this.elementPanel);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 8: {
                            Panel.this.characterData.setText(node.getNodeValue());
                            Panel.this.rightPanel.add(Panel.this.characterDataPanel);
                        }
                    }
                }
                Panel.this.splitPane.revalidate();
                Panel.this.splitPane.repaint();
            }

            protected String createDocumentText(Document document) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Nodes: ");
                stringBuffer.append(this.nodeCount(document));
                return stringBuffer.toString();
            }

            protected int nodeCount(Node node) {
                int n = 1;
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    n += this.nodeCount(node2);
                    node2 = node2.getNextSibling();
                }
                return n;
            }
        }
    }

    protected class CloseButtonAction
    extends AbstractAction {
        protected CloseButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DOMViewer.this.dispose();
        }
    }
}

