/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class Cab
extends MatchingTask {
    private File cabFile;
    private File baseDir;
    private Vector filesets = new Vector();
    private boolean doCompress = true;
    private boolean doVerbose = false;
    private String cmdOptions;
    protected String archiveType = "cab";
    private static String myos = System.getProperty("os.name");
    private static boolean isWindows = myos.toLowerCase().indexOf("windows") >= 0;
    private static int counter = new Random().nextInt() % 100000;

    public void setCabfile(File file) {
        this.cabFile = file;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setCompress(boolean bl) {
        this.doCompress = bl;
    }

    public void setVerbose(boolean bl) {
        this.doVerbose = bl;
    }

    public void setOptions(String string) {
        this.cmdOptions = string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    protected void checkConfiguration() throws BuildException {
        if (this.baseDir == null) {
            throw new BuildException("basedir attribute must be set!");
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("basedir does not exist!");
        }
        if (this.cabFile == null) {
            throw new BuildException("cabfile attribute must be set!");
        }
    }

    protected ExecTask createExec() throws BuildException {
        ExecTask execTask = (ExecTask)((Task)this).project.createTask("exec");
        execTask.setOwningTarget(this.getOwningTarget());
        execTask.setTaskName(this.getTaskName());
        execTask.setDescription(this.getDescription());
        return execTask;
    }

    protected boolean isUpToDate(Vector vector) {
        boolean bl = true;
        int n = 0;
        while (n < vector.size() && bl) {
            String string = vector.elementAt(n).toString();
            if (new File(this.baseDir, string).lastModified() > this.cabFile.lastModified()) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    protected Commandline createCommand(File file) {
        Commandline commandline = new Commandline();
        commandline.setExecutable("cabarc");
        commandline.createArgument().setValue("-r");
        commandline.createArgument().setValue("-p");
        if (!this.doCompress) {
            commandline.createArgument().setValue("-m");
            commandline.createArgument().setValue("none");
        }
        if (this.cmdOptions != null) {
            commandline.createArgument().setValue(this.cmdOptions);
        }
        commandline.createArgument().setValue("n");
        commandline.createArgument().setFile(this.cabFile);
        commandline.createArgument().setValue("@" + file.getAbsolutePath());
        return commandline;
    }

    protected File createTempFile(String string, String string2) {
        if (string2 == null) {
            string2 = ".tmp";
        }
        String string3 = string + new DecimalFormat("#####").format(new Integer(counter++)) + string2;
        String string4 = System.getProperty("java.io.tmpdir");
        if (string4 == null) {
            return new File(string3);
        }
        return new File(string4, string3);
    }

    protected File createListFile(Vector vector) throws IOException {
        File file = this.createTempFile("ant", null);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        int n = 0;
        while (n < vector.size()) {
            printWriter.println(vector.elementAt(n).toString());
            ++n;
        }
        printWriter.close();
        return file;
    }

    protected void appendFiles(Vector vector, DirectoryScanner directoryScanner) {
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
    }

    protected Vector getFileList() throws BuildException {
        Vector vector = new Vector();
        if (this.filesets.size() == 0) {
            this.appendFiles(vector, super.getDirectoryScanner(this.baseDir));
        } else {
            int n = 0;
            while (n < this.filesets.size()) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(n);
                if (fileSet != null) {
                    this.appendFiles(vector, fileSet.getDirectoryScanner(((Task)this).project));
                }
                ++n;
            }
        }
        return vector;
    }

    public void execute() throws BuildException {
        this.checkConfiguration();
        Vector vector = this.getFileList();
        if (this.isUpToDate(vector)) {
            return;
        }
        this.log("Building " + this.archiveType + ": " + this.cabFile.getAbsolutePath());
        if (!isWindows) {
            this.log("Using listcab/libcabinet", 3);
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(enumeration.nextElement()).append("\n");
            }
            stringBuffer.append("\n").append(this.cabFile.getAbsolutePath()).append("\n");
            try {
                Process process = Runtime.getRuntime().exec("listcab");
                OutputStream outputStream = process.getOutputStream();
                outputStream.write(stringBuffer.toString().getBytes());
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                String string = "Problem creating " + this.cabFile + " " + iOException.getMessage();
                throw new BuildException(string);
            }
        }
        try {
            File file = this.createListFile(vector);
            ExecTask execTask = this.createExec();
            File file2 = null;
            execTask.setFailonerror(true);
            execTask.setDir(this.baseDir);
            if (!this.doVerbose) {
                file2 = this.createTempFile("ant", null);
                execTask.setOutput(file2);
            }
            execTask.setCommand(this.createCommand(file));
            execTask.execute();
            if (file2 != null) {
                file2.delete();
            }
            file.delete();
        }
        catch (IOException iOException) {
            String string = "Problem creating " + this.cabFile + " " + iOException.getMessage();
            throw new BuildException(string);
        }
    }
}

