/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.EntityDescriptor;
import weblogic.ejbc;

public class EjbcHelper {
    private File descriptorDirectory;
    private File generatedFilesDirectory;
    private File manifestFile;
    private String classpath;
    private File sourceDirectory;
    String[] descriptors;
    private boolean keepGenerated;

    public static void main(String[] stringArray) throws Exception {
        EjbcHelper ejbcHelper = new EjbcHelper(stringArray);
        ejbcHelper.process();
    }

    private EjbcHelper(String[] stringArray) {
        int n = 0;
        this.descriptorDirectory = new File(stringArray[n++]);
        this.generatedFilesDirectory = new File(stringArray[n++]);
        this.sourceDirectory = new File(stringArray[n++]);
        this.manifestFile = new File(stringArray[n++]);
        this.keepGenerated = Boolean.valueOf(stringArray[n++]);
        this.descriptors = new String[stringArray.length - n];
        int n2 = 0;
        while (n < stringArray.length) {
            this.descriptors[n2] = stringArray[n++];
            ++n2;
        }
    }

    private String[] getCommandLine(boolean bl, File file) {
        Vector<String> vector = new Vector<String>();
        if (!bl) {
            vector.add("-noexit");
        }
        if (this.keepGenerated) {
            vector.add("-keepgenerated");
        }
        vector.add("-d");
        vector.add(this.generatedFilesDirectory.getPath());
        vector.add(file.getPath());
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRegenRequired(File file) throws IOException {
        FileInputStream fileInputStream;
        block13: {
            boolean bl;
            block14: {
                boolean bl2;
                block12: {
                    boolean bl3;
                    block11: {
                        fileInputStream = null;
                        try {
                            try {
                                fileInputStream = new FileInputStream(file);
                                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                                DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)objectInputStream.readObject();
                                fileInputStream.close();
                                String string = deploymentDescriptor.getHomeInterfaceClassName().replace('.', '/') + ".java";
                                String string2 = deploymentDescriptor.getRemoteInterfaceClassName().replace('.', '/') + ".java";
                                String string3 = null;
                                if (deploymentDescriptor instanceof EntityDescriptor) {
                                    string3 = ((EntityDescriptor)deploymentDescriptor).getPrimaryKeyClassName().replace('.', '/') + ".java";
                                }
                                File file2 = new File(this.sourceDirectory, string);
                                File file3 = new File(this.sourceDirectory, string2);
                                File file4 = null;
                                if (string3 != null) {
                                    file4 = new File(this.sourceDirectory, string2);
                                }
                                String string4 = deploymentDescriptor.getEnterpriseBeanClassName().replace('.', '/');
                                File file5 = new File(this.generatedFilesDirectory, string4 + "EOImpl.class");
                                File file6 = new File(this.generatedFilesDirectory, string4 + "HomeImpl.class");
                                File file7 = new File(this.generatedFilesDirectory, string4 + "EOImpl_WLStub.class");
                                if (!(file5.exists() && file6.exists() && file7.exists())) {
                                    bl3 = true;
                                    Object var19_19 = null;
                                    if (fileInputStream == null) return bl3;
                                    break block11;
                                }
                                long l = file5.lastModified();
                                if (file6.lastModified() < l) {
                                    l = file6.lastModified();
                                }
                                if (file7.lastModified() < l) {
                                    l = file7.lastModified();
                                }
                                if (file.lastModified() > l || file2.lastModified() > l || file3.lastModified() > l) {
                                    bl2 = true;
                                    break block12;
                                }
                                if (file4 == null || file4.lastModified() <= l) break block13;
                                bl = true;
                                break block14;
                            }
                            catch (Throwable throwable) {
                                System.out.println("Exception occurred reading " + file.getName() + " - continuing");
                                boolean bl4 = true;
                                Object var19_23 = null;
                                if (fileInputStream == null) return bl4;
                                fileInputStream.close();
                                return bl4;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var19_24 = null;
                            if (fileInputStream == null) throw throwable;
                            fileInputStream.close();
                            throw throwable;
                        }
                    }
                    fileInputStream.close();
                    return bl3;
                }
                Object var19_20 = null;
                if (fileInputStream == null) return bl2;
                fileInputStream.close();
                return bl2;
            }
            Object var19_21 = null;
            if (fileInputStream == null) return bl;
            fileInputStream.close();
            return bl;
        }
        Object var19_22 = null;
        if (fileInputStream == null) return false;
        fileInputStream.close();
        return false;
    }

    private void process() throws Exception {
        Object object;
        Object object2;
        String string = "Manifest-Version: 1.0\n\n";
        int n = 0;
        while (n < this.descriptors.length) {
            object2 = this.descriptors[n];
            object = new File(this.descriptorDirectory, (String)object2);
            if (this.isRegenRequired((File)object)) {
                System.out.println("Running ejbc for " + ((File)object).getName());
                this.regenerateSupportClasses((File)object);
            } else {
                System.out.println(((File)object).getName() + " is up to date");
            }
            string = string + "Name: " + ((String)object2).replace('\\', '/') + "\nEnterprise-Bean: True\n\n";
            ++n;
        }
        object2 = new FileWriter(this.manifestFile);
        object = new PrintWriter((Writer)object2);
        ((PrintWriter)object).print(string);
        ((OutputStreamWriter)object2).flush();
        ((OutputStreamWriter)object2).close();
    }

    private void regenerateSupportClasses(File file) throws Exception {
        String[] stringArray = this.getCommandLine(false, file);
        try {
            ejbc.main((String[])stringArray);
        }
        catch (Exception exception) {
            String[] stringArray2 = this.getCommandLine(true, file);
            ejbc.main((String[])stringArray2);
        }
    }
}

