/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.directive.VelocimacroProxy;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;

public class VelocimacroManager {
    private static String GLOBAL_NAMESPACE = "";
    private Hashtable namespaceHash = new Hashtable();
    private boolean namespacesOn = true;
    private boolean inlineLocalMode = false;

    VelocimacroManager() {
        this.addNamespace(GLOBAL_NAMESPACE);
    }

    public boolean addVM(String vmName, String macroBody, String[] argArray, String namespace) {
        MacroEntry me = new MacroEntry(this, vmName, macroBody, argArray, namespace);
        if (this.usingNamespaces(namespace)) {
            Hashtable local = this.getNamespace(namespace, true);
            local.put(vmName, me);
            return true;
        }
        this.getNamespace(GLOBAL_NAMESPACE).put(vmName, me);
        return true;
    }

    public VelocimacroProxy get(String vmName, String namespace) {
        MacroEntry me;
        Hashtable local;
        if (this.usingNamespaces(namespace) && (local = this.getNamespace(namespace, false)) != null && (me = (MacroEntry)local.get(vmName)) != null) {
            return me.createVelocimacro();
        }
        MacroEntry me2 = (MacroEntry)this.getNamespace(GLOBAL_NAMESPACE).get(vmName);
        if (me2 != null) {
            return me2.createVelocimacro();
        }
        return null;
    }

    public boolean dumpNamespace(String namespace) {
        VelocimacroManager velocimacroManager = this;
        synchronized (velocimacroManager) {
            if (this.usingNamespaces(namespace)) {
                Hashtable h = (Hashtable)this.namespaceHash.remove(namespace);
                if (h == null) {
                    boolean bl = false;
                    return bl;
                }
                h.clear();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public void setNamespaceUsage(boolean b) {
        this.namespacesOn = b;
    }

    public void setTemplateLocalInlineVM(boolean b) {
        this.inlineLocalMode = b;
    }

    private Hashtable getNamespace(String namespace) {
        return this.getNamespace(namespace, false);
    }

    private Hashtable getNamespace(String namespace, boolean addIfNew) {
        Hashtable h = (Hashtable)this.namespaceHash.get(namespace);
        if (h == null && addIfNew) {
            h = this.addNamespace(namespace);
        }
        return h;
    }

    private Hashtable addNamespace(String namespace) {
        Hashtable h = new Hashtable();
        Hashtable oh = this.namespaceHash.put(namespace, h);
        if (oh != null) {
            this.namespaceHash.put(namespace, oh);
            return null;
        }
        return h;
    }

    private boolean usingNamespaces(String namespace) {
        if (!this.namespacesOn) {
            return false;
        }
        return this.inlineLocalMode;
    }

    protected class MacroEntry {
        String macroname;
        String[] argarray;
        String macrobody;
        String sourcetemplate;
        SimpleNode nodeTree = null;
        VelocimacroManager manager = null;

        MacroEntry(VelocimacroManager vmm, String vmName, String macroBody, String[] argArray, String sourceTemplate) {
            this.macroname = vmName;
            this.argarray = argArray;
            this.macrobody = macroBody;
            this.sourcetemplate = sourceTemplate;
            this.manager = vmm;
        }

        public SimpleNode getNodeTree() {
            return this.nodeTree;
        }

        VelocimacroProxy createVelocimacro() {
            VelocimacroProxy vp = new VelocimacroProxy();
            vp.setName(this.macroname);
            vp.setArgArray(this.argarray);
            vp.setMacrobody(this.macrobody);
            vp.setNodeTree(this.nodeTree);
            return vp;
        }

        void setup(InternalContextAdapter ica) {
            if (this.nodeTree == null) {
                this.parseTree(ica);
            }
        }

        void parseTree(InternalContextAdapter ica) {
            try {
                ByteArrayInputStream inStream = new ByteArrayInputStream(this.macrobody.getBytes());
                this.nodeTree = Runtime.parse(inStream, "VM:" + this.macroname);
                this.nodeTree.init(ica, null);
            }
            catch (Exception e) {
                Runtime.error("VelocimacroManager.parseTree() : exception " + this.macroname + " : " + StringUtils.stackTrace(e));
            }
        }
    }
}

