/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.i18n;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;

public class ResourceGroup {
    protected static final Random RANDOM = new Random();
    protected final HashMap m_bundles = new HashMap();
    protected final Locale m_locale;

    public Locale getLocale() {
        return this.m_locale;
    }

    public String format(String string, String string2, Object[] objectArray) {
        String string3 = this.getPattern(string, string2);
        MessageFormat messageFormat = new MessageFormat(string3);
        messageFormat.setLocale(this.m_locale);
        return messageFormat.format(objectArray);
    }

    public ResourceBundle getBundle(String string) throws MissingResourceException {
        ResourceBundle resourceBundle = (ResourceBundle)this.m_bundles.get(string);
        if (resourceBundle != null) {
            return resourceBundle;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        resourceBundle = ResourceBundle.getBundle(string, this.m_locale, classLoader);
        this.m_bundles.put(string, resourceBundle);
        return resourceBundle;
    }

    public String getPattern(String string, String string2) throws MissingResourceException {
        ResourceBundle resourceBundle = this.getBundle(string);
        Object object = resourceBundle.getObject(string2);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            return stringArray[RANDOM.nextInt(stringArray.length)];
        }
        throw new MissingResourceException("Unable to find resource of appropriate type.", "java.lang.String", string2);
    }

    public ResourceGroup(Locale locale) {
        this.m_locale = locale;
    }
}

