/**
 * 
 */
package dguitar.gui;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JToolBar;

import common.ImageToolBar;

import dguitar.gui.midi.MidiInternalFrame;

/**
 * @author Mauricio Gracia G
 *
 */
public class PlayToolBar extends JToolBar 
implements ActionListener 
{
	 SongInternalFrame playingSIF ;
	 MidiInternalFrame playingMIF ;
	 private boolean isSIF ;
	 ImageToolBar buttons ;
	 private PlayPanel playPanel ;
	 private JDesktopPane desktop ;
	 private boolean playing ;
	 
	 /**
	  * Creates a PlayToolBar that can be used to play Midi/SongInternalFrames
	  * 
	  * @param images		the images that are shown in the toolbar
	  * @param aDesktop		a JDesktopPane that contains Midi/SongInternalFrames
	  */
	 public PlayToolBar(Image images[],JDesktopPane aDesktop) {
		 super() ;
		 
		 this.setFloatable(false) ;
		 desktop = aDesktop ;
		 this.buttons = new ImageToolBar() ;
		 this.buttons.setFloatable(false) ;
		 this.buttons.setNumButtons(images.length) ;
		 this.buttons.setImages(images) ;

		 //		Add the PlayPanel to the toolbar
		 this.playPanel = new PlayPanel();
		         
		 this.playPanel.setAlignmentX(Component.LEFT_ALIGNMENT);
		         
		 this.buttons.add(playPanel);
		 
		 this.playingSIF = null ;
		 
		 this.buttons.addActionListener(this) ;
		 
		 this.add(this.buttons) ;
		 
		 playing = false ;
	 }
	 public void setPlaying(boolean flag) {
		 this.playing = flag ;
	 }

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent arg0) {
		JInternalFrame JIF ;
		
		//if a Song is NOT being played
		if(!playing) { 
			JIF = desktop.getSelectedFrame() ;
			
			//if there is currently a selected Frame
			if(JIF != null) {
				//this try-catch duo determine the type of selectedFrame and playIt
				try {
					this.playingSIF = (SongInternalFrame) desktop.getSelectedFrame() ;
					isSIF = true ;
					this.playingSIF.play() ;
					playing = true ;
				} catch (ClassCastException cce) {
					try {
						this.playingMIF = (MidiInternalFrame) desktop.getSelectedFrame() ;
						isSIF = false ;
						this.playingMIF.play() ;
						playing = true ;
					} catch (ClassCastException cce2) {
						//InternalFrame is not playable
					}
				}
				if(playing) {
					this.playPanel.setSongTitle(JIF.getTitle()) ;
				}
			}
		}
//		if a Song is being play
		else {
			if(isSIF) {
				this.playingSIF.stopPlaying() ;
			}
			else {
				this.playingMIF.stopPlaying() ;
			}
			playing = false ;
		}
	}
	/**
	 * @return Returns the playPanel.
	 */
	public PlayPanel getPlayPanel() {
		return playPanel;
	}
}
