/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGOPT.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgGetopt(struct Cfg_Getopt *optstru);

 *	Return the next option from the initialized structure
 *
 *	Return:
 *		== 0: no further option or non-option argument found
 *		!= 0: shortname option found

ob(ject): cfgGetopt
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Return the next option
he(ader files): 
lo(ng description): Returns the next option in its shortname form.\par
	If there is a non-option argument pending and no output stack is
	currently active, this function fails.
pr(erequistes): 
va(lue): 0: no option available\item else: shortname of the found option
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfgopt.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <ctype.h>
#include <assert.h>
#include <portable.h>
#include "dynstr.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGOPT.C 1.8 2001/02/27 01:27:59 ska Exp ska $";
#endif

int cfgGetopt(struct Cfg_Getopt *optstru)
{	int ch;

	DBG_ENTER("cfgGetopt", Suppl_cmdline)

	assert(optstru);

	switch(C(type)) {	/* type of pending argument */
	case CFG_ARG:		/* as long as this argument is not removed -> hang */
		DBG_RETURN_I( 0)
	case CFG_OPT:		/* there is an unused option parsed into optstru */
		C(type) = CFG_NONE;
		DBG_RETURN_I( C(ch))
	case CFG_UNINITIALIZED:	/* first call of this function */
		cfg_initGetopt(optstru);
	}

	assert(C(_ch) && optSign);
	assert(C(_quote) && quoteSign);

	if(!C(_stk))	/* no input, nothing to do --> hang */
		DBG_RETURN_I( 0)

	/* empty out return values */
	chkHeap
	C(ch) = 0;		/* no option found */
	C(longname) = 0;	/* no option --> no longname */
	C(arg) = 0;	/* no argument found */
	C(argtype) = CFG_TERROR;		/* no argument */
	C(bool) = C(_glbBool);	/* global boolean sign */

	while((ch = S(getTokenFct)
		? (S(getTokenFct))(optstru)
		: cfg_getStream(optstru)) == CFG_CHR_RESCAN);

	chkHeap
	DBG_RETURN_I( ch)
}
