//                                                                            
// Copyright 1998, 1999 CDS Networks, Inc., Medford Oregon                    
//                                                                            
// All rights reserved.                                                       
//                                                                            
// Redistribution and use in source and binary forms, with or without         
// modification, are permitted provided that the following conditions are met:
// 1. Redistributions of source code must retain the above copyright          
//    notice, this list of conditions and the following disclaimer.           
// 2. Redistributions in binary form must reproduce the above copyright       
//    notice, this list of conditions and the following disclaimer in the     
//    documentation and/or other materials provided with the distribution.    
// 3. All advertising materials mentioning features or use of this software   
//    must display the following acknowledgement:                             
//      This product includes software developed by CDS Networks, Inc.        
// 4. The name of CDS Networks, Inc.  may not be used to endorse or promote   
//    products derived from this software without specific prior              
//    written permission.                                                     
//                                                                            
// THIS SOFTWARE IS PROVIDED BY CDS NETWORKS, INC. ``AS IS'' AND              
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE      
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
// ARE DISCLAIMED.  IN NO EVENT SHALL CDS NETWORKS, INC. BE LIABLE            
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS    
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)      
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     
// SUCH DAMAGE.                                                               
//                                                                            


package com.internetcds.jdbc.tds;

import java.sql.*;
import java.math.BigDecimal;
import java.util.Calendar;


/**
 * <P>CallableStatement is used to execute SQL stored procedures.
 *
 * <P>JDBC provides a stored procedure SQL escape that allows stored
 * procedures to be called in a standard way for all RDBMS's. This
 * escape syntax has one form that includes a result parameter and one
 * that does not. If used, the result parameter must be registered as
 * an OUT parameter. The other parameters may be used for input,
 * output or both. Parameters are refered to sequentially, by
 * number. The first parameter is 1.
 *
 * <P><CODE>
 * {?= call <procedure-name>[<arg1>,<arg2>, ...]}<BR>
 * {call <procedure-name>[<arg1>,<arg2>, ...]}
 * </CODE>
 *
 * <P>IN parameter values are set using the set methods inherited from
 * PreparedStatement. The type of all OUT parameters must be
 * registered prior to executing the stored procedure; their values
 * are retrieved after execution via the get methods provided here.
 *
 * <P>A Callable statement may return a ResultSet or multiple
 * ResultSets. Multiple ResultSets are handled using operations
 * inherited from Statement.
 *
 * <P>For maximum portability, a call's ResultSets and update counts
 * should be processed prior to getting the values of output
 * parameters.
 *
 * @see Connection#prepareCall
 * @see ResultSet
 */
public class CallableStatement_base 
   extends com.internetcds.jdbc.tds.PreparedStatement_base 
{
   public static final String cvsVersion = "$Id: CallableStatement_base.java,v 1.4 2000/07/17 04:41:03 cts Exp $";


   private String   procedureName = null;


   public CallableStatement_base(
      java.sql.Connection conn_, 
      Tds                 tds_, 
      String              sql)
      throws SQLException
   {
      super(conn_, tds_, sql);
      int   i;
      
      procedureName = "";
      i = 0;
      while(i<sql.length() 
            && (!
                (Character.isLetterOrDigit(sql.charAt(i))
                 || sql.charAt(i) == '#')))
      {
         i++;
      }
      
      while(i<sql.length()
            && (Character.isLetterOrDigit(sql.charAt(i))
                || sql.charAt(i) == '#'
                || sql.charAt(i) == '_'))
      {
         procedureName = procedureName + sql.charAt(i);
         i++;
      }
      
      if (procedureName.length() == 0)
      {
         throw new SQLException("Did not find name in sql string");
      }
   }




   /**
    * Get the value of a NUMERIC parameter as a java.math.BigDecimal object.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    *
    * @param scale a value greater than or equal to zero representing the
    * desired number of digits to the right of the decimal point
    *
    * @return the parameter value; if the value is SQL NULL, the result is
    * null
    * @exception SQLException if a database-access error occurs.
    */
   public BigDecimal getBigDecimal(int parameterIndex, int scale)
      throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of a BIT parameter as a Java boolean.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is false
    * @exception SQLException if a database-access error occurs.
    */
   public boolean getBoolean(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of a TINYINT parameter as a Java byte.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is 0
    * @exception SQLException if a database-access error occurs.
    */
   public byte getByte(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of a SQL BINARY or VARBINARY parameter as a Java byte[]
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is null
    * @exception SQLException if a database-access error occurs.
    */
   public byte[] getBytes(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of a SQL DATE parameter as a java.sql.Date object
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is null
    * @exception SQLException if a database-access error occurs.
    */
   public java.sql.Date getDate(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of a DOUBLE parameter as a Java double.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is 0
    * @exception SQLException if a database-access error occurs.
    */
   public double getDouble(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of a FLOAT parameter as a Java float.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is 0
    * @exception SQLException if a database-access error occurs.
    */
   public float getFloat(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of an INTEGER parameter as a Java int.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is 0
    * @exception SQLException if a database-access error occurs.
    */
   public int getInt(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of a BIGINT parameter as a Java long.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is 0
    * @exception SQLException if a database-access error occurs.
    */
   public long getLong(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   //----------------------------------------------------------------------
   // Advanced features:


   /**
    * Get the value of a parameter as a Java object.
    *
    * <p>This method returns a Java object whose type coresponds to the SQL
    * type that was registered for this parameter using registerOutParameter.
    *
    * <p>Note that this method may be used to read
    * datatabase-specific, abstract data types. This is done by
    * specifying a targetSqlType of java.sql.types.OTHER, which
    * allows the driver to return a database-specific Java type.
    *
    * @param parameterIndex The first parameter is 1, the second is 2, ...
    * @return A java.lang.Object holding the OUT parameter value.
    * @exception SQLException if a database-access error occurs.
    * @see Types
    */
   public Object getObject(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of a SMALLINT parameter as a Java short.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is 0
    * @exception SQLException if a database-access error occurs.
    */
   public short getShort(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of a CHAR, VARCHAR, or LONGVARCHAR parameter as a Java String.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is null
    * @exception SQLException if a database-access error occurs.
    */
   public String getString(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of a SQL TIME parameter as a java.sql.Time object.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is null
    * @exception SQLException if a database-access error occurs.
    */
   public java.sql.Time getTime(int parameterIndex) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Get the value of a SQL TIMESTAMP parameter as a java.sql.Timestamp object.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @return the parameter value; if the value is SQL NULL, the result is null
    * @exception SQLException if a database-access error occurs.
    */
   public java.sql.Timestamp getTimestamp(int parameterIndex)
      throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Before executing a stored procedure call, you must explicitly
    * call registerOutParameter to register the java.sql.Type of each
    * out parameter.
    *
    * <P><B>Note:</B> When reading the value of an out parameter, you
    * must use the getXXX method whose Java type XXX corresponds to the
    * parameter's registered SQL type.
    *
    * @param parameterIndex the first parameter is 1, the second is 2,...
    * @param sqlType SQL type code defined by java.sql.Types;
    * for parameters of type Numeric or Decimal use the version of
    * registerOutParameter that accepts a scale value
    * @exception SQLException if a database-access error occurs.
    * @see Type
    */
   public void registerOutParameter(int parameterIndex, int sqlType)
      throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Use this version of registerOutParameter for registering
    * Numeric or Decimal out parameters.
    *
    * <P><B>Note:</B> When reading the value of an out parameter, you
    * must use the getXXX method whose Java type XXX corresponds to the
    * parameter's registered SQL type.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param sqlType use either java.sql.Type.NUMERIC or java.sql.Type.DECIMAL
    * @param scale a value greater than or equal to zero representing the
    *              desired number of digits to the right of the decimal point
    * @exception SQLException if a database-access error occurs.
    * @see Type
    */
   public void registerOutParameter(int parameterIndex, int sqlType, int scale)
      throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * An OUT parameter may have the value of SQL NULL; wasNull reports
    * whether the last value read has this special value.
    *
    * <P><B>Note:</B> You must first call getXXX on a parameter to
    * read its value and then call wasNull() to see if the value was
    * SQL NULL.
    *
    * @return true if the last parameter read was SQL NULL
    * @exception SQLException if a database-access error occurs.
    */
   public boolean wasNull() throws SQLException
   {
      throw new SQLException("Not implemented");
   }

   public boolean execute()
      throws SQLException
   {
      boolean   result;

      closeResults();
      updateCount = -2;

      // First make sure the caller has filled in all the parameters.
      ParameterUtils.verifyThatParametersAreSet(parameterList);

      // execute the stored procedure
      result = executeCall(procedureName, 
                           parameterList,
                           parameterList);

      return result;
   }



   //--------------------------JDBC 2.0-----------------------------
   
   /**
    * JDBC 2.0
    *
    * Gets the value of a JDBC <code>NUMERIC</code> parameter as a 
    * <code>java.math.BigDecimal</code> object with as many digits to the
    * right of the decimal point as the value contains.
    * @param parameterIndex the first parameter is 1, the second is 2,
    * and so on
    * @return the parameter value in full precision.  If the value is 
    * SQL NULL, the result is <code>null</code>. 
    * @exception SQLException if a database access error occurs
    */
   public BigDecimal getBigDecimal(int parameterIndex) throws SQLException
      {
         NotImplemented();
         return null;
      }


   
   /**
    * Gets the value of a JDBC <code>DATE</code> parameter as a 
    * <code>java.sql.Date</code> object, using
    * the given <code>Calendar</code> object
    * to construct the date.
    * With a <code>Calendar</code> object, the driver
    * can calculate the date taking into account a custom timezone and locale.
    * If no <code>Calendar</code> object is specified, the driver uses the
    * default timezone and locale.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, 
    * and so on
    * @param cal the <code>Calendar</code> object the driver will use
    *            to construct the date
    * @return the parameter value.  If the value is SQL NULL, the result is 
    * <code>null</code>.
    * @exception SQLException if a database access error occurs
    */
   public java.sql.Date getDate(int parameterIndex, Calendar cal) 
      throws SQLException
      {
         NotImplemented();
         return null;
      }
   
   
   /**
    * Gets the value of a JDBC <code>TIME</code> parameter as a 
    * <code>java.sql.Time</code> object, using
    * the given <code>Calendar</code> object
    * to construct the time.
    * With a <code>Calendar</code> object, the driver
    * can calculate the time taking into account a custom timezone and locale.
    * If no <code>Calendar</code> object is specified, the driver uses the
    * default timezone and locale.
    *
    * @param parameterIndex the first parameter is 1, the second is 2,
    * and so on
    * @param cal the <code>Calendar</code> object the driver will use
    *            to construct the time
    * @return the parameter value; if the value is SQL NULL, the result is 
    * <code>null</code>.
    * @exception SQLException if a database access error occurs
    */
   public java.sql.Time getTime(int parameterIndex, Calendar cal) 
      throws SQLException
   {
      NotImplemented();
      return null;
   }
   
   
   /**
    * Gets the value of a JDBC <code>TIMESTAMP</code> parameter as a
    * <code>java.sql.Timestamp</code> object, using
    * the given <code>Calendar</code> object to construct
    * the <code>Timestamp</code> object.
    * With a <code>Calendar</code> object, the driver
    * can calculate the timestamp taking into account a custom timezone and locale.
    * If no <code>Calendar</code> object is specified, the driver uses the
    * default timezone and locale.
    *
    *
    * @param parameterIndex the first parameter is 1, the second is 2, 
    * and so on
    * @param cal the <code>Calendar</code> object the driver will use
    *            to construct the timestamp
    * @return the parameter value.  If the value is SQL NULL, the result is 
    * <code>null</code>.
    * @exception SQLException if a database access error occurs
    */
   public java.sql.Timestamp getTimestamp(int parameterIndex, Calendar cal) 
      throws SQLException
   {
      NotImplemented();
      return null;
   }
   


   /**
    * JDBC 2.0
    *
    * Registers the designated output parameter.  This version of 
    * the method <code>registerOutParameter</code>
    * should be used for a user-named or REF output parameter.  Examples
    * of user-named types include: STRUCT, DISTINCT, JAVA_OBJECT, and
    * named array types.
    *
    * Before executing a stored procedure call, you must explicitly
    * call <code>registerOutParameter</code> to register the type from
    * <code>java.sql.Types</code> for each
    * OUT parameter.  For a user-named parameter the fully-qualified SQL
    * type name of the parameter should also be given, while a REF
    * parameter requires that the fully-qualified type name of the
    * referenced type be given.  A JDBC driver that does not need the
    * type code and type name information may ignore it.   To be portable,
    * however, applications should always provide these values for
    * user-named and REF parameters.
    *
    * Although it is intended for user-named and REF parameters,
    * this method may be used to register a parameter of any JDBC type.
    * If the parameter does not have a user-named or REF type, the
    * typeName parameter is ignored.
    *
    * <P><B>Note:</B> When reading the value of an out parameter, you
    * must use the <code>getXXX</code> method whose Java type XXX corresponds to the
    * parameter's registered SQL type.
    *
    * @param parameterIndex the first parameter is 1, the second is 2,...
    * @param sqlType a value from {@link java.sql.Types}
    * @param typeName the fully-qualified name of an SQL structured type
    * @exception SQLException if a database-access error occurs
    * @see Types
    */
   public void registerOutParameter (int paramIndex, int sqlType, String typeName)
      throws SQLException
   {
      NotImplemented();
   }
   



   static public void main(String args[])
      throws java.lang.ClassNotFoundException, 
      java.lang.IllegalAccessException,
      java.lang.InstantiationException
   {
      try
      {
         String   url = url = ""
            + "jdbc:freetds:"
            + "//"
            + "kap"
            + "/"
            + "pubs";

         Class.forName("com.internetcds.jdbc.tds.Driver").newInstance();
         java.sql.Connection connection;
         connection =  DriverManager.getConnection(url,
                                                   "testuser",
                                                   "password");

         java.sql.CallableStatement call = connection.prepareCall(
            "sp_tables ?");
         call.setString(1, "%");
         java.sql.ResultSet rs = call.executeQuery();

         while(rs.next())
         {
            String   qualifier = rs.getString("TABLE_QUALIFIER");
            String   owner     = rs.getString("TABLE_OWNER");
            String   name      = rs.getString("TABLE_NAME");
            String   type      = rs.getString("TABLE_TYPE");
            String   remarks   = rs.getString("REMARKS");

            System.out.println("qualifier: " + qualifier);
            System.out.println("owner:     " + owner);
            System.out.println("name:      " + name);
            System.out.println("type:      " + type);
            System.out.println("remarks:   " + remarks);
            System.out.println("");
         }
      }
      catch(SQLException e)
      {
         e.printStackTrace();
         System.out.println(e.getMessage());
      }
   }
}
