//
// Copyright 1999 Craig Spannring
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. All advertising materials mentioning features or use of this software
//    must display the following acknowledgement:
//      This product includes software developed by Craig Spannring
// 4. The name of Craig Spannring may not be used to endorse or promote
//    products derived from this software without specific prior
//    written permission.
//
// THIS SOFTWARE IS PROVIDED BY CRAIG SPANNRING ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL CRAIG SPANNRING BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//

package com.internetcds.jdbc.tds;


public class PreparedStatement_2_0 
   extends    com.internetcds.jdbc.tds.PreparedStatement_base
   implements java.sql.PreparedStatement
{
   public static final String cvsVersion = "$Id: PreparedStatement_2_0.java,v 1.3 2000/07/17 04:41:05 cts Exp $";


   public PreparedStatement_2_0(
      java.sql.Connection conn_, 
      Tds                 tds_,
      String              sql)
      throws java.sql.SQLException
      {
         super(conn_, tds_, sql);
      }

    //--------------------------JDBC 2.0-----------------------------

    /**
     * JDBC 2.0
     *
     * Adds a set of parameters to the batch.
     * 
     * @exception SQLException if a database access error occurs
     * @see Statement#addBatch
     */
   public void addBatch() throws java.sql.SQLException
      {
         NotImplemented();
      }
   
   /**
    * JDBC 2.0
    *
    * Sets the designated parameter to the given <code>Reader</code>
    * object, which is the given number of characters long.
    * When a very large UNICODE value is input to a LONGVARCHAR
    * parameter, it may be more practical to send it via a
    * java.io.Reader. JDBC will read the data from the stream
    * as needed, until it reaches end-of-file.  The JDBC driver will
    * do any necessary conversion from UNICODE to the database char format.
    * 
    * <P><B>Note:</B> This stream object can either be a standard
    * Java stream object or your own subclass that implements the
    * standard interface.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the java reader which contains the UNICODE data
    * @param length the number of characters in the stream 
    * @exception SQLException if a database access error occurs
    */
   public void setCharacterStream(int parameterIndex,
                                  java.io.Reader reader,
                                  int length) throws java.sql.SQLException
      {
         NotImplemented();
      }
   

    /**
     * JDBC 2.0
     *
     * Sets a REF(&lt;structured-type&gt;) parameter.
     *
     * @param i the first parameter is 1, the second is 2, ...
     * @param x an object representing data of an SQL REF Type
     * @exception SQLException if a database access error occurs
     */
   public void setRef (int i, java.sql.Ref x) throws java.sql.SQLException
      {
         NotImplemented();
      }


    /**
     * JDBC 2.0
     *
     * Sets a BLOB parameter.
     *
     * @param i the first parameter is 1, the second is 2, ...
     * @param x an object representing a BLOB
     * @exception SQLException if a database access error occurs
     */
   public void setBlob (int i, java.sql.Blob x) throws java.sql.SQLException
      {
         NotImplemented();
      }


    /**
     * JDBC 2.0
     *
     * Sets a CLOB parameter.
     *
     * @param i the first parameter is 1, the second is 2, ...
     * @param x an object representing a CLOB
     * @exception SQLException if a database access error occurs
     */
   public void setClob (int i, java.sql.Clob x) throws java.sql.SQLException
      {
         NotImplemented();
      }


    /**
     * JDBC 2.0
     *
     * Sets an Array parameter.
     *
     * @param i the first parameter is 1, the second is 2, ...
     * @param x an object representing an SQL array
     * @exception SQLException if a database access error occurs
     */
   public void setArray (int i, java.sql.Array x) throws java.sql.SQLException
      {
         NotImplemented();
      }


    /**
     * JDBC 2.0
     *
     * Gets the number, types and properties of a ResultSet's columns.
     *
     * @return the description of a ResultSet's columns
     * @exception SQLException if a database access error occurs
     */
   public java.sql.ResultSetMetaData getMetaData() throws java.sql.SQLException
      {
         NotImplemented();
         return null;
      }


    /**
     * JDBC 2.0
     *
     * Sets the designated parameter to a java.sql.Date value,
     * using the given <code>Calendar</code> object.  The driver uses
     * the <code>Calendar</code> object to construct an SQL DATE,
     * which the driver then sends to the database.  With a
     * a <code>Calendar</code> object, the driver can calculate the date
     * taking into account a custom timezone and locale.  If no
     * <code>Calendar</code> object is specified, the driver uses the default
     * timezone and locale.
     *
     * @param parameterIndex the first parameter is 1, the second is 2, ...
     * @param x the parameter value
     * @param cal the <code>Calendar</code> object the driver will use
     *            to construct the date
     * @exception SQLException if a database access error occurs
     */
   public void setDate(int parameterIndex, java.sql.Date x, java.util.Calendar cal)
      throws java.sql.SQLException
   {
      NotImplemented();
   }
   
   
   /**
    * JDBC 2.0
    *
    * Sets the designated parameter to a java.sql.Time value,
    * using the given <code>Calendar</code> object.  The driver uses
    * the <code>Calendar</code> object to construct an SQL TIME,
    * which the driver then sends to the database.  With a
    * a <code>Calendar</code> object, the driver can calculate the time
    * taking into account a custom timezone and locale.  If no
    * <code>Calendar</code> object is specified, the driver uses the default
    * timezone and locale.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @param cal the <code>Calendar</code> object the driver will use
    *            to construct the time
    * @exception SQLException if a database access error occurs
    */
   public void setTime(int parameterIndex, java.sql.Time x, java.util.Calendar cal) 
      throws java.sql.SQLException
   {
      NotImplemented();
   }
   
   
   /**
    * JDBC 2.0
    *
    * Sets the designated parameter to a java.sql.Timestamp value,
    * using the given <code>Calendar</code> object.  The driver uses
    * the <code>Calendar</code> object to construct an SQL TIMESTAMP,
    * which the driver then sends to the database.  With a
    * a <code>Calendar</code> object, the driver can calculate the timestamp
    * taking into account a custom timezone and locale.  If no
    * <code>Calendar</code> object is specified, the driver uses the default
    * timezone and locale.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value 
    * @param cal the <code>Calendar</code> object the driver will use
    *            to construct the timestamp
    * @exception SQLException if a database access error occurs
    */
   public void setTimestamp(int                parameterIndex, 
                            java.sql.Timestamp x, 
                            java.util.Calendar cal)
      throws java.sql.SQLException
   {
      NotImplemented();
   }
   

   /**
    * JDBC 2.0
    *
    * Sets the designated parameter to SQL NULL.  This version of setNull should
    * be used for user-named types and REF type parameters.  Examples
    * of user-named types include: STRUCT, DISTINCT, JAVA_OBJECT, and 
    * named array types.
    *
    * <P><B>Note:</B> To be portable, applications must give the
    * SQL type code and the fully-qualified SQL type name when specifying
    * a NULL user-defined or REF parameter.  In the case of a user-named type 
    * the name is the type name of the parameter itself.  For a REF 
    * parameter the name is the type name of the referenced type.  If 
    * a JDBC driver does not need the type code or type name information, 
    * it may ignore it.     
    *
    * Although it is intended for user-named and Ref parameters,
    * this method may be used to set a null parameter of any JDBC type.
    * If the parameter does not have a user-named or REF type, the given
    * typeName is ignored.
    *
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param sqlType a value from java.sql.Types
    * @param typeName the fully-qualified name of an SQL user-named type,
    *  ignored if the parameter is not a user-named type or REF 
    * @exception SQLException if a database access error occurs
    */
   public void setNull (int paramIndex, int sqlType, String typeName) 
      throws java.sql.SQLException
   {
      NotImplemented();
   }
}
