//                                                                            
// Copyright 1998,1999 CDS Networks, Inc., Medford Oregon                    
//                                                                            
// All rights reserved.                                                       
//                                                                            
// Redistribution and use in source and binary forms, with or without         
// modification, are permitted provided that the following conditions are met:
// 1. Redistributions of source code must retain the above copyright          
//    notice, this list of conditions and the following disclaimer.           
// 2. Redistributions in binary form must reproduce the above copyright       
//    notice, this list of conditions and the following disclaimer in the     
//    documentation and/or other materials provided with the distribution.    
// 3. All advertising materials mentioning features or use of this software   
//    must display the following acknowledgement:                             
//      This product includes software developed by CDS Networks, Inc.        
// 4. The name of CDS Networks, Inc.  may not be used to endorse or promote   
//    products derived from this software without specific prior              
//    written permission.                                                     
//                                                                            
// THIS SOFTWARE IS PROVIDED BY CDS NETWORKS, INC. ``AS IS'' AND              
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE      
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
// ARE DISCLAIMED.  IN NO EVENT SHALL CDS NETWORKS, INC. BE LIABLE            
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS    
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)      
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     
// SUCH DAMAGE.                                                               
//                                                                            


package com.internetcds.jdbc.tds;

import java.sql.*;
import java.math.BigDecimal;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.Calendar;



/**
 * <P>A SQL statement is pre-compiled and stored in a
 * PreparedStatement object. This object can then be used to
 * efficiently execute this statement multiple times.
 *
 * <P><B>Note:</B> The setXXX methods for setting IN parameter values
 * must specify types that are compatible with the defined SQL type of
 * the input parameter. For instance, if the IN parameter has SQL type
 * Integer then setInt should be used.
 *
 * <p>If arbitrary parameter type conversions are required then the
 * setObject method should be used with a target SQL type.
 *
 * @author Craig Spannring
 * @author The FreeTDS project
 * @version  $Id: PreparedStatement_base.java,v 1.6 2001/02/08 19:30:12 cts Exp $
 *
 * @see Connection#prepareStatement
 * @see ResultSet
 */
public class PreparedStatement_base
   extends    com.internetcds.jdbc.tds.Statement
   implements PreparedStatementHelper
{
   public static final String cvsVersion = "$Id: PreparedStatement_base.java,v 1.6 2001/02/08 19:30:12 cts Exp $";


   String               rawQueryString     = null;
   Vector               procedureCache     = null;
   ParameterListItem[]  parameterList      = null;

   public PreparedStatement_base(
      java.sql.Connection conn_, 
      Tds                 tds_,
      String              sql)
      throws SQLException
   {
      super(conn_, tds_);

      rawQueryString = sql;

      int  i;
      int  numberOfParameters = ParameterUtils.countParameters(rawQueryString);

      parameterList = new ParameterListItem[numberOfParameters];
      for(i=0; i<numberOfParameters; i++)
      {
         parameterList[i] = new ParameterListItem();
      }

      procedureCache = new Vector();
   }


   protected void NotImplemented() throws java.sql.SQLException
      {
         throw new SQLException("Not Implemented");
      }
   
   
   /**
    * <P>In general, parameter values remain in force for repeated use of a
    * Statement. Setting a parameter value automatically clears its
    * previous value.  However, in some cases it is useful to immediately
    * release the resources used by the current parameter values; this can
    * be done by calling clearParameters.
    *
    * @exception SQLException if a database-access error occurs.
    */
   public void clearParameters() throws SQLException
   {
      int   i;
      for(i=0; i<parameterList.length; i++)
      {
         parameterList[i].clear();
      }
   }

   public void dropAllProcedures()
   {
      procedureCache = null;
      procedureCache = new Vector();
   }


   /**
    * Some prepared statements return multiple results; the execute
    * method handles these complex statements as well as the simpler
    * form of statements handled by executeQuery and executeUpdate.
    *
    * @exception SQLException if a database-access error occurs.
    * @see Statement#execute
    */
   public boolean execute() throws SQLException
   {
      //
      // TDS can handle prepared statements by creating a temporary
      // procedure.  Since procedure must have the datatype specified
      // in the procedure declaration we will have to defer creating
      // the actual procedure until the statement is executed.  By
      // that time we know all the types of all of the parameters.
      //

      Procedure  procedure = null;
      boolean    result = false;

      closeResults();
      updateCount = -2;

      // First make sure the caller has filled in all the parameters.
      ParameterUtils.verifyThatParametersAreSet(parameterList);

      // Find a stored procedure that is compatible with this set of
      // parameters if one exists.
      procedure = findCompatibleStoredProcedure();

      // if we don't have a suitable match then create a new
      // temporary stored procedure
      if (procedure == null)
      {
         // create the stored procedure
         procedure = new Procedure(rawQueryString, 
                                   tds.getUniqueProcedureName(),
                                   parameterList, tds);

         // store it in the procedureCache
         procedureCache.addElement(procedure);

         // create it on the SQLServer.
         submitProcedure(procedure);
      }
      result = executeCall(procedure.getProcedureName(),
                           procedure.getParameterList(), // formal params
                           parameterList);               // actual params

      return result;
   }


   protected boolean executeCall(
      String              name,
      ParameterListItem[] formalParameterList,
      ParameterListItem[] actualParameterList)
      throws SQLException
   {
      boolean  result;
      boolean  wasCanceled = false;

      try
      {
         SQLException   exception = null;
         PacketResult   tmp       = null;


         // execute the stored procedure.
         tds.executeProcedure(name, 
                              formalParameterList,
                              actualParameterList,
                              this, 
                              timeout);

         while (tds.isErrorPacket() || tds.isMessagePacket())
         {
            tmp = tds.processSubPacket();
            exception = warningChain.addOrReturn((PacketMsgResult)tmp);
            if (exception != null)
            {
               throw exception;
            }
         }


         while(tds.isDoneInProc())
         {
            tmp = tds.processSubPacket();
         }

         if (tds.isProcId())
         {
            tmp = tds.processSubPacket();
         }

         if (tds.isResultSet())
         {
            result = true;
         }
         else
         {
            result = false;
            boolean done = false;
            do
            {
               tmp = tds.processSubPacket();
               if (tmp instanceof PacketEndTokenResult)
               {
                  done = ! ((PacketEndTokenResult)tmp).moreResults();
                  wasCanceled = wasCanceled
                     || ((PacketEndTokenResult)tmp).wasCanceled();
                  updateCount = ((PacketEndTokenResult)tmp).getRowCount();
               }
               else if (tmp.getPacketType() 
                        == TdsDefinitions.TDS_RET_STAT_TOKEN)
               {
                  // nop
               }
               else 
               {
                  throw new SQLException("Protocol confusion"
                                         + "Found a "   
                                         + tmp.getClass().getName()
                                         + " (packet type 0x"
                                         + Integer.toHexString(tmp.getPacketType() 
                                                               & 0xff)
                                         + ")");
               }
            } while (!done);
         }
      }
      catch(TdsException e)
      {
         e.printStackTrace();
         throw new SQLException(e.getMessage());
      }
      catch(java.io.IOException e)
      {
         e.printStackTrace();
         throw new SQLException(e.getMessage());
      }
      if (wasCanceled)
      {
         throw new SQLException("Query was canceled or timed out.");
      }
      return result;
   }


   
   private Procedure findCompatibleStoredProcedure()
      throws SQLException
   {
      Procedure  procedure = null;
      int        i;

   
      for(i=0; i<procedureCache.size(); i++)
      {
         Procedure tmp = (Procedure)procedureCache.elementAt(i);
         if (tmp.compatibleParameters(parameterList))
         {
            procedure = tmp;
            if (!tmp.hasLobParameters()) 
            {
               break;
            }
         }
      }
      return procedure;
   }


   private void submitProcedure(Procedure proc)
      throws SQLException
   {
      String       sql  = proc.getPreparedSqlString();
      tds.submitProcedure(sql, warningChain);
   }

   /**
    * A prepared SQL query is executed and its ResultSet is returned.
    *
    * @return a ResultSet that contains the data produced by the
    * query; never null
    * @exception SQLException if a database-access error occurs.
    */
   public java.sql.ResultSet executeQuery() throws SQLException
   {
      if (execute())
      {
         startResultSet();
      }
      else
      {
         throw new SQLException("Was expecting a result set");
      }

      return results;
   }


   /**
    * Execute a SQL INSERT, UPDATE or DELETE statement. In addition,
    * SQL statements that return nothing such as SQL DDL statements
    * can be executed.
    *
    * @return either the row count for INSERT, UPDATE or DELETE; or 0
    * for SQL statements that return nothing
    * @exception SQLException if a database-access error occurs.
    */
   public int executeUpdate() throws SQLException
   {
      closeResults();

      if (execute())
      {
         startResultSet();
         closeResults();
         throw new SQLException("executeUpdate can't return a result set");
      }
      else 
      {
         return getUpdateCount();
      }
   }


   /**
    * When a very large ASCII value is input to a LONGVARCHAR
    * parameter, it may be more practical to send it via a
    * java.io.InputStream. JDBC will read the data from the stream
    * as needed, until it reaches end-of-file.  The JDBC driver will
    * do any necessary conversion from ASCII to the database char format.
    *
    * <P><B>Note:</B> This stream object can either be a standard
    * Java stream object or your own subclass that implements the
    * standard interface.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the java input stream which contains the ASCII parameter value
    * @param length the number of bytes in the stream
    * @exception SQLException if a database-access error occurs.
    */
   public void setAsciiStream(int                 parameterIndex, 
                              java.io.InputStream x, 
                              int                 length)
      throws SQLException
   {
      NotImplemented();
   }


   /**
    * Set a parameter to a java.lang.BigDecimal value.
    * The driver converts this to a SQL NUMERIC value when
    * it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * When a very large binary value is input to a LONGVARBINARY
    * parameter, it may be more practical to send it via a
    * java.io.InputStream. JDBC will read the data from the stream
    * as needed, until it reaches end-of-file.
    *
    * <P><B>Note:</B> This stream object can either be a standard
    * Java stream object or your own subclass that implements the
    * standard interface.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the java input stream which contains the binary parameter value
    * @param length the number of bytes in the stream
    * @exception SQLException if a database-access error occurs.
    */
   public void setBinaryStream(int                 parameterIndex, 
                               java.io.InputStream x, 
                               int                 length)
      throws SQLException
   {
      NotImplemented();
   }
   
   
   /**
    * Set a parameter to a Java boolean value.  The driver converts this
    * to a SQL BIT value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setBoolean(int parameterIndex, boolean x) throws SQLException
   {
      NotImplemented();
   }


   /**
    * Set a parameter to a Java byte value.  The driver converts this
    * to a SQL TINYINT value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setByte(int index, byte x) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Set a parameter to a Java array of bytes.  The driver converts
    * this to a SQL VARBINARY or LONGVARBINARY (depending on the
    * argument's size relative to the driver's limits on VARBINARYs)
    * when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setBytes(int parameterIndex, byte x[]) throws SQLException
   {
      // when this method creates the parameter the formal type should 
      // be a varbinary if the length of 'x' is <=255, image if length>255.
      if (x == null || x.length<=255)
      {
         setParam(parameterIndex, x, java.sql.Types.VARBINARY, -1);
      }
      else
      {
         setParam(parameterIndex, x, java.sql.Types.LONGVARBINARY, -1);
      }
   }


   /**
    * Set a parameter to a java.sql.Date value.  The driver converts this
    * to a SQL DATE value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setDate(int parameterIndex, java.sql.Date value)
      throws SQLException
   {
      
      setParam(parameterIndex, 
               new java.sql.Date(value.getYear(), value.getMonth(), value.getDate()),
               java.sql.Types.DATE, 
               -1);
   }


   /**
    * Set a parameter to a Java double value.  The driver converts this
    * to a SQL DOUBLE value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setDouble(int parameterIndex, double value) throws SQLException
   {
      setParam(parameterIndex, new Double(value), java.sql.Types.DOUBLE, -1);
   }


   /**
    * Set a parameter to a Java float value.  The driver converts this
    * to a SQL FLOAT value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setFloat(int parameterIndex, float value) throws SQLException
   {
      setParam(parameterIndex, new Float(value), java.sql.Types.REAL, -1);
   }


   /**
    * Set a parameter to a Java int value.  The driver converts this
    * to a SQL INTEGER value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setInt(int index, int value) throws SQLException
   {
      setParam(index, new Integer(value), java.sql.Types.INTEGER, -1);
   }


   /**
    * Set a parameter to a Java long value.  The driver converts this
    * to a SQL BIGINT value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setLong(int parameterIndex, long value) throws SQLException
   {
      setParam(parameterIndex, new Long(value), java.sql.Types.BIGINT, -1);
   }


   /**
    * Set a parameter to SQL NULL.
    *
    * <P><B>Note:</B> You must specify the parameter's SQL type.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param sqlType SQL type code defined by java.sql.Types
    * @exception SQLException if a database-access error occurs.
    */
   public void setNull(int index, int type) throws SQLException
   {
      setParam(index, null, type, -1);
   }


   /**
    * <p>Set the value of a parameter using an object; use the
    * java.lang equivalent objects for integral values.
    *
    * <p>The JDBC specification specifies a standard mapping from
    * Java Object types to SQL types.  The given argument java object
    * will be converted to the corresponding SQL type before being
    * sent to the database.
    *
    * <p>Note that this method may be used to pass datatabase
    * specific abstract data types, by using a Driver specific Java
    * type.
    *
    * @param parameterIndex The first parameter is 1, the second is 2, ...
    * @param x The object containing the input parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setObject(int parameterIndex, Object x) throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * This method is like setObject above, but assumes a scale of zero.
    *
    * @exception SQLException if a database-access error occurs.
    */
   public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException
   {
      throw new SQLException("Not implemented");
   }

   /**
    * initialize one element in the parameter list
    *
    * @param index   (in-only) index (first column is 1) of the parameter
    * @param value   (in-only)
    * @param type    (in-only) JDBC type
    */
   private void setParam(
      int    index, 
      Object value, 
      int    type,
      int    strLength)  
      throws SQLException
   {
      if (index < 1)
      {
         throw new SQLException("Invalid Parameter index " 
                                + index + ".  JDBC indexes start at 1.");
      }
      if (index > parameterList.length)
      {
         throw new SQLException("Invalid Parameter index " 
                                + index + ".  This statement only has "
                                + parameterList.length + " parameters");
      }

      // JDBC indexes start at 1, java array indexes start at 0 :-(
      index--;
      
      parameterList[index].type      = type;
      parameterList[index].isSet     = true;
      parameterList[index].value     = value;
      
      parameterList[index].maxLength = strLength;
   } // setParam()
   

   //----------------------------------------------------------------------
   // Advanced features:
   
   /**
    * <p>Set the value of a parameter using an object; use the
    * java.lang equivalent objects for integral values.
    *
    * <p>The given Java object will be converted to the targetSqlType
    * before being sent to the database.
    *
    * <p>Note that this method may be used to pass datatabase-
    * specific abstract data types. This is done by using a Driver-
    * specific Java type and using a targetSqlType of
    * java.sql.types.OTHER.
    *
    * @param parameterIndex The first parameter is 1, the second is 2, ...
    * @param x The object containing the input parameter value
    * @param targetSqlType The SQL type (as defined in java.sql.Types) to be
    * sent to the database. The scale argument may further qualify this type.
    * @param scale For java.sql.Types.DECIMAL or java.sql.Types.NUMERIC types
    *          this is the number of digits after the decimal.  For all other
    *          types this value will be ignored,
    * @exception SQLException if a database-access error occurs.
    * @see Types
    */
   public void setObject(int parameterIndex, Object x, int targetSqlType, int scale)
      throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Set a parameter to a Java short value.  The driver converts this
    * to a SQL SMALLINT value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setShort(int index, short value) throws SQLException
   {
      setParam(index, new Integer(value), java.sql.Types.SMALLINT, -1);
   }


   /**
    * Set a parameter to a Java String value.  The driver converts this
    * to a SQL VARCHAR or LONGVARCHAR value (depending on the arguments
    * size relative to the driver's limits on VARCHARs) when it sends
    * it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setString(int index, String str) throws SQLException
   {
      int len  = str.length();
      if (len==0)
      {
         // In SQL trailing spaces aren't significant.  SQLServer uses 
         // strings with a single space (" ") to represent a zero length 
         // string.
         setParam(index, " ", java.sql.Types.VARCHAR, 1);
      }
      else
      {
         setParam(index, str, java.sql.Types.VARCHAR, len);
      }
   }


   /**
    * Set a parameter to a java.sql.Time value.  The driver converts this
    * to a SQL TIME value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setTime(int parameterIndex, java.sql.Time x)
      throws SQLException
   {
      throw new SQLException("Not implemented");
   }


   /**
    * Set a parameter to a java.sql.Timestamp value.  The driver
    * converts this to a SQL TIMESTAMP value when it sends it to the
    * database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    * @exception SQLException if a database-access error occurs.
    */
   public void setTimestamp(int index, java.sql.Timestamp value)
      throws SQLException
   {
      setParam(index, value, java.sql.Types.TIMESTAMP, -1);
   }


   /**
    * When a very large UNICODE value is input to a LONGVARCHAR
    * parameter, it may be more practical to send it via a
    * java.io.InputStream. JDBC will read the data from the stream
    * as needed, until it reaches end-of-file.  The JDBC driver will
    * do any necessary conversion from UNICODE to the database char format.
    *
    * <P><B>Note:</B> This stream object can either be a standard
    * Java stream object or your own subclass that implements the
    * standard interface.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the java input stream which contains the
    * UNICODE parameter value
    * @param length the number of bytes in the stream
    * @exception SQLException if a database-access error occurs.
    */
   public void setUnicodeStream(int parameterIndex, java.io.InputStream x, int length)
      throws SQLException
   {
      throw new SQLException("Not implemented");
   }
   



   static public void main(String args[])
      throws java.lang.ClassNotFoundException, 
      java.lang.IllegalAccessException,
      java.lang.InstantiationException,
      SQLException
   {
      
      java.sql.PreparedStatement stmt;
      String   query = null;
      String   url = url = ""
         + "jdbc:freetds:"
         + "//"
         + "kap"
         + "/"
         + "pubs";

      Class.forName("com.internetcds.jdbc.tds.Driver").newInstance();
      java.sql.Connection connection;
      connection =  DriverManager.getConnection(url,
                                                "testuser",
                                                "password");


      stmt=  connection.prepareStatement(
         ""
         +"select price, title_id, title, price*ytd_sales gross from titles"
         +" where title like ?");
      stmt.setString(1, "The%");
      java.sql.ResultSet rs = stmt.executeQuery();

      while(rs.next())
      {
         float    price     = rs.getFloat("price");
         if (rs.wasNull())
         {
            System.out.println("price:  null");
         }
         else 
         {
            System.out.println("price:  " + price);
         }

         String   title_id  = rs.getString("title_id");
         String   title     = rs.getString("title");
         float    gross     = rs.getFloat("gross");

         
         System.out.println("id:     " + title_id);
         System.out.println("name:   " + title);
         System.out.println("gross:  " + gross);
         System.out.println("");
      }
   }
}
