


import com.internetcds.jdbc.tds.Tds;
import java.sql.*;

/**
 * test the sql escape syntax.
 */
class t0006 
{
   static int   exitStatus = 0;


   static void test(
      String   sql,
      String   expected)
      throws java.sql.SQLException
   {
      System.out.println("Expanding |" + sql + "|");
      String tmp = Tds.toNativeSql(sql, Tds.SQLSERVER);
      if (! tmp.equals(expected))
      {
         System.out.println("Failed.");
         System.out.println("  Input:           |" + sql +"|");
         System.out.println("  Expected output: |" + expected + "|");
         System.out.println("  Actual output:   |" + tmp + "|");
         exitStatus = 1;
      }
      else
      {
         System.out.println("okay");
      }
   }

   static void checkBogus(String str)
   {
      try
      {
         String tmp = Tds.toNativeSql(str, Tds.SQLSERVER);
         System.out.println("Failed on |" + str + "|");
      }
      catch (SQLException e)
      {
         // nop
      }
   }


   static public void main(String args[])
      throws SQLException
   {
      System.out.println("test the sql escape syntax.");

      System.out.println("Checking strings that should be translated");
      test("select * from tmp where d={d 1999-09-19}",
           "select * from tmp where d='19990919'");
      test("select * from tmp where d={d '1999-09-19'}",
           "select * from tmp where d='19990919'");
      test("select * from tmp where t={t 12:34:00}",
           "select * from tmp where t='12:34:00'");
      test("select * from tmp where ts={ts 1998-12-15 12:34:00.1234}",
           "select * from tmp where ts='19981215 12:34:00.123'");
      test("select * from tmp where ts={ts 1998-12-15 12:34:00}",
           "select * from tmp where ts='19981215 12:34:00.000'");
      test("select * from tmp where ts={ts 1998-12-15 12:34:00.1}",
           "select * from tmp where ts='19981215 12:34:00.100'");
      test("select * from tmp where ts={ts 1998-12-15 12:34:00}",
           "select * from tmp where ts='19981215 12:34:00.000'");
      test("select * from tmp where d={d 1999-09-19}",
           "select * from tmp where d='19990919'");
      test("select * from tmp where a like '\\%%'", 
           "select * from tmp where a like '\\%%'");
      test("select * from tmp where a like 'b%%' {escape 'b'}", 
           "select * from tmp where a like '\\%%' ");
      test("select * from tmp where a like 'bbb' {escape 'b'}", 
           "select * from tmp where a like 'bbb' ");
      test("select * from tmp where a='{fn user}'",
           "select * from tmp where a='{fn user}'");
      test("select * from tmp where a={fn user()}",
           "select * from tmp where a= user_name() "); 
//      test("select * from tmp where a={fn ABS(foo)}",
//           "select * from tmp where a= abs(foo) ");


      System.out.println("Checking strings that should fail");
      checkBogus("select * from tmp where d={d 19990909}");

      System.out.println("\n" + (exitStatus==0 ? "Passed" : "Failed") 
                         + " t0006.\n");
      System.exit(exitStatus);
   }
}
