
import java.sql.*;




/**
 * test executing a prepared statement.
 * <p>
 * The prepared statement will
 * add a series of strings to the database.  Each consecutive string
 * will be longer than the previous string.
 *
 */
public class t0009
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      System.out.println(" * test executing a prepared statement.");

      boolean   passed = true;


      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      ResultSet   rs       = null;


      try
      {
         stmt.executeUpdate("drop table t0009");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0009', " +
                                      "because it does")))
         {
            throw e;
         }
      }

      count = stmt.executeUpdate("create table t0009              "
                                 + "  (i  integer  not null,      "
                                 + "   s  char(10) not null)      ");
      System.out.println("Creating table affected " + count + " rows");


      cx.setAutoCommit(false);

      PreparedStatement pStmt = cx.prepareStatement(
         "insert into t0009 values (?, ?)");

      int rowsToAdd = 8;
      final String theString = "abcdefghijklmnopqrstuvwxyz";
      count = 0;
      for(i=1; i<=rowsToAdd; i++)
      {
         pStmt.setInt(1, i);
         pStmt.setString(2, theString.substring(0, i));

         count += pStmt.executeUpdate();
      }
      cx.rollback();

      stmt = cx.createStatement();
      rs = stmt.executeQuery("select s, i from t0009");
      count = 0;
      while(rs.next())
      {
         System.out.println(rs.getString("i") + ":" +
                            rs.getString("s"));
         count ++;
      }
      passed = passed && (count==0);
      cx.commit();


      rowsToAdd = 6;
      count = 0;
      for(i=1; i<=rowsToAdd; i++)
      {
         pStmt.setInt(1, i);
         pStmt.setString(2, theString.substring(0, i));

         count += pStmt.executeUpdate();
      }
      cx.commit();

      rs = stmt.executeQuery("select s, i from t0009");
if (rs == null)
 {
    throw new SQLException("rs is null");
 }
      count = 0;
      while(rs.next())
      {
         System.out.println(rs.getString("i") + ":" +
                            rs.getString("s"));
         count++;
      }
      passed = passed && (count==rowsToAdd);
      cx.close();

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0009.\n");
      System.exit(passed ? 0 : 1);
   }
}


