
import java.sql.*;


/**
 * test a select with the 'for browse' option
 *
 */
public class t0014
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      System.out.println("test a select with the 'for browse' option");

      boolean  passed = true;

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0014");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0014', because it does")))
         {
            throw e;
         }
      }
      
      count = stmt.executeUpdate("create table t0014              "
                                 + "  (i  integer not null)       ");
      System.out.println("Creating table affected " + count + " rows");
      
      PreparedStatement  pStmt = cx.prepareStatement(
         "insert into t0014 values (?)");
      
      final int rowsToAdd = 100;
      count = 0;
      for(i=1; i<=rowsToAdd; i++)
      {
         pStmt.setInt(1, i);
         count += pStmt.executeUpdate();
      }
      System.out.println("Added " + count + " rows");
      if (count != rowsToAdd)
      {
         throw new Exception("Did not add the correct number of rows");
      }

      
      pStmt = cx.prepareStatement(
         "select i from t0014 for browse");
      ResultSet  rs = pStmt.executeQuery();
      count = 0;
      while(rs.next())
      {
         int   n = rs.getInt("i");
         System.out.println("row is " + n);
         count++;
      }
      passed = passed && (count==rowsToAdd);


      rs = stmt.executeQuery("select * from t0014");
      count = 0;
      while(rs.next())
      {
         int   n = rs.getInt("i");
         System.out.println("row is " + n);
         count++;
      }
      passed = passed && (count==rowsToAdd);

      rs = stmt.executeQuery("select * from t0014");
      count = 0;
      while(rs.next() && count<5)
      {
         int   n = rs.getInt("i");
         System.out.println("row is " + n);
         count++;
      }
      passed = passed && (count==5);

      rs = stmt.executeQuery("select * from t0014");
      count = 0;
      while(rs.next())
      {
         int   n = rs.getInt("i");
         System.out.println("row is " + n);
         count++;
      }
      passed = passed && (count==rowsToAdd);
      

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0014.\n");
      System.exit(passed ? 0 : 1);
   }
}

